/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components;

import java.awt.FocusTraversalPolicy;
import java.util.Set;
import oracle.bpm.data.html.TextType;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.components.PresentationLabel;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FocusTraversable;
import oracle.bpm.ui.FocusTraversableAdapter;
import oracle.bpm.ui.FormLayoutFocusTraversalPolicy;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class PresentationLink
extends PresentationLabel {
    public PresentationLink(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener l) {
        super(parent, object, showLines, showImages, l);
    }

    @Override
    protected Label buildLabel() {
        return Label.create((UiContainer)this, (Image)Image.create((Msg)WebformdesignerMsg.LINK));
    }

    @Override
    protected UiComponent buildComponent() {
        XFormLink formLink = (XFormLink)this.getReferencedObject();
        String textValue = formLink.getTextValue();
        TextArea textArea = new TextArea((UiContainer)this){

            public void paint(Graphics g) {
                super.paint(g);
                String text = this.getText();
                if (text == null) {
                    return;
                }
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int y1 = fm.getHeight() - fm.getDescent() + 1;
                int x2 = fm.stringWidth(text);
                if (text.length() > 0) {
                    g.drawLine(0, y1, x2, y1);
                }
            }
        };
        textArea.setText(textValue != null ? textValue : "");
        final Border editionBorder = UiManager.border((String)"Table.focusCellHighlightBorder");
        Insets insets = editionBorder == null ? null : editionBorder.getBorderInsets((UiComponent)textArea);
        final Border nullBorder = editionBorder == null ? null : BorderFactory.createEmptyBorder((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
        textArea.setBorder(nullBorder);
        textArea.setOpaque(false);
        textArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((TextArea)e.getSource()).selectAll();
                e.getSource().setBorder(editionBorder);
            }

            public void focusLost(FocusEvent e) {
                PresentationLink.this.update((TextArea)e.getSource());
                e.getSource().setBorder(nullBorder);
            }
        });
        if (this.isSwing()) {
            this.initFocus((UiComponent)textArea);
        }
        return textArea;
    }

    private void initFocus(final UiComponent component) {
        this.setFocusCycleRoot(true);
        FormLayoutFocusTraversalPolicy policy = new FormLayoutFocusTraversalPolicy((UiComponent)this, (FocusTraversable)new FocusTraversableAdapter(){

            public UiComponent getFirstComponent() {
                return component;
            }
        });
        policy.setImplicitDownCycleTraversal(false);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)policy);
        this.setFocusTraversalKeys(3, (Set)KeyStroke.Set.create().add(KeyEvent.F((int)2), 0).add(10, 0));
        component.setFocusTraversalKeys(2, (Set)KeyStroke.Set.create().add(27, 0));
    }

    private boolean isTextReference(XFormLink formLink) {
        String textType = formLink.getTextType();
        return textType != null && TextType.REFERENCE.equals(TextType.valueOf(textType));
    }

    private void update(TextArea component) {
        String newText;
        XFormLink formLink = (XFormLink)this.getReferencedObject();
        if (!this.isTextReference(formLink) && !(newText = component.getText()).equals(formLink.getTextValue())) {
            PresentationLink c;
            for (c = this; c != null && !(c instanceof PresentationPanel); c = c.getParent()) {
            }
            if (c != null) {
                ((PresentationPanel)((Object)c)).modifyValue(formLink, newText);
            } else {
                formLink.setTextValue(newText);
            }
        }
    }
}

