/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components;

import java.awt.FocusTraversalPolicy;
import java.util.HashSet;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FocusTraversable;
import oracle.bpm.ui.FocusTraversableAdapter;
import oracle.bpm.ui.FormLayoutFocusTraversalPolicy;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class PresentationLabel
extends PresentationComponent {
    public PresentationLabel(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener l) {
        super(parent, object, showLines, showImages, l);
    }

    public void setEditable(boolean editable) {
        if (this.getComponent() instanceof TextArea) {
            ((TextArea)this.getComponent()).setEditable(editable);
        }
    }

    @Override
    protected Label buildLabel() {
        return Label.create((UiContainer)this, (Image)Image.create((Msg)WebformdesignerMsg.LABEL));
    }

    @Override
    protected UiComponent buildComponent() {
        XFormLabel xFormLabel = (XFormLabel)this.getReferencedObject();
        String label = xFormLabel.value != null ? xFormLabel.value.value_d : "";
        final TextArea newComponent = xFormLabel.onclick != null || xFormLabel.link != null ? new TextArea((UiContainer)this, ScrollPolicy.NEVER, ScrollPolicy.NEVER, false){

            public void paint(Graphics g) {
                super.paint(g);
                String text = this.getText();
                if (text == null) {
                    return;
                }
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int y1 = fm.getHeight() - fm.getDescent() + 1;
                int x2 = fm.stringWidth(text);
                if (text.length() > 0) {
                    g.drawLine(0, y1, x2, y1);
                }
            }
        } : new TextArea((UiContainer)this, ScrollPolicy.NEVER, ScrollPolicy.NEVER, false);
        newComponent.setText(label);
        final Border editionBorder = UiManager.border((String)"Table.focusCellHighlightBorder");
        Insets insets = editionBorder == null ? null : editionBorder.getBorderInsets((UiComponent)newComponent);
        Border nullBorder = editionBorder == null ? null : BorderFactory.createEmptyBorder((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
        newComponent.setBorder(nullBorder);
        newComponent.setOpaque(false);
        newComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((TextArea)e.getSource()).selectAll();
                e.getSource().setBorder(editionBorder);
            }

            public void focusLost(FocusEvent e) {
                PresentationLabel.this.check();
            }
        });
        this.setFocusCycleRoot(true);
        FormLayoutFocusTraversalPolicy policy = new FormLayoutFocusTraversalPolicy((UiComponent)this, (FocusTraversable)new FocusTraversableAdapter(){

            public UiComponent getFirstComponent() {
                return newComponent;
            }
        });
        policy.setImplicitDownCycleTraversal(false);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)policy);
        if (this.isSwing()) {
            HashSet<KeyStroke> set = new HashSet<KeyStroke>();
            set.add(KeyStroke.getKeyStroke((int)KeyEvent.F((int)2), (int)0));
            set.add(KeyStroke.getKeyStroke((int)10, (int)0));
            this.setFocusTraversalKeys(3, set);
            HashSet<KeyStroke> labelSet = new HashSet<KeyStroke>();
            labelSet.add(KeyStroke.getKeyStroke((int)27, (int)0));
            newComponent.setFocusTraversalKeys(2, labelSet);
        }
        return newComponent;
    }

    private void check() {
        String text = this.isShowImages() ? ((Label)this.getComponent()).getText() : ((TextArea)this.getComponent()).getText();
        XFormLabel xFormLabel = (XFormLabel)this.getReferencedObject();
        if (xFormLabel.value.value_d == null || !xFormLabel.value.value_d.equals(text)) {
            PresentationLabel c;
            for (c = this; c != null && !(c instanceof PresentationPanel); c = c.getParent()) {
            }
            if (c != null) {
                ((PresentationPanel)((Object)c)).modifyValue(xFormLabel, text);
            } else {
                xFormLabel.value.value_d = text;
            }
        }
    }
}

