/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components;

import java.awt.FocusTraversalPolicy;
import java.util.Set;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FocusTraversable;
import oracle.bpm.ui.FocusTraversableAdapter;
import oracle.bpm.ui.FormLayoutFocusTraversalPolicy;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class PresentationImage
extends PresentationComponent {
    private TextField editorDisplay;
    private Label imageLabel;

    public PresentationImage(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener l) {
        super(parent, object, showLines, showImages, l);
    }

    public static float getAlignment(String aligment) {
        if (aligment != null) {
            if (aligment.equals("center")) {
                return 0.5f;
            }
            if (aligment.equals("left")) {
                return 0.0f;
            }
            if (aligment.equals("right")) {
                return 1.0f;
            }
        }
        return -1.0f;
    }

    public void rescale(Dimension dim) {
        if (!this.isShowImages()) {
            Image icon = this.imageLabel.getIcon();
            icon = icon.getScaledInstance(dim.getWidth(), dim.getHeight(), 4);
            this.imageLabel.setIcon(icon);
            this.imageLabel.setPreferredSize(dim);
        }
    }

    @Override
    protected Label buildLabel() {
        return Label.create((UiContainer)this, (Image)Image.create((Msg)WebformdesignerMsg.IMAGE));
    }

    @Override
    protected UiComponent buildComponent() {
        Panel mainPanel = new Panel((UiContainer)this);
        mainPanel.setFocusable(false);
        mainPanel.setOpaque(false);
        mainPanel.setLayout((Layout)new BoxLayout((UiContainer)mainPanel, 1));
        this.imageLabel = Label.create((UiContainer)mainPanel);
        this.imageLabel.setIcon(Image.create((Msg)WebformdesignerMsg.IMAGE));
        this.imageLabel.setOpaque(false);
        XFormImage xFormImage = (XFormImage)this.getReferencedObject();
        String gifEncoded = xFormImage.gifencoded;
        if (gifEncoded != null && !gifEncoded.trim().equals("")) {
            try {
                this.imageLabel.setIcon(Image.createFromBase64((String)gifEncoded));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        mainPanel.add((UiComponent)this.imageLabel);
        if (xFormImage.isEditable()) {
            this.editorDisplay = new TextField((UiContainer)mainPanel);
            this.editorDisplay.setOpaque(false);
            mainPanel.add((UiComponent)this.editorDisplay);
            this.initEditable((TextComponent)this.editorDisplay);
            this.initFocus();
            if (xFormImage.display != null && !xFormImage.display.equals("")) {
                this.editorDisplay.setText(xFormImage.display);
            } else {
                this.editorDisplay.setText(XObjectRuntimeMsg.CHANGE.getString());
            }
            PresentationImage.setAlign(xFormImage, this.editorDisplay);
            this.addListenerToSubcomponent((UiComponent)this.editorDisplay);
            this.addListenerToSubcomponent((UiComponent)this.imageLabel);
            this.imageLabel.setFocusable(false);
        }
        return mainPanel;
    }

    private static void setAlign(XFormImage xFormImage, TextField display) {
        float parseAlign = PresentationImage.getAlignment(xFormImage.getAlignment());
        if (parseAlign >= 0.0f) {
            int align = -1;
            if (parseAlign == 0.0f) {
                align = 2;
            } else if (parseAlign == 1.0f) {
                align = 4;
            } else if (parseAlign == 0.5f) {
                align = 0;
            }
            if (align >= 0) {
                display.setHorizontalAlignment(align);
            }
        }
    }

    private void check() {
        String display;
        String text;
        if (!this.isShowImages() && this.editorDisplay != null && !(text = this.editorDisplay.getText()).equals(display = ((XFormImage)this.getReferencedObject()).display)) {
            PresentationImage c;
            for (c = this; c != null && !(c instanceof PresentationPanel); c = c.getParent()) {
            }
            if (c != null) {
                ((PresentationPanel)((Object)c)).modifyProperty(this.getReferencedObject(), text, "display");
            } else {
                ((XFormImage)this.getReferencedObject()).display = text;
            }
        }
    }

    private void initEditable(final TextComponent editableLabel) {
        final Border editionBorder = UiManager.border((String)"Table.focusCellHighlightBorder");
        Insets insets = editionBorder == null ? null : editionBorder.getBorderInsets((UiComponent)editableLabel);
        final Border nullBorder = editionBorder == null ? null : BorderFactory.createEmptyBorder((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
        editableLabel.setBorder(nullBorder);
        editableLabel.setOpaque(false);
        editableLabel.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                editableLabel.selectAll();
                editableLabel.setBorder(editionBorder);
            }

            public void focusLost(FocusEvent e) {
                PresentationImage.this.check();
                editableLabel.setBorder(nullBorder);
            }
        });
    }

    private void initFocus() {
        this.setFocusCycleRoot(true);
        FormLayoutFocusTraversalPolicy policy = new FormLayoutFocusTraversalPolicy((UiComponent)this, (FocusTraversable)new FocusTraversableAdapter(){

            public UiComponent getFirstComponent() {
                return PresentationImage.this.editorDisplay;
            }
        });
        policy.setImplicitDownCycleTraversal(false);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)policy);
        this.setFocusTraversalKeys(3, (Set)KeyStroke.Set.create().add(KeyEvent.F((int)2), 0).add(10, 0));
        this.editorDisplay.setFocusTraversalKeys(2, (Set)KeyStroke.Set.create().add(27, 0));
    }
}

