/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components;

import java.util.List;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.components.PresentationCell;
import oracle.bpm.designer.formdesigner.editors.ComponentEditor;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.runtime.swing.DottedBorder;
import oracle.bpm.xobject.runtime.swing.XObjectBorderFactory;
import oracle.bpm.xobject.xml.XFormXMLObject;

public abstract class PresentationComponent
extends Panel {
    private UiComponent component;
    private ComponentEditor componentEditor;
    private ComponentProperties componentProperties;
    private Panel container;
    private Border defaultBorder;
    private EventListener eventListener;
    private boolean firstTime = true;
    private XFormPresentationXMLObject referencedObject;
    private boolean showBorder;
    private boolean showImages;
    private boolean showLines;
    private boolean showSelectionBorder;
    private Border thisBorder;
    private static final int INNER_SPACING = 1;
    private static final Transfer[] TRANSFERS = new Transfer[]{LocalObjectTransfer.getInstance(XFormPresentationXMLObject.class)};

    public PresentationComponent(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener listener) {
        super(parent);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout((Layout)new FlowLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PresentationComponent.this.requestFocus();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                PresentationComponent.this.repaintBorder();
            }

            public void focusLost(FocusEvent e) {
                PresentationComponent.this.repaintBorder();
            }
        });
        this.defaultBorder = super.getBorder();
        this.showImages = showImages;
        if (listener != null) {
            this.setEventListener(listener);
        }
        this.setOpaque(false);
        this.referencedObject = object;
        if (showLines) {
            this.showLines = showLines;
        }
        this.makeRecyclable();
        this.doInitObject();
        this.repaintBorder();
        this.eventListener.addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                if (PresentationComponent.this.isDisposed()) {
                    PresentationComponent.this.eventListener.removeSelectionListener(this);
                    return;
                }
                List selection = newSelection.asList(XFormSelection.class);
                boolean found = false;
                for (XFormSelection xFormSelection : selection) {
                    if (xFormSelection.getSelection() == null || !xFormSelection.getSelection().equals(PresentationComponent.this.referencedObject)) continue;
                    PresentationComponent.this.setSelectedBorder(true);
                    found = true;
                    break;
                }
                if (!found) {
                    PresentationComponent.this.setSelectedBorder(false);
                }
            }
        });
    }

    public void setBorder(javax.swing.border.Border b) {
        this.repaintBorder();
    }

    public UiComponent getComponent() {
        return this.component;
    }

    public void setContainer(Panel container) {
        this.container = container;
    }

    public Panel getContainer() {
        return this.container;
    }

    public boolean isContainer(XFormPresentationXMLObject object) {
        boolean result = false;
        if (this.getReferencedObject() != null && this.getReferencedObject().equals(object)) {
            result = true;
        } else if (this.getContainer() != null && this.getContainer() instanceof PresentationComponent) {
            result = ((PresentationComponent)this.getContainer()).isContainer(object);
        }
        return result;
    }

    public ComponentProperties getProperties(ComponentInteractionProvider provider, ChangeListener listener) {
        if (this.componentProperties == null) {
            this.componentProperties = this.componentEditor.createProperties(this.referencedObject, provider, listener);
        }
        return this.componentProperties;
    }

    public XFormPresentationXMLObject getReferencedObject() {
        return this.referencedObject;
    }

    public void setSelectedBorder(boolean b) {
        this.showSelectionBorder = b;
        this.repaintBorder();
    }

    public void setShowBorder(boolean border) {
        this.showBorder = border;
        this.repaintBorder();
    }

    public void setShowLines(boolean showLines) {
        this.showLines = showLines;
        this.repaintBorder();
    }

    public UiComponent add(UiComponent c) {
        if (!(this instanceof PresentationCell)) {
            c.setToolTipText(this.getToolTipText());
            this.addListenerToSubcomponent(c);
            if (this.thisBorder != null && this.thisBorder != this.defaultBorder) {
                c.setBorder(this.thisBorder);
                this.thisBorder = this.defaultBorder;
                this.repaintBorder();
            }
        }
        super.add(c);
        return c;
    }

    public void add(XFormPresentationXMLObject what) {
    }

    public void move(XFormPresentationXMLObject what) {
    }

    public void addListenerToSubcomponent(UiComponent c) {
        PresentationComponent source = this;
        this.addFocusListener(c);
        if (this.getEventListener() != null) {
            MouseListener m = new MouseListener((UiComponent)source){
                final /* synthetic */ UiComponent val$source;
                {
                    this.val$source = uiComponent;
                }

                private MouseEvent translate(MouseEvent e) {
                    UiComponent component = e.getSource();
                    MouseEvent newEvent = e.changeSource((Object)this.val$source);
                    newEvent.translatePoint(e.getX() + component.getX(), e.getY() + component.getY());
                    return newEvent;
                }

                private MouseEvent translateEvent(MouseEvent e) {
                    MouseEvent result = e.getSource() instanceof RadioButton ? this.translate(e) : e.changeSource((Object)this.val$source);
                    return result;
                }

                public void mouseClicked(MouseEvent e) {
                    PresentationComponent.this.getEventListener().mouseClicked(this.translateEvent(e));
                }

                public void mouseEntered(MouseEvent e) {
                    PresentationComponent.this.getEventListener().mouseEntered(this.translateEvent(e));
                }

                public void mouseExited(MouseEvent e) {
                    PresentationComponent.this.getEventListener().mouseExited(this.translateEvent(e));
                }

                public void mousePressed(MouseEvent e) {
                    PresentationComponent.this.getEventListener().mousePressed(this.translateEvent(e));
                }

                public void mouseDoubleClicked(MouseEvent e) {
                    PresentationComponent.this.getEventListener().mouseDoubleClicked(this.translateEvent(e));
                }

                public void mouseReleased(MouseEvent e) {
                    PresentationComponent.this.getEventListener().mouseReleased(this.translateEvent(e));
                }
            };
            c.addMouseListener(m);
        }
    }

    public void copy(XFormPresentationXMLObject what) {
    }

    public void reload(XFormXMLObject referencedObject) {
        this.referencedObject = (XFormPresentationXMLObject)referencedObject;
        this.doInitObject();
        this.repaintBorder();
    }

    public void showProperties(PropertyTable table, ComponentInteractionProvider provider, ChangeListener listener) {
        if (this.componentProperties == null) {
            this.componentProperties = this.getProperties(provider, listener);
        }
        this.componentProperties.showProperties(table);
    }

    public void setBorderStyle(Border outerBorder) {
        super.setBorder(outerBorder);
    }

    public void setComponentEditor(ComponentEditor componentEditor) {
        this.componentEditor = componentEditor;
    }

    protected EventListener getEventListener() {
        return this.eventListener;
    }

    protected boolean isShowImages() {
        return this.showImages;
    }

    protected UiComponent buildComponent() {
        return null;
    }

    protected Label buildLabel() {
        return null;
    }

    protected void repaintBorder() {
        DottedBorder outerBorder;
        boolean hasFocus = false;
        Color focusColor = Color.BLUE;
        Border currentBorder = this.thisBorder;
        if (currentBorder == null) {
            currentBorder = this.showBorder ? (hasFocus ? BorderFactory.createEtchedBorder((Color)focusColor, (Color)focusColor.darker()) : BorderFactory.createEtchedBorder()) : BorderFactory.createEmptyBorder();
        }
        DottedBorder dottedBorder = hasFocus ? new DottedBorder(focusColor, 1, false, 4, 2) : (outerBorder = this.showLines ? DottedBorder.createDarkGrayLineBorder() : BorderFactory.createEmptyBorder((int)1));
        if (this.showSelectionBorder) {
            outerBorder = hasFocus ? DottedBorder.createThickLineBorder((Color)focusColor) : DottedBorder.createBlackThickLineBorder();
        } else {
            int width = 2;
            outerBorder = BorderFactory.createCompoundBorder((Border)BorderFactory.createEmptyBorder((int)width), (Border)outerBorder);
        }
        if (currentBorder != null) {
            Border emptyBorder = BorderFactory.createEmptyBorder((int)1);
            Border temp = BorderFactory.createCompoundBorder((Border)outerBorder, (Border)emptyBorder);
            this.setBorderStyle(BorderFactory.createCompoundBorder((Border)temp, (Border)currentBorder));
        } else {
            this.setBorderStyle((Border)outerBorder);
        }
        this.getParent().repaint();
    }

    boolean isDragable() {
        return true;
    }

    private void setEventListener(EventListener listener) {
        if (listener != null) {
            this.eventListener = listener;
            this.addMouseListener(this.eventListener);
        }
    }

    private void addFocusListener(UiComponent c) {
        if (!(c instanceof TextComponent) || !((TextComponent)c).isEditable()) {
            MouseAdapter adapter = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    PresentationComponent.this.requestFocus();
                }
            };
            c.addMouseListener((MouseListener)adapter);
            if (c instanceof UiContainer) {
                UiContainer cont = (UiContainer)c;
                int count = cont.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    this.addFocusListener(cont.getComponent(i));
                }
            }
        }
    }

    private void initText() {
        if (this.referencedObject != null) {
            String tooltip = "";
            if (this.referencedObject.getId() != null) {
                tooltip = tooltip + ProjectDrawMsg.NAME.getString() + ": " + this.referencedObject.getId();
            }
            if (this.referencedObject.getReference() != null) {
                tooltip = tooltip + "\n" + DesignerMsg.REFERENCE.getString() + ": " + this.referencedObject.getReference();
            }
            if (!Str.isEmpty(tooltip)) {
                this.setToolTipText(tooltip);
            }
        }
    }

    private void initBorder() {
        if (this.referencedObject instanceof BorderProperties) {
            Border b = XObjectBorderFactory.getBorder((BorderProperties)((BorderProperties)((Object)this.referencedObject)));
            if (b != null) {
                this.thisBorder = b;
                this.setBorderStyle(b);
            } else {
                this.thisBorder = this.defaultBorder;
            }
        }
    }

    private void doInitObject() {
        this.initText();
        this.initBorder();
        Object object = this.component = this.isShowImages() ? this.buildLabel() : this.buildComponent();
        if (this.component != null) {
            this.component.makeRecyclable();
            this.add(this.component);
            if (this.isDragable()) {
                try {
                    this.initDndRecursively((UiComponent)this);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    private void initDndRecursively(UiComponent component) {
        if (!this.firstTime) {
            return;
        }
        this.firstTime = false;
        new DragSourceHandler(component, DndAction.MOVE, TRANSFERS){
            public XFormPresentationXMLObject formPresentationXMLObject;

            public Object getObject(Transfer transfer) {
                XFormPresentationXMLObject result = transfer == LocalObjectTransfer.getInstance(XFormPresentationXMLObject.class) ? (this.formPresentationXMLObject = PresentationComponent.this.getReferencedObject()) : null;
                return result;
            }

            public void dragFinished(DndAction action) {
                if (action == DndAction.MOVE) {
                    XFormPresentationXMLObject what = (XFormPresentationXMLObject)action.getTransferredObject();
                    if (what == null) {
                        what = this.formPresentationXMLObject;
                    }
                    PresentationComponent.this.getEventListener().remove(what);
                }
            }
        };
        if (component instanceof UiContainer) {
            UiContainer container = (UiContainer)component;
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.initDndRecursively(container.getComponent(i));
            }
        }
    }
}

