/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components;

import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.PresentationDataPanel;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.components.dnd.MemberComponentBuilder;
import oracle.bpm.designer.formdesigner.editors.CellComponentEditor;
import oracle.bpm.designer.formdesigner.model.ComponentType;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.xobject.presentationmodel.XFormArrayComponent;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class PresentationCell
extends PresentationComponent {
    private CellComponentEditor.CellEditorData cellEditorData;
    private PresentationDataPanel dataPanel;

    public PresentationCell(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener l) {
        super(parent, object, showLines, showImages, l);
        this.initDrop();
    }

    public boolean acceptObject(XFormPresentationXMLObject object) {
        boolean isInArray = this.cellEditorData != null && this.cellEditorData.isInArray();
        return !isInArray || object instanceof XFormArrayComponent;
    }

    @Override
    public UiComponent add(UiComponent component) {
        XFormCell xFormCell = (XFormCell)this.getReferencedObject();
        String horizontalAlign = xFormCell.getAlignment();
        String verticalAlign = xFormCell.getValignment();
        FormLayout layout = new FormLayout("5dlu, " + horizontalAlign + ":pref:grow, 5dlu", "5dlu, " + verticalAlign + ":pref:grow, 5dlu");
        this.setLayout((Layout)layout);
        super.add(component, (Object)layout.createCellConstraints(2, 2));
        return component;
    }

    @Override
    public void add(XFormPresentationXMLObject what) {
        if (((XFormCell)this.getReferencedObject()).hasSpace() && this.getEventListener() != null) {
            this.getEventListener().add(what, this.getReferencedObject());
        }
    }

    @Override
    public void move(XFormPresentationXMLObject what) {
        if (((XFormCell)this.getReferencedObject()).hasSpace() && this.getEventListener() != null) {
            this.getEventListener().move(what, this.getReferencedObject());
        }
    }

    @Override
    public void copy(XFormPresentationXMLObject what) {
        if (((XFormCell)this.getReferencedObject()).hasSpace()) {
            XFormPresentationXMLObject xmlObjectCopy = what.clone();
            if (this.getEventListener() != null) {
                this.getEventListener().add(xmlObjectCopy, this.getReferencedObject());
            }
        }
    }

    public CellComponentEditor.CellEditorData getCellEditorData() {
        return this.cellEditorData;
    }

    public void setCellEditorData(CellComponentEditor.CellEditorData cellEditorData) {
        this.cellEditorData = cellEditorData;
    }

    public void setDataPanel(PresentationDataPanel dataPanel) {
        this.dataPanel = dataPanel;
    }

    @Override
    boolean isDragable() {
        return false;
    }

    private void initDrop() {
        Transfer[] transfers = new Transfer[]{LocalObjectTransfer.getInstance(MethodTypeDescription.class), LocalObjectTransfer.getInstance(XFormPresentationXMLObject.class)};
        new DropTargetHandler((UiComponent)this, DndAction.MOVE, transfers){
            public XFormPresentationXMLObject transferred;

            public boolean canImport(Object data, Transfer transfer, Point point) {
                boolean result;
                boolean bl = result = PresentationCell.this.dataPanel.isEditable() && this.cellHasSpace();
                if (data != null) {
                    if (data instanceof XFormPresentationXMLObject) {
                        XFormPresentationXMLObject transferred = (XFormPresentationXMLObject)data;
                        result = result || this.cellContains(transferred);
                    } else if (data instanceof MethodTypeDescription) {
                        MethodTypeDescription mtd = (MethodTypeDescription)data;
                        result = result && mtd.isAttribute() && MemberComponentBuilder.canCreateXFormComponent(mtd, PresentationCell.this, PresentationCell.this.dataPanel);
                    }
                }
                return result;
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                boolean componentHasRoom;
                boolean result = true;
                XFormPresentationXMLObject formPresentationXMLObject = PresentationCell.this.getReferencedObject();
                boolean bl = componentHasRoom = formPresentationXMLObject.getChildCount() < 1;
                if (data instanceof XFormPresentationXMLObject) {
                    XFormPresentationXMLObject dataToTransfer = (XFormPresentationXMLObject)data;
                    Class requiredClass = ComponentType.get(dataToTransfer.getComponentID()).requires();
                    result = formPresentationXMLObject.getClass() == requiredClass && componentHasRoom;
                } else if (data instanceof MethodTypeDescription) {
                    MethodTypeDescription mtd = (MethodTypeDescription)data;
                    this.transferred = MemberComponentBuilder.createXFormComponent(mtd, PresentationCell.this, PresentationCell.this.dataPanel);
                    if (this.transferred == null || !componentHasRoom) {
                        result = false;
                    }
                }
                return result;
            }

            public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                if (data instanceof XFormPresentationXMLObject) {
                    this.transferred = (XFormPresentationXMLObject)data;
                    PresentationCell.this.copy(this.transferred);
                } else if (data instanceof MethodTypeDescription && this.transferred != null) {
                    PresentationCell.this.add(this.transferred);
                }
                dndAction.setTransferredObject((Object)this.transferred);
            }

            private boolean cellContains(XFormPresentationXMLObject transferred) {
                return ((XFormCell)PresentationCell.this.getReferencedObject()).getComponent() == transferred;
            }

            private boolean cellHasSpace() {
                return ((XFormCell)PresentationCell.this.getReferencedObject()).hasSpace();
            }
        };
    }
}

