/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.components;

import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class PresentationButton
extends PresentationComponent {
    public PresentationButton(UiContainer parent, XFormPresentationXMLObject object, boolean showLines, boolean showImages, EventListener l) {
        super(parent, object, showLines, showImages, l);
    }

    @Override
    protected UiComponent buildComponent() {
        XFormButton object = (XFormButton)this.getReferencedObject();
        Label button = Label.create((UiContainer)this);
        button.setEnabled(false);
        Border border = BorderFactory.createCompoundBorder((Border)BorderFactory.createRaisedBevelBorder(), (Border)BorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        button.setBorder(border);
        String text = object.display != null ? object.display : object.action;
        button.setText(text);
        return button;
    }

    @Override
    protected Label buildLabel() {
        Msg iconMsg = WebformdesignerMsg.BUTTON;
        XFormButton object = (XFormButton)this.getReferencedObject();
        String action = object.action;
        if (action != null) {
            String[] possibleActions = XFormButton.possibleAction_d;
            iconMsg = action.equals(possibleActions[2]) ? WebformdesignerMsg.RESET_BUTTON : (action.equals(possibleActions[0]) ? WebformdesignerMsg.SUBMIT_BUTTON : (action.equals(possibleActions[1]) ? WebformdesignerMsg.CANCEL_BUTTON : (action.equals(possibleActions[3]) ? WebformdesignerMsg.REFRESH_BUTTON : (action.equals(possibleActions[5]) ? DesignerMsg.SAVE_BUTTON : (action.equals(possibleActions[6]) ? DesignerMsg.PRINT_BUTTON : (action.equals(possibleActions[4]) ? WebformdesignerMsg.CUSTOM_BUTTON : WebformdesignerMsg.BUTTON))))));
        }
        return Label.create((UiContainer)this, (Image)Image.create((Msg)iconMsg));
    }
}

