/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import oracle.bpm.data.html.LinkType;
import oracle.bpm.data.html.TextType;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRadio;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormValue;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ReplaceDataCommand
extends AddDataCommand {
    private boolean copyProperties;
    private XFormPresentationXMLObject xmlObject;

    public ReplaceDataCommand(XFormXMLObject xmlObject, XFormPresentationXMLObject what, boolean copyProperties, PresentationStructureView view) {
        super(xmlObject, what, view);
        this.copyProperties = copyProperties;
    }

    @Override
    public Msg getMsg() {
        String what = this.xmlObject == null ? "" : this.xmlObject.getName();
        String newWhat = this.getAddedObject() == null ? "" : this.getAddedObject().getName();
        return DesignerMsg.REPLACE_COMMAND(what, newWhat, this.getParentXmlObject() + "");
    }

    public boolean checkValidValues(String attributeName) {
        MethodTypeDescription member = this.getMemberFor(attributeName);
        XFormXMLObject addedObject = this.getAddedObject();
        boolean needsValidValues = addedObject instanceof XFormCombo || addedObject instanceof XFormRadio;
        return member != null && (!needsValidValues || member.asAttribute().hasValidValues());
    }

    @Override
    public boolean performCommand() {
        XFormXMLObject child;
        boolean result = false;
        if (this.getParentXmlObject().getChildCount() == 1 && (child = this.getParentXmlObject().getChildAt(0)) instanceof XFormPresentationXMLObject) {
            this.xmlObject = (XFormPresentationXMLObject)child;
            this.removeObjectFromTree(this.getParentXmlObject(), this.xmlObject, super.getView(), false);
            result = super.doAdd(this.isFireEvents());
        }
        return result;
    }

    @Override
    public boolean undoIt() {
        boolean result;
        if (this.xmlObject == null) {
            result = false;
        } else {
            result = super.undoAdd(false);
            this.getView().addObject(this.getParentXmlObject(), this.xmlObject);
        }
        return result;
    }

    @Override
    protected void applyOptions(Object whatObject) {
        if (this.copyProperties) {
            this.copyProperties(whatObject, this.xmlObject);
        } else {
            super.applyOptions(whatObject);
        }
    }

    @Override
    protected boolean useOptions() {
        return this.copyProperties || super.useOptions();
    }

    private MethodTypeDescription getMemberFor(String attributeName) {
        return XObjectTypeDescriptionHelper.getMemberFor((String)attributeName, (ObjectTypeDescription)this.getView().getObjectTypeDescription());
    }

    private boolean isCompatibleReferencedDataField(String fieldName) {
        try {
            Field f = this.xmlObject.getClass().getField(fieldName);
            Object object = f.get(this.xmlObject);
            if (object instanceof String) {
                int[] possibleRefering;
                String referenceName = (String)object;
                int kind = this.getKind(referenceName);
                boolean isCompatible = false;
                for (int possibleReference : possibleRefering = this.getPossibleReffering(this.getAddedObject().getClass())) {
                    if (possibleReference != kind) continue;
                    isCompatible = true;
                    break;
                }
                return isCompatible && this.checkValidValues(referenceName);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getKind(String attributeName) {
        MethodTypeDescription member = this.getMemberFor(attributeName);
        return member.getResultType().getKind();
    }

    private int[] getPossibleReffering(Class clazz) {
        int[] result;
        try {
            Field field = clazz.getField("possibleReffering_d");
            result = (int[])field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new int[]{};
        }
        return result;
    }

    private boolean isReferencedDataField(Field f) {
        return f.getName().equals("reference");
    }

    private void copyProperties(Object dest, Object src) {
        this.reflectionCopyProperties(dest, src);
        this.matchingCopyProperties(dest, src);
    }

    private Field get(Object dest, String[] strings) {
        Field result = null;
        for (int i = 0; i < strings.length && (result = this.get(dest, strings, i)) == null; ++i) {
        }
        return result;
    }

    private Field get(Object dest, String[] strings, int index) {
        Field result;
        try {
            result = dest.getClass().getField(strings[index]);
        }
        catch (NoSuchFieldException e) {
            result = null;
        }
        return result;
    }

    private void matchingCopyProperties(Object destination, Object source) {
        try {
            String ref;
            XFormXMLObject value;
            Field sourceField;
            Field destinationField = null;
            destinationField = this.get(destination, new String[]{"onclick", "onchange"});
            if (destinationField != null) {
                sourceField = this.get(source, new String[]{"methodinvocation", "onclick", "onchange"});
                if (sourceField != null && !destinationField.getName().equals(sourceField.getName())) {
                    destinationField.set(destination, sourceField.get(source));
                }
            } else {
                destinationField = this.get(destination, new String[]{"methodinvocation"});
                if (destinationField != null && (sourceField = this.get(source, new String[]{"onclick", "onchange"})) != null) {
                    destinationField.set(destination, sourceField.get(source));
                    Field f = destination.getClass().getField("action");
                    if (f != null) {
                        f.set(destination, XFormButton.possibleAction_d[4]);
                    }
                }
            }
            if ((destinationField = this.get(destination, new String[]{"value"})) != null) {
                sourceField = this.get(source, new String[]{"display"});
                if (sourceField != null && !destinationField.getName().equals(sourceField.getName())) {
                    String display = (String)sourceField.get(source);
                    XFormValue value2 = new XFormValue();
                    value2.value_d = display;
                    destinationField.set(destination, value2);
                }
            } else {
                destinationField = this.get(destination, new String[]{"display"});
                if (destinationField != null && (sourceField = this.get(source, new String[]{"value"})) != null) {
                    value = (XFormValue)sourceField.get(source);
                    String display = value != null ? ((XFormValue)value).value_d : "";
                    destinationField.set(destination, display);
                }
            }
            if (source instanceof XFormLink) {
                XFormLink link = (XFormLink)source;
                String reference = null;
                if (link.getEnumLinkType() == LinkType.REFERENCE) {
                    reference = link.getLinkValue();
                } else if (link.getEnumTextType() == TextType.REFERENCE) {
                    reference = link.getTextValue();
                }
                if (reference != null && (destinationField = this.get(destination, new String[]{"reference"})) != null) {
                    destinationField.set(destination, reference);
                }
            }
            if (destination instanceof XFormLink && source instanceof XFormUserInputPresentationXMLObject && (ref = (value = (XFormUserInputPresentationXMLObject)source).getReference()) != null) {
                destinationField = this.get(destination, new String[]{"textvalue_d"});
                if (destinationField != null) {
                    destinationField.set(destination, ref);
                    destinationField = this.get(destination, new String[]{"texttype_d"});
                    if (destinationField != null) {
                        destinationField.set(destination, TextType.REFERENCE.name());
                    }
                }
                if ((destinationField = this.get(destination, new String[]{"linkvalue_d"})) != null) {
                    destinationField.set(destination, ref);
                    destinationField = this.get(destination, new String[]{"linktype_d"});
                    if (destinationField != null) {
                        destinationField.set(destination, TextType.REFERENCE.name());
                    }
                }
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void reflectionCopyProperties(Object dest, Object src) {
        try {
            Field[] destFields;
            for (Field destField : destFields = dest.getClass().getFields()) {
                if (Modifier.isStatic(destField.getModifiers())) continue;
                String name = destField.getName();
                if (this.isReferencedDataField(destField) && !this.isCompatibleReferencedDataField(name) || this.skipField(name)) continue;
                try {
                    Field f = src.getClass().getField(name);
                    Object value = f.get(src);
                    if (value == null) continue;
                    if (dest instanceof XFormXMLObject) {
                        ModifyPropertyValueCommand command = new ModifyPropertyValueCommand((XFormXMLObject)dest, value, name);
                        command.doIt();
                        continue;
                    }
                    destField.set(dest, value);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            Log.logWarning(e);
        }
    }

    private boolean skipField(String name) {
        return "type".equals(name);
    }
}

