/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.ClearDataCommand;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class RemoveColumnCommand
extends CompoundCommand {
    private int columnsToRemove;
    private XFormXMLObject parentTable;
    private int removeColumnLocation;
    private PresentationStructureView view;

    public RemoveColumnCommand(PresentationStructureView view, int removeColumnLocation, int count, XFormXMLObject parentTable) {
        super(new ArrayList(), DesignerMsg.REMOVE_COLUMN);
        this.view = view;
        this.removeColumnLocation = removeColumnLocation;
        this.columnsToRemove = count;
        this.parentTable = parentTable;
        this.createCommands();
    }

    @Override
    public boolean undoIt() {
        boolean result = super.undoIt();
        this.view.getChangeListener().changeOccured(ChangeListener.EventFactory.createChange(this.parentTable));
        return result;
    }

    @Override
    public boolean doIt() {
        boolean result = super.doIt();
        this.view.getChangeListener().changeOccured(ChangeListener.EventFactory.createChange(this.parentTable));
        return result;
    }

    @Override
    public Msg getMsg() {
        if (this.columnsToRemove == 1) {
            return DesignerMsg.REMOVE_COLUMN;
        }
        return DesignerMsg.REMOVE_COLUMNS;
    }

    private void createCommands() {
        XFormTable theTable = (XFormTable)this.parentTable;
        if (theTable != null && theTable.row != null) {
            for (int i = 0; i < theTable.row.length; ++i) {
                this.removeFromRow(theTable.row[i]);
            }
        }
    }

    private void removeFromRow(XFormRow eachRow) {
        int currentCount = 0;
        Command command = null;
        int leftToRemove = this.columnsToRemove;
        if (eachRow != null && eachRow.cell != null) {
            for (int j = 0; leftToRemove > 0 && j < eachRow.cell.length; ++j) {
                XFormCell currentCell = eachRow.cell[j];
                int currentHExpand = this.getFixedHExpand(currentCell);
                if (currentCount + currentHExpand >= this.removeColumnLocation) {
                    if (currentHExpand <= leftToRemove) {
                        command = new ClearDataCommand(this.view, currentCell, false, false);
                        leftToRemove -= currentHExpand;
                    } else {
                        command = this.createCompactCellCommand(currentCell, currentHExpand - leftToRemove);
                        leftToRemove = 0;
                    }
                    this.addCommand(command);
                }
                currentCount += currentHExpand;
            }
        }
    }

    private Command createCompactCellCommand(XFormCell currentCell, int newHexpand) {
        return new ModifyPropertyValueCommand(currentCell, newHexpand, "hexpand", null);
    }

    private int getFixedHExpand(XFormCell currentCell) {
        int currentHExpand = currentCell.hexpand;
        if (currentHExpand <= 0) {
            currentHExpand = 1;
        }
        return currentHExpand;
    }
}

