/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class MoveNodeCommand
extends Command {
    private ChangeListener changeListener;
    private XFormXMLObject[] treeNodes;
    private int undoCount;
    private PresentationStructureView view;
    private int where = -1;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int BOTTOM = 2;
    public static final int TOP = 3;

    public MoveNodeCommand(XFormXMLObject dataModelTreeNode, int where, ChangeListener changeListener, PresentationStructureView view) {
        this(new XFormXMLObject[]{dataModelTreeNode}, where, changeListener, view);
    }

    public MoveNodeCommand(XFormXMLObject[] dataModelTreeNodes, int where, ChangeListener changeListener, PresentationStructureView view) {
        this.where = where;
        this.treeNodes = dataModelTreeNodes;
        this.changeListener = changeListener;
        this.view = view;
        this.undoCount = 0;
    }

    public boolean moveNode(XFormXMLObject treeNode, boolean up, PresentationStructureView view, boolean notify) {
        return this.nodeMovement(treeNode, up, view, notify);
    }

    @Override
    public Msg getMsg() {
        String treeNodeName = this.treeNodes.length == 1 ? this.treeNodes[0].toString() : DesignerMsg.SEVERAL.toString();
        switch (this.where) {
            case 3: {
                return DesignerMsg.MOVE_TOP_COMMAND(treeNodeName);
            }
            case 2: {
                return DesignerMsg.MOVE_BOTTOM_COMMAND(treeNodeName);
            }
            case 0: {
                return DesignerMsg.MOVE_UP_COMMAND(treeNodeName);
            }
        }
        return DesignerMsg.MOVE_DOWN_COMMAND(treeNodeName);
    }

    @Override
    public boolean doIt() {
        if (this.where == 0 || this.where == 1) {
            return this.treeNodes.length == 1 ? this.moveNode(this.treeNodes[0], this.where == 0, this.view, true) : this.moveNodes(this.treeNodes, this.where == 0, true);
        }
        if (this.treeNodes.length == 1) {
            while (this.moveNode(this.treeNodes[0], this.where == 3, this.view, false)) {
                ++this.undoCount;
            }
            this.notifyListeners(this.treeNodes[0].getParent());
        } else {
            while (this.moveNodes(this.treeNodes, this.where == 3, true)) {
                ++this.undoCount;
            }
        }
        return true;
    }

    @Override
    public boolean undoIt() {
        if (this.where == 0 || this.where == 1) {
            return this.treeNodes.length == 1 ? this.moveNode(this.treeNodes[0], this.where != 0, this.view, true) : this.moveNodes(this.treeNodes, this.where != 0, true);
        }
        if (this.treeNodes.length == 1) {
            for (int i = 0; i < this.undoCount; ++i) {
                this.moveNode(this.treeNodes[0], this.where != 3, this.view, false);
                this.notifyListeners(this.treeNodes[0].getParent());
            }
        } else {
            for (int i = 0; i < this.undoCount; ++i) {
                this.moveNodes(this.treeNodes, this.where != 3, true);
            }
        }
        this.undoCount = 0;
        return true;
    }

    public boolean moveNodes(XFormXMLObject[] treeNode, boolean up, boolean notify) {
        boolean result = true;
        if (up) {
            for (int i = 0; i < treeNode.length; ++i) {
                result = result && this.nodeMovement(treeNode[i], up, this.view, notify);
            }
        } else {
            for (int i = treeNode.length - 1; i >= 0; --i) {
                result = result && this.nodeMovement(treeNode[i], up, this.view, notify);
            }
        }
        return result;
    }

    private boolean nodeMovement(XFormXMLObject treeNode, boolean up, PresentationStructureView view, boolean notify) {
        XFormXMLObject parent = treeNode.getParent();
        boolean result = parent.move(treeNode, up);
        if (result) {
            if (treeNode instanceof XFormCell && parent instanceof XFormRow && parent.getParent() instanceof XFormArray) {
                XFormArray array = (XFormArray)parent.getParent();
                int index = parent.getIndex(treeNode);
                if (index >= 0) {
                    int indexFrom = index++;
                    int indexTo = up ? index : --index;
                    String temp = array.headers[indexFrom];
                    int tempInt = array.headerswidth[indexFrom];
                    array.headers[indexFrom] = array.headers[indexTo];
                    array.headerswidth[indexFrom] = array.headerswidth[indexTo];
                    array.headers[indexTo] = temp;
                    array.headerswidth[indexTo] = tempInt;
                }
            }
            view.getTree().moveTreeNode(view.getNode(treeNode), up);
            if (notify) {
                this.notifyListeners(parent);
            }
        }
        return result;
    }

    private void notifyListeners(XFormXMLObject parent) {
        if (this.changeListener != null) {
            this.changeListener.changeOccured(ChangeListener.EventFactory.createChange(parent));
        }
    }
}

