/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import oracle.bpm.designer.formdesigner.command.DataCommand;
import oracle.bpm.designer.formdesigner.model.ComponentType;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.preferences.Utils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class MoveDataCommand
extends DataCommand {
    private XFormXMLObject oldObject = null;
    private XFormXMLObject oldParent = null;
    private XFormXMLObject parent;
    private XFormXMLObject undoResult = null;
    private PresentationStructureView view;
    private XFormPresentationXMLObject whatObject;

    public MoveDataCommand(PresentationStructureView view, XFormXMLObject dataModelTreeNode, XFormPresentationXMLObject what) {
        super(view.getChangeListener());
        this.parent = dataModelTreeNode;
        this.whatObject = what;
        this.view = view;
        this.oldObject = what;
        this.oldParent = this.oldObject.getParent();
    }

    @Override
    public Msg getMsg() {
        ComponentType type = ComponentType.get(this.whatObject);
        Msg whatObjectMsg = type.getMsg();
        return DesignerMsg.MOVE_COMMAND(Utils.getString(whatObjectMsg), this.oldParent + "", this.parent + "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doIt() {
        this.removeObjectFromTree(this.oldParent, this.oldObject, this.view, false);
        try {
            if (this.undoResult != null) {
                this.view.putNode(this.parent, this.undoResult, this.isFireEvents());
                return true;
            }
            if (this.whatObject != null) {
                this.undoResult = this.view.addObject(this.parent, this.whatObject, this.isFireEvents());
                return true;
            }
            this.view.putNode(this.oldParent, this.oldObject, this.isFireEvents());
            return false;
        }
        catch (Exception e) {
            this.view.putNode(this.oldParent, this.oldObject, this.isFireEvents());
            return false;
        }
    }

    @Override
    public boolean undoIt() {
        if (this.undoResult == null) {
            return false;
        }
        this.removeObjectFromTree(this.parent, this.undoResult, this.view, false);
        this.view.putNode(this.oldParent, this.oldObject, this.isFireEvents());
        return true;
    }
}

