/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ModifyPropertyValueCommand
extends Command {
    private ChangeListener listener;
    private Object newValue;
    private Object oldValue;
    private String propertyName;
    private Field theField;
    private Method theSetter;
    private XFormXMLObject whichObject;

    public ModifyPropertyValueCommand(XFormXMLObject which, Object value, String propertyName) {
        this.newValue = value;
        this.whichObject = which;
        this.propertyName = propertyName;
    }

    public ModifyPropertyValueCommand(XFormXMLObject which, Object value, String propertyName, ChangeListener listener) {
        this.newValue = value;
        this.whichObject = which;
        this.propertyName = propertyName;
        this.listener = listener;
    }

    @Override
    public boolean doIt() {
        try {
            Method setter = null;
            String setterName = this.getSetterName();
            if (this.newValue != null) {
                Class<Object> c = this.newValue.getClass();
                if (c == Integer.class) {
                    c = Integer.TYPE;
                } else if (c == Double.class) {
                    c = Double.TYPE;
                }
                setter = this.whichObject.getClass().getMethod(setterName, c);
            } else {
                Method[] methods = this.whichObject.getClass().getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(setterName) || methods[i].getParameterTypes().length != 1) continue;
                    if (setter != null) {
                        setter = null;
                        break;
                    }
                    setter = methods[i];
                }
            }
            Method getter = this.whichObject.getClass().getMethod(this.getGetterName(), null);
            this.oldValue = getter.invoke((Object)this.whichObject, (Object[])null);
            setter.invoke((Object)this.whichObject, this.newValue);
            this.theSetter = setter;
        }
        catch (Exception e) {
            try {
                Field f = this.whichObject.getClass().getField(this.propertyName.toLowerCase());
                this.oldValue = f.get(this.whichObject);
                f.set(this.whichObject, this.newValue);
                this.theField = f;
            }
            catch (Exception e1) {
                try {
                    Field f = this.whichObject.getClass().getField(this.propertyName.toLowerCase() + "_d");
                    this.oldValue = f.get(this.whichObject);
                    f.set(this.whichObject, this.newValue);
                    this.theField = f;
                }
                catch (Exception e2) {
                    return false;
                }
            }
        }
        this.notifyListener(this.newValue);
        return true;
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.MODIFIED_VALUE_COMMAND(this.propertyName, this.oldValue + "", this.newValue + "");
    }

    @Override
    public boolean undoIt() {
        if (this.theSetter != null) {
            try {
                this.theSetter.invoke((Object)this.whichObject, this.oldValue);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        } else if (this.theField != null) {
            try {
                this.theField.set(this.whichObject, this.oldValue);
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        this.notifyListener(this.oldValue);
        return true;
    }

    private static String getName(String name) {
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        return name;
    }

    private String getGetterName() {
        return "get" + ModifyPropertyValueCommand.getName(this.propertyName);
    }

    private String getSetterName() {
        return "set" + ModifyPropertyValueCommand.getName(this.propertyName);
    }

    private void notifyListener(Object value) {
        if (this.listener != null) {
            ChangeListener.ChangeEvent change = ChangeListener.EventFactory.createChange(this.propertyName, value, this.whichObject);
            this.listener.changeOccured(change);
        }
    }
}

