/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.lang.reflect.Field;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormValue;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ModifyObjectValueCommand
extends Command {
    ChangeListener listener;
    String newValue;
    String oldValue;
    XFormXMLObject whichObject;
    private PresentationStructureView view;

    public ModifyObjectValueCommand(XFormXMLObject which, String value, ChangeListener listener, PresentationStructureView view) {
        this.newValue = value;
        this.whichObject = which;
        this.listener = listener;
        this.view = view;
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.MODIFIED_COMMAND(this.oldValue, this.newValue);
    }

    @Override
    public boolean doIt() {
        try {
            Field f = this.whichObject.getClass().getField("value");
            XFormValue val = (XFormValue)f.get(this.whichObject);
            this.oldValue = val.value_d;
            val.value_d = this.newValue;
        }
        catch (Exception e) {
            try {
                Field f = this.whichObject.getClass().getField("value_entity_d");
                XFormValue val = (XFormValue)f.get(this.whichObject);
                this.oldValue = val.value_d;
                val.value_d = this.newValue;
            }
            catch (Exception e1) {
                return false;
            }
        }
        this.notifyListener(this.newValue);
        this.view.getNode(this.whichObject.getParent()).reloadParent();
        return true;
    }

    @Override
    public boolean undoIt() {
        try {
            Field f = this.whichObject.getClass().getField("value");
            XFormValue val = (XFormValue)f.get(this.whichObject);
            val.value_d = this.oldValue;
        }
        catch (Exception e) {
            try {
                Field f = this.whichObject.getClass().getField("value_entity_d");
                XFormValue val = (XFormValue)f.get(this.whichObject);
                val.value_d = this.oldValue;
            }
            catch (Exception e1) {
                return false;
            }
        }
        this.notifyListener(this.oldValue);
        return true;
    }

    private void notifyListener(Object value) {
        if (this.listener != null) {
            XFormValue where;
            try {
                XFormValue val;
                Field f = this.whichObject.getClass().getField("value");
                where = val = (XFormValue)f.get(this.whichObject);
            }
            catch (Exception e) {
                try {
                    XFormValue val;
                    Field f = this.whichObject.getClass().getField("value_d");
                    where = val = (XFormValue)f.get(this.whichObject);
                }
                catch (Exception es) {
                    return;
                }
            }
            ChangeListener.ChangeEvent change = ChangeListener.EventFactory.createChange("value", value, where);
            this.listener.changeOccured(change);
        }
    }
}

