/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormValue;

public class ModifyLinkTextCommand
extends Command {
    XFormLink formLink;
    ChangeListener listener;
    String newValue;
    String oldValue;

    public ModifyLinkTextCommand(XFormLink formLink, String value, ChangeListener listener) {
        this.newValue = value;
        this.formLink = formLink;
        this.listener = listener;
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.MODIFIED_COMMAND(this.oldValue, this.newValue);
    }

    @Override
    public boolean doIt() {
        this.oldValue = this.formLink.getTextValue();
        this.formLink.setTextValue(this.newValue);
        this.notifyListener(this.newValue);
        return true;
    }

    @Override
    public boolean undoIt() {
        this.formLink.setTextValue(this.oldValue);
        this.notifyListener(this.oldValue);
        return true;
    }

    private void notifyListener(Object value) {
        if (this.listener != null) {
            ChangeListener.ChangeEvent change = ChangeListener.EventFactory.createChange("value", value, new XFormValue(this.formLink.getTextValue()));
            this.listener.changeOccured(change);
        }
    }
}

