/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.web.formdesigner.protocol.ComponentProperty;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ModifyComponentPropertyCommand
extends Command {
    private ChangeListener listener;
    private String newValue;
    private String oldValue;
    private ComponentProperty propertyName;
    private XFormXMLObject whichObject;

    public ModifyComponentPropertyCommand(XFormXMLObject which, String value, ComponentProperty propertyName, ChangeListener listener) {
        this.newValue = value;
        this.whichObject = which;
        this.propertyName = propertyName;
        this.listener = listener;
    }

    @Override
    public boolean doIt() {
        this.oldValue = this.propertyName.getValue(this.whichObject);
        this.propertyName.setValue(this.whichObject, this.newValue);
        this.notifyListener(this.newValue);
        return true;
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.MODIFIED_VALUE_COMMAND(this.propertyName.toString(), this.oldValue + "", this.newValue + "");
    }

    @Override
    public boolean undoIt() {
        this.propertyName.setValue(this.whichObject, this.oldValue);
        this.notifyListener(this.oldValue);
        return true;
    }

    private void notifyListener(Object value) {
        if (this.listener != null) {
            ChangeListener.ChangeEvent change = ChangeListener.EventFactory.createChange(this.propertyName.toString(), value, this.whichObject);
            this.listener.changeOccured(change);
        }
    }
}

