/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;

public class ModifyArrayHeaderCommand
extends Command {
    private int index;
    private ChangeListener listener;
    private String newValue;
    private String oldValue;
    private XFormRepeatable repeatable;

    public ModifyArrayHeaderCommand(XFormRepeatable repeatable, String value, ChangeListener listener, int index) {
        this.newValue = value;
        this.repeatable = repeatable;
        this.listener = listener;
        this.index = index;
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.MODIFIED_COMMAND(this.oldValue, this.newValue);
    }

    @Override
    public boolean doIt() {
        String[] headers = this.repeatable.getHeaders();
        this.oldValue = headers[this.index];
        headers[this.index] = this.newValue;
        this.notifyListener(this.newValue);
        return true;
    }

    @Override
    public boolean undoIt() {
        String[] headers = this.repeatable.getHeaders();
        headers[this.index] = this.oldValue;
        this.notifyListener(this.oldValue);
        return true;
    }

    private void notifyListener(Object value) {
        if (this.listener != null) {
            ChangeListener.ChangeEvent change = ChangeListener.EventFactory.createChange("header", value, this.repeatable);
            this.listener.changeOccured(change);
        }
    }
}

