/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class InsertColumnCommand
extends CompoundCommand {
    private boolean fireEvents;
    private int newColumnLocation;
    private XFormXMLObject parentTable;
    private final PresentationStructureView view;

    public InsertColumnCommand(int newColumnLocation, XFormXMLObject parentTable, PresentationStructureView view) {
        this(newColumnLocation, parentTable, view, true);
    }

    public InsertColumnCommand(int newColumnLocation, XFormXMLObject parentTable, PresentationStructureView view, boolean fireEvents) {
        super(new ArrayList(), DesignerMsg.INSERT_COLUMN);
        this.newColumnLocation = newColumnLocation;
        this.parentTable = parentTable;
        this.view = view;
        this.fireEvents = fireEvents;
        this.createCommands();
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.INSERT_COLUMN;
    }

    private void createCommands() {
        XFormTable theTable = (XFormTable)this.parentTable;
        for (int i = 0; i < theTable.row.length; ++i) {
            XFormRow eachRow = theTable.row[i];
            int currentCount = 0;
            Command eachCommand = null;
            if (eachRow.cell != null) {
                for (int j = 0; j < eachRow.cell.length; ++j) {
                    int currentHExpand;
                    if (currentCount == this.newColumnLocation) {
                        AddDataCommand addDataCommand = new AddDataCommand((XFormXMLObject)eachRow, XFormCell.class, j, this.view);
                        addDataCommand.setFireEvents(this.fireEvents);
                        addDataCommand.setSelect(false);
                        eachCommand = addDataCommand;
                        break;
                    }
                    XFormCell currentCell = eachRow.cell[j];
                    int n = currentHExpand = currentCell.hexpand <= 0 ? 1 : currentCell.hexpand;
                    if ((currentCount += currentHExpand) <= this.newColumnLocation) continue;
                    eachCommand = new ModifyPropertyValueCommand(currentCell, currentHExpand + 1, "hexpand", this.fireEvents ? this.view.getChangeListener() : null);
                    break;
                }
            }
            if (eachCommand == null) {
                AddDataCommand addDataCommand = new AddDataCommand((XFormXMLObject)eachRow, XFormCell.class, this.view);
                addDataCommand.setFireEvents(this.fireEvents);
                addDataCommand.setSelect(false);
                eachCommand = addDataCommand;
            }
            this.commands.add(eachCommand);
        }
    }
}

