/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.outline.DataModelTreeNode;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.log.Log;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.xobject.presentationmodel.XFormArraybutton;
import oracle.bpm.xobject.xml.XFormXMLObject;

public abstract class DataCommand
extends Command {
    private final ChangeListener changeListener;
    private boolean fireEvents = true;
    private boolean select = true;

    public DataCommand(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setFireEvents(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    public boolean isFireEvents() {
        return this.fireEvents;
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean removeObjectFromTree(XFormXMLObject parent, XFormXMLObject child, PresentationStructureView view, boolean notify) {
        boolean result = this.removeObject(parent, child, notify);
        if (result && view.getTree().hasTree()) {
            TreeNode node = view.getNode(child);
            view.getTree().removeSelection(node);
            node.removeFromParent();
        }
        return result;
    }

    public boolean removeObject(XFormXMLObject parent, XFormXMLObject child, boolean notify) {
        boolean result;
        boolean bl = result = child != null;
        if (result && parent != null && !(child instanceof XFormArraybutton)) {
            Class<?> childClass = child.getClass();
            for (Field eachField : parent.getClass().getFields()) {
                if (Modifier.isStatic(eachField.getModifiers())) continue;
                try {
                    Object[] val;
                    if (eachField.getType().equals(childClass)) {
                        eachField.set(parent, null);
                        break;
                    }
                    if (!Utilities.isArray(eachField, childClass) || (val = (Object[])eachField.get(parent)) == null || val.length <= 0) continue;
                    Object newArray = Array.newInstance(eachField.getType().getComponentType(), val.length - 1);
                    int j = 0;
                    for (int w = 0; w < val.length - 1 && j < val.length; ++w, ++j) {
                        Array.set(newArray, w, val[j]);
                        if (!val[j].equals(child)) continue;
                        --w;
                    }
                    eachField.set(parent, newArray);
                    break;
                }
                catch (IllegalAccessException e) {
                    Log.logWarning(e);
                }
            }
            if (notify) {
                this.notifyListeners(parent);
            }
        }
        return result;
    }

    protected boolean removeObject(XFormXMLObject parent, TreeNode child) {
        return this.removeObject(parent, ((DataModelTreeNode)child).getContent(), true);
    }

    private void notifyListeners(XFormXMLObject change) {
        this.changeListener.changeOccured(ChangeListener.EventFactory.createChange(change));
    }
}

