/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.util.ArrayList;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.resources.Msg;

public class CompoundCommand
extends Command {
    protected ArrayList<Command> commands;
    private Msg commandMsg;
    private String commandName;
    private boolean[] result;

    public CompoundCommand(ArrayList commands, String commandName) {
        this.commands = commands;
        this.commandName = commandName;
    }

    public CompoundCommand(ArrayList commands, Msg msg) {
        this.commands = commands;
        this.commandMsg = msg;
    }

    @Override
    public String getName() {
        return this.commandName != null ? this.commandName : super.getName();
    }

    @Override
    public Msg getMsg() {
        return this.commandMsg;
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    @Override
    public boolean doIt() {
        boolean executionResult = false;
        int i = 0;
        this.result = new boolean[this.commands.size()];
        for (Command command : this.commands) {
            boolean result = command.doIt();
            this.result[i++] = result;
            executionResult |= result;
        }
        return executionResult;
    }

    @Override
    public boolean undoIt() {
        boolean executionResult = true;
        for (int i = this.commands.size() - 1; i >= 0; --i) {
            Command d = this.commands.get(i);
            if (this.result != null && !this.result[i]) continue;
            boolean r = d.undoIt();
            executionResult &= r;
        }
        return executionResult;
    }
}

