/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import oracle.bpm.collections.lists.IntList;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.formdesigner.command.DataCommand;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ClearDataCommand
extends DataCommand {
    private XFormRepeatable array = null;
    private boolean expandNearestObject;
    private int index = -1;
    private XFormCell nextObject = null;
    private boolean notify;
    private String[] oldHeaders = null;
    private int[] oldHeadersWidth = null;
    private int oldValue = -1;
    private PresentationStructureView view;
    private XFormPresentationXMLObject xmlObjectToClear = null;
    private XFormXMLObject xmlObjectToClearParent = null;

    public ClearDataCommand(PresentationStructureView view, XFormPresentationXMLObject xmlObject) {
        this(view, xmlObject, true, true);
    }

    public ClearDataCommand(PresentationStructureView view, XFormPresentationXMLObject xmlObject, boolean expandNearestObject, boolean notify) {
        super(view.getChangeListener());
        this.view = view;
        this.xmlObjectToClear = xmlObject;
        this.notify = notify;
        this.xmlObjectToClearParent = this.xmlObjectToClear.getParent();
        this.expandNearestObject = expandNearestObject;
    }

    @Override
    public Msg getMsg() {
        return DesignerMsg.CLEAR_COMMAND(this.xmlObjectToClear.toString(), this.xmlObjectToClearParent.toString());
    }

    public XFormXMLObject getNodeParent() {
        return this.xmlObjectToClearParent;
    }

    @Override
    public boolean doIt() {
        this.xmlObjectToClearParent = this.xmlObjectToClear.getParent();
        this.index = this.xmlObjectToClearParent.getIndex(this.xmlObjectToClear);
        if (this.expandNearestObject) {
            this.checkCell(true);
        }
        this.removeObjectFromTree(this.xmlObjectToClearParent, this.xmlObjectToClear, this.view, this.notify);
        this.view.getHelper().remove(this.xmlObjectToClear, this.xmlObjectToClear.getId());
        if (this.isSelect()) {
            XFormXMLObject selection = this.xmlObjectToClearParent;
            if (this.xmlObjectToClearParent instanceof XFormRow) {
                selection = this.xmlObjectToClearParent.getParent();
            }
            this.view.select(selection);
        }
        return true;
    }

    @Override
    public boolean undoIt() {
        if (this.expandNearestObject) {
            this.checkCell(false);
        }
        this.view.addObject(this.xmlObjectToClearParent, this.xmlObjectToClear, this.index, this.notify);
        return true;
    }

    private void checkCell(boolean doIt) {
        if (doIt) {
            if (this.xmlObjectToClear instanceof XFormCell && this.xmlObjectToClearParent instanceof XFormRow) {
                if (this.xmlObjectToClearParent.getParent() instanceof XFormTable) {
                    XFormTable theTable = (XFormTable)this.xmlObjectToClearParent.getParent();
                    if (theTable.row.length > 1) {
                        XFormRow theRow = (XFormRow)this.xmlObjectToClearParent;
                        int i = theRow.getIndex(this.xmlObjectToClear);
                        if (i > 0) {
                            this.nextObject = theRow.cell[i - 1];
                            this.oldValue = theRow.cell[i - 1].hexpand;
                            if (this.oldValue <= 0) {
                                this.oldValue = 1;
                            }
                            theRow.cell[i - 1].hexpand = this.oldValue + theRow.cell[i].hexpand;
                        } else if (i == 0 && i < theRow.cell.length - 1) {
                            this.nextObject = theRow.cell[i + 1];
                            this.oldValue = theRow.cell[i + 1].hexpand;
                            if (this.oldValue <= 0) {
                                this.oldValue = 1;
                            }
                            theRow.cell[i + 1].hexpand = this.oldValue + theRow.cell[i].hexpand;
                        }
                    }
                } else if (this.xmlObjectToClearParent.getParent() instanceof XFormRepeatable) {
                    XFormRow theRow = (XFormRow)this.xmlObjectToClearParent;
                    int i = theRow.getIndex(this.xmlObjectToClear);
                    this.array = (XFormRepeatable)this.xmlObjectToClearParent.getParent();
                    StringList headersList = StringList.create(this.array.headers);
                    IntList headerswidthList = IntList.create(this.array.headerswidth);
                    headersList.remove(i);
                    headerswidthList.remove(i);
                    this.array.headers = headersList.toArray();
                    this.array.headerswidth = headerswidthList.toIntArray();
                }
            }
        } else {
            if (this.nextObject != null) {
                this.nextObject.hexpand = this.oldValue;
            }
            if (this.array != null) {
                this.array.headers = this.oldHeaders;
                this.array.headerswidth = this.oldHeadersWidth;
            }
        }
    }
}

