/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.command;

import java.lang.reflect.Field;
import oracle.bpm.collections.lists.IntList;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.formdesigner.Dialogs;
import oracle.bpm.designer.formdesigner.command.DataCommand;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class AddDataCommand
extends DataCommand {
    private XFormRepeatable array_d = null;
    private int id_d = -1;
    private int indexWhere = -1;
    private String[] oldHeaders_d = null;
    private int[] oldHeadersWidth_d = null;
    private XFormXMLObject parentXmlObject;
    private boolean replaceReferencesNames = false;
    private XFormXMLObject resultXMLObject = null;
    private boolean useOptions = true;
    private PresentationStructureView view;
    private XFormPresentationXMLObject whatObject;

    public AddDataCommand(XFormXMLObject parent, XFormComponentType type, PresentationStructureView view) {
        this(parent, view);
        this.whatObject = type.createInstance();
        this.whatObject.setParent(parent);
    }

    public AddDataCommand(XFormXMLObject dataModelTreeNode, Class<? extends XFormPresentationXMLObject> what, PresentationStructureView view) {
        this(dataModelTreeNode, view);
        try {
            this.whatObject = what == null ? null : what.newInstance();
        }
        catch (InstantiationException e) {
            this.whatObject = null;
        }
        catch (IllegalAccessException e) {
            this.whatObject = null;
        }
    }

    public AddDataCommand(XFormXMLObject dataModelTreeNode, XFormPresentationXMLObject what, PresentationStructureView view) {
        this(dataModelTreeNode, view);
        this.whatObject = what;
    }

    public AddDataCommand(XFormXMLObject dataModelTreeNode, XFormPresentationXMLObject what, PresentationStructureView view, int indexWhere) {
        this(dataModelTreeNode, what, view);
        this.indexWhere = indexWhere;
    }

    public AddDataCommand(XFormXMLObject dataModelTreeNode, Class<? extends XFormPresentationXMLObject> what, int indexWhere, PresentationStructureView view) {
        this(dataModelTreeNode, what, view);
        this.indexWhere = indexWhere;
    }

    private AddDataCommand(XFormXMLObject parent, PresentationStructureView view) {
        super(view.getChangeListener());
        this.parentXmlObject = parent;
        this.view = view;
    }

    public static AddDataCommand getPasteCommand(XFormXMLObject selectedNode, XFormPresentationXMLObject xFormXMLObject, boolean replaceReferenceNames, PresentationStructureView view) {
        AddDataCommand data = new AddDataCommand(selectedNode, xFormXMLObject, view);
        data.replaceReferencesNames = replaceReferenceNames;
        data.useOptions = false;
        return data;
    }

    public static AddDataCommand getPasteCommand(XFormXMLObject dataModelTreeNode, XFormPresentationXMLObject what, int indexWhere, boolean replaceReferencesNames, PresentationStructureView view) {
        AddDataCommand data = new AddDataCommand(dataModelTreeNode, what, view);
        data.replaceReferencesNames = replaceReferencesNames;
        data.indexWhere = indexWhere;
        data.useOptions = false;
        return data;
    }

    public static AddDataCommand createCommand(Class<? extends XFormPresentationXMLObject> theClass, UiComponent displayComponent, XFormXMLObject treeSelection, PresentationStructureView view) {
        AddDataCommand command = null;
        if (XFormTable.class.equals(theClass)) {
            int[] parameters = Dialogs.showTableDimensionsDialog(displayComponent);
            if (parameters != null) {
                XFormTable theTable = new XFormTable(parameters[0], parameters[1]);
                command = new AddDataCommand(treeSelection, theTable, view);
            }
        } else if (XFormArray.class.equals(theClass)) {
            int parameter = Dialogs.showArrayDimensionsDialog(displayComponent);
            if (parameter != -1) {
                XFormArray theTable = new XFormArray(parameter);
                command = new AddDataCommand(treeSelection, theTable, view);
                command.setCommandId();
            }
        } else if (XFormRow.class.equals(theClass)) {
            XFormTable table = (XFormTable)treeSelection;
            int[] parameters = Dialogs.showRowDimensionDialog(displayComponent, table.getModelTotalColumns());
            if (parameters != null) {
                XFormRow theRow = new XFormRow();
                theRow.expand(parameters[0]);
                command = new AddDataCommand(treeSelection, theRow, view);
                command.setCommandId();
            }
        } else if (XFormButton.class.equals(theClass)) {
            String option = (String)MessageDialog.showOptions((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.CREATE_BUTTON, (Msg)DesignerMsg.KIND_OF_BUTTON, (Object[])XFormButton.possibleAction_d, (Object)XFormButton.possibleAction_d[0]);
            if (option != null) {
                XFormButton theButton = new XFormButton();
                theButton.action = option;
                command = new AddDataCommand(treeSelection, theButton, view);
                command.setCommandId();
            }
        } else {
            try {
                XFormPresentationXMLObject instance = theClass.newInstance();
                command = new AddDataCommand(treeSelection, instance, view);
                command.setCommandId();
            }
            catch (Exception ez) {
                ez.printStackTrace();
            }
        }
        return command;
    }

    public static AddDataCommand newWithId(XFormXMLObject parent, XFormComponentType componentType, PresentationStructureView view) {
        AddDataCommand result = new AddDataCommand(parent, componentType, view);
        result.setCommandId();
        return result;
    }

    public void setId(int id) {
        this.id_d = id;
    }

    @Override
    public Msg getMsg() {
        String what = this.whatObject.getName();
        return DesignerMsg.ADD_COMMAND(what, this.parentXmlObject.getName());
    }

    @Override
    public boolean doIt() {
        boolean result = this.performCommand();
        if (result && this.isSelect()) {
            this.view.select(this.whatObject);
            if (this.whatObject instanceof XFormLabel) {
                this.view.requestFocusOn(this.whatObject, true);
            }
        }
        return result;
    }

    @Override
    public boolean undoIt() {
        return this.undoAdd(this.isFireEvents());
    }

    public void setCommandId() {
        int id = -1;
        if (this.whatObject != null) {
            String name = this.whatObject.getName().toLowerCase();
            id = this.view.getIdFor(name);
        }
        this.setId(id);
    }

    public XFormXMLObject getAddedObject() {
        return this.whatObject;
    }

    public XFormXMLObject getParentXmlObject() {
        return this.parentXmlObject;
    }

    protected boolean undoAdd(boolean fireEvents) {
        return this.removeObjectFromTree(this.parentXmlObject, this.resultXMLObject, this.view, fireEvents);
    }

    protected void applyOptions(Object object) {
        if (object instanceof XFormPresentationXMLObject) {
            PresentationGenerationOptions options = PresentationGenerationOptions.load();
            options.apply((XFormPresentationXMLObject)object);
        }
    }

    protected boolean performCommand() {
        return this.doAdd(this.isFireEvents());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doAdd(boolean fireEvents) {
        if (this.resultXMLObject == null) {
            if (this.whatObject == null) return false;
            if (this.useOptions()) {
                this.applyOptions(this.whatObject);
            }
            if (this.id_d > -1) {
                AddDataCommand.setId(this.whatObject, this.id_d);
            }
            if (this.replaceReferencesNames) {
                this.checkIds(this.whatObject);
            }
            this.resultXMLObject = this.view.addObject(this.parentXmlObject, this.whatObject, this.indexWhere, fireEvents, false);
            this.checkCell(true);
            DataTreeHelper.refreshNames(this.resultXMLObject, this.view.getHelper());
            return true;
        } else {
            this.view.putNode(this.parentXmlObject, this.resultXMLObject, fireEvents);
        }
        return true;
    }

    protected boolean useOptions() {
        return this.useOptions && DesignerPreferences.getPreferences().isPresentationAddUseOptions();
    }

    protected PresentationStructureView getView() {
        return this.view;
    }

    private static void setId(XFormXMLObject presentationXMLObject, int idFor) {
        String id = presentationXMLObject.getName().toLowerCase() + idFor;
        try {
            Field f = presentationXMLObject.getClass().getField("id");
            f.set(presentationXMLObject, id);
        }
        catch (Exception e) {
            try {
                Field f = presentationXMLObject.getClass().getField("id_d");
                f.set(presentationXMLObject, id);
            }
            catch (Exception otra) {
                // empty catch block
            }
        }
    }

    private void checkCell(boolean doIt) {
        if (doIt) {
            if (this.whatObject instanceof XFormCell && this.parentXmlObject instanceof XFormRow && this.parentXmlObject.getParent() instanceof XFormRepeatable) {
                int i;
                XFormRow theRow = (XFormRow)this.parentXmlObject;
                for (i = 0; i < theRow.cell.length && !theRow.cell[i].equals(this.whatObject); ++i) {
                }
                this.array_d = (XFormRepeatable)this.parentXmlObject.getParent();
                StringList headersList = StringList.create(this.array_d.headers);
                IntList headerswidthList = IntList.create(this.array_d.headerswidth);
                headersList.add(i, "");
                headerswidthList.add(i, Integer.valueOf(-1));
                this.array_d.headers = headersList.toArray();
                this.array_d.headerswidth = headerswidthList.toIntArray();
            }
        } else {
            this.array_d.headers = this.oldHeaders_d;
            this.array_d.headerswidth = this.oldHeadersWidth_d;
        }
    }

    private void checkIds(XFormPresentationXMLObject base) {
        if (base != null) {
            int componentType = base.getComponentID();
            switch (componentType) {
                case 11: {
                    XFormRow[] rows = ((XFormTable)base).row;
                    for (int i = 0; rows != null && i < rows.length; ++i) {
                        this.checkIds(rows[i]);
                    }
                    AddDataCommand.setId(base, this.view.getIdFor(base.getName()));
                    break;
                }
                case 10: {
                    XFormCell[] cells = ((XFormRow)base).cell;
                    for (int i = 0; cells != null && i < cells.length; ++i) {
                        this.checkIds(cells[i]);
                    }
                    break;
                }
                case 3: {
                    this.checkIds(((XFormCell)base).getComponent());
                    break;
                }
                case 15: 
                case 18: {
                    this.checkIds(((XFormRepeatable)base).row);
                    AddDataCommand.setId(base, this.view.getIdFor(base.getName()));
                    break;
                }
                default: {
                    AddDataCommand.setId(base, this.view.getIdFor(base.getName()));
                }
            }
        }
    }
}

