/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.bordereditor;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToggleButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;

abstract class BorderSettingPanel
extends Panel {
    private ToggleButton custom;
    private Label customLabel;
    private ToggleButton defaultBorder;
    private Label defaultLabel;
    private ToggleButton outline;
    private Label outlineLabel;

    public BorderSettingPanel(UiContainer parent) {
        super(parent);
        String cols = "5dlu, pref, 2dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.defaultBorder = new ToggleButton((UiContainer)this, UIMsg.BORDER_DEFAULT, 10);
        builder.add((UiComponent)this.defaultBorder, cc.xy(2, 2));
        this.defaultLabel = Label.create((UiContainer)this, (Msg)UIMsg.BORDER_DEFAULT);
        builder.add((UiComponent)this.defaultLabel, cc.xy(4, 2));
        this.outline = new ToggleButton((UiContainer)this, UIMsg.BORDER_OUTLINE, 10);
        builder.add((UiComponent)this.outline, cc.xy(2, 4));
        this.outlineLabel = Label.create((UiContainer)this, (Msg)UIMsg.BORDER_OUTLINE);
        builder.add((UiComponent)this.outlineLabel, cc.xy(4, 4));
        this.custom = new ToggleButton((UiContainer)this, UIMsg.BORDER_CUSTOM, 10);
        builder.add((UiComponent)this.custom, cc.xy(2, 6));
        this.customLabel = Label.create((UiContainer)this, (Msg)UIMsg.BORDER_CUSTOM);
        builder.add((UiComponent)this.customLabel, cc.xy(4, 6));
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.defaultBorder);
        group.add((AbstractButton)this.outline);
        group.add((AbstractButton)this.custom);
        this.setBorder((Border)new TitledBorder(DesignerMsg.SETTINGS));
        this.defaultBorder.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    BorderSettingPanel.this.noneSelected();
                }
            }
        });
        this.outline.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    BorderSettingPanel.this.outlineSelected();
                }
            }
        });
    }

    public abstract void noneSelected();

    public abstract void outlineSelected();

    public boolean isOutlineSelected() {
        return this.outline.isSelected();
    }

    public void enableCustomBorder(boolean enable) {
        this.custom.setEnabled(enable);
        this.customLabel.setEnabled(enable);
    }

    public void selectCustom(boolean selected) {
        this.custom.setSelected(selected);
    }

    public void selectNone(boolean selected) {
        this.defaultBorder.setSelected(selected);
    }

    public void selectOutline(boolean selected) {
        this.outline.setSelected(selected);
    }
}

