/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.bordereditor;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToggleButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;

abstract class BorderPreviewPanel
extends Panel {
    private ToggleButton bottomBorderBtn;
    private ListeningArea bottomListeningArea;
    private boolean customListenerEnabled = true;
    private ToggleButton leftBorderBtn;
    private ListeningArea leftListeningArea;
    private Panel mainSquare;
    private ToggleButton rightBorderBtn;
    private ListeningArea rightListeningArea;
    private ToggleButton topBorderBtn;
    private ListeningArea topListeningArea;
    private static final Cursor defaultCursor = Cursor.DEFAULT_CURSOR;
    private static final Cursor handCursor = Cursor.HAND_CURSOR;

    public BorderPreviewPanel(UiContainer parent) {
        super(parent);
        this.initGui();
    }

    public abstract void changeSelectedBorder(int var1);

    public abstract void clearSelectedBorder(int var1);

    public void disableCustomListener() {
        this.customListenerEnabled = false;
    }

    public void drawBorder(Border border) {
        this.mainSquare.setBorder(BorderFactory.createCompoundBorder((Border)BorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5), (Border)border));
        this.mainSquare.repaint();
        this.mainSquare.getParent().revalidate();
        this.mainSquare.getParent().repaint();
    }

    public void enableBorderButtons(boolean enable) {
        this.leftBorderBtn.setEnabled(enable);
        this.topBorderBtn.setEnabled(enable);
        this.rightBorderBtn.setEnabled(enable);
        this.bottomBorderBtn.setEnabled(enable);
    }

    public void enableBorderListeners(boolean enable) {
        this.leftListeningArea.setEnabled(enable);
        this.topListeningArea.setEnabled(enable);
        this.rightListeningArea.setEnabled(enable);
        this.bottomListeningArea.setEnabled(enable);
    }

    public void enableCustomListener() {
        this.customListenerEnabled = true;
    }

    public void enableCustomOption(boolean enable) {
        this.enableBorderButtons(enable);
        this.enableBorderListeners(enable);
    }

    public boolean noBordersSelected() {
        return !this.topBorderBtn.isSelected() && !this.rightBorderBtn.isSelected() && !this.bottomBorderBtn.isSelected() && !this.leftBorderBtn.isSelected();
    }

    public void selectBottom(boolean selected) {
        this.bottomBorderBtn.setSelected(selected);
    }

    public void selectLeft(boolean selected) {
        this.leftBorderBtn.setSelected(selected);
    }

    public void selectNone() {
        this.selectTop(false);
        this.selectRight(false);
        this.selectBottom(false);
        this.selectLeft(false);
    }

    public void selectOutline() {
        this.disableCustomListener();
        this.selectNone();
        this.selectTop(true);
        this.selectRight(true);
        this.selectBottom(true);
        this.selectLeft(true);
        this.enableCustomListener();
    }

    public void selectRight(boolean selected) {
        this.rightBorderBtn.setSelected(selected);
    }

    public void selectTop(boolean selected) {
        this.topBorderBtn.setSelected(selected);
    }

    protected abstract void setProperBorderSettings();

    private ToggleButton createImgButton(UiContainer parent, Msg msg, final int borderToSelect) {
        ToggleButton button = new ToggleButton(parent, msg, 10);
        button.setFocusable(true);
        button.setFocusPainted(true);
        button.setExactSize(Dimension.valueOf(22, 22));
        button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    BorderPreviewPanel.this.changeSelectedBorder(borderToSelect);
                } else {
                    BorderPreviewPanel.this.clearSelectedBorder(borderToSelect);
                }
                if (BorderPreviewPanel.this.customListenerEnabled) {
                    BorderPreviewPanel.this.setProperBorderSettings();
                }
            }
        });
        return button;
    }

    private ListeningArea createListeningArea(UiContainer parent, ToggleButton toBeToggled) {
        ListeningArea listeningArea = new ListeningArea(parent, toBeToggled);
        return listeningArea;
    }

    private void initGui() {
        String cols = "5dlu, pref, 3dlu, pref, 1dlu, pref, 20dlu, pref, 1dlu, pref, 5dlu";
        String rows = "5dlu, pref, 1dlu, fill:pref, 20dlu, pref, 1dlu, pref, 3dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        this.leftBorderBtn = this.createImgButton((UiContainer)this, UIMsg.BORDER_LEFT, 8);
        this.topBorderBtn = this.createImgButton((UiContainer)this, UIMsg.BORDER_TOP, 1);
        this.rightBorderBtn = this.createImgButton((UiContainer)this, UIMsg.BORDER_RIGHT, 2);
        this.bottomBorderBtn = this.createImgButton((UiContainer)this, UIMsg.BORDER_BOTTOM, 4);
        Label leftUpperCorner = Label.create((UiContainer)this, (Image)Image.create((Msg)DesignerMsg.BORDER_UPPER_LEFT_CORNER));
        builder.add((UiComponent)leftUpperCorner, cc.xy(4, 2));
        this.topListeningArea = this.createListeningArea((UiContainer)this, this.topBorderBtn);
        builder.add((UiComponent)this.topListeningArea, cc.xywh(5, 2, 5, 2));
        Label rightUpperCorner = Label.create((UiContainer)this, (Image)Image.create((Msg)DesignerMsg.BORDER_UPPER_RIGHT_CORNER));
        builder.add((UiComponent)rightUpperCorner, cc.xy(10, 2));
        this.leftListeningArea = this.createListeningArea((UiContainer)this, this.leftBorderBtn);
        builder.add((UiComponent)this.leftListeningArea, cc.xywh(4, 3, 1, 5));
        this.mainSquare = new Panel((UiContainer)this);
        this.mainSquare.setBackground(Color.WHITE);
        builder.add((UiComponent)this.mainSquare, cc.xywh(5, 3, 5, 5));
        this.rightListeningArea = this.createListeningArea((UiContainer)this, this.rightBorderBtn);
        builder.add((UiComponent)this.rightListeningArea, cc.xywh(10, 3, 1, 5));
        builder.add((UiComponent)this.topBorderBtn, cc.xy(2, 4));
        builder.add((UiComponent)this.bottomBorderBtn, cc.xy(2, 6));
        Label leftBottomCorner = Label.create((UiContainer)this, (Image)Image.create((Msg)DesignerMsg.BORDER_BOTTOM_LEFT_CORNER));
        builder.add((UiComponent)leftBottomCorner, cc.xy(4, 8));
        this.bottomListeningArea = this.createListeningArea((UiContainer)this, this.bottomBorderBtn);
        builder.add((UiComponent)this.bottomListeningArea, cc.xywh(5, 7, 5, 2));
        Label rightBottomCorner = Label.create((UiContainer)this, (Image)Image.create((Msg)DesignerMsg.BORDER_BOTTOM_RIGHT_CORNER));
        builder.add((UiComponent)rightBottomCorner, cc.xy(10, 8));
        builder.add((UiComponent)this.leftBorderBtn, cc.xy(6, 10));
        builder.add((UiComponent)this.rightBorderBtn, cc.xy(8, 10));
    }

    static class ListeningArea
    extends Panel {
        boolean enabled = true;

        public ListeningArea(UiContainer parent, ToggleButton toBeToggled) {
            super(parent);
            this.setBackground(Color.WHITE);
            class BorderMouseListener
            extends MouseAdapter {
                ToggleButton toggle;

                public BorderMouseListener(ToggleButton toBeToggled) {
                    this.toggle = toBeToggled;
                }

                public void mouseExited(MouseEvent e) {
                    ListeningArea.this.setCursor(defaultCursor);
                }

                public void mouseEntered(MouseEvent e) {
                    if (ListeningArea.this.enabled) {
                        ListeningArea.this.setCursor(handCursor);
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (ListeningArea.this.enabled) {
                        boolean select = !this.toggle.isSelected();
                        this.toggle.setSelected(select);
                    }
                }
            }
            this.addMouseListener((MouseListener)new BorderMouseListener(toBeToggled));
        }

        public void setEnabled(boolean enable) {
            this.enabled = enable;
        }
    }
}

