/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.bordereditor;

import oracle.bpm.designer.formdesigner.FullBorderPropertiesImpl;
import oracle.bpm.designer.formdesigner.bordereditor.BorderEditor;
import oracle.bpm.designer.formdesigner.bordereditor.BorderSettingPanel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;

public class BorderPanel
extends Panel {
    private BorderEditor borderEditor = new BorderEditor();

    public BorderPanel(UiContainer parent) {
        super(parent);
        String cols = "10dlu, pref, 3dlu, pref, 3dlu, pref, 10dlu";
        String rows = "10dlu, fill:default, 15dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        BorderSettingPanel settingPanel = this.borderEditor.getSettingPanel((UiContainer)this);
        builder.add((UiComponent)settingPanel, cc.xy(2, 2));
        Panel linePanel = this.createLinePanel((UiContainer)this);
        builder.add((UiComponent)linePanel, cc.xy(4, 2));
        Panel borderPreviewPanel = this.createBorderPreviewPanel((UiContainer)this);
        builder.add((UiComponent)borderPreviewPanel, cc.xy(6, 2));
    }

    public void setBorderProperties(FullBorderProperties properties) {
        this.borderEditor.setBorderToEdit(properties);
    }

    public FullBorderPropertiesImpl getBorderProperties() {
        return this.borderEditor.getEditedBorder();
    }

    public void addListener(ChangeListener listener) {
        this.borderEditor.addListener(listener);
    }

    public Panel createLinePanel(UiContainer parent) {
        Panel linePanel = new Panel(parent);
        linePanel.setBorder((Border)new TitledBorder(UIMsg.LINE));
        String cols = "5dlu, pref, 5dlu";
        String rows = "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(linePanel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)linePanel, (Msg)UIMsg.EDITOR_STYLE), cc.xy(2, 1));
        builder.add((UiComponent)this.borderEditor.getBorderTypeList((UiContainer)linePanel), cc.xy(2, 3));
        builder.add((UiComponent)Label.create((UiContainer)linePanel, (Msg)UIMsg.COLOR), cc.xy(2, 5));
        builder.add((UiComponent)this.borderEditor.getColorChooser((UiContainer)linePanel), cc.xy(2, 7));
        builder.add((UiComponent)Label.create((UiContainer)linePanel, (Msg)UIMsg.EDITOR_SIZE), cc.xy(2, 9));
        builder.add((UiComponent)this.borderEditor.getBorderSizeCombo((UiContainer)linePanel), cc.xy(2, 11));
        return linePanel;
    }

    public void enableCustomBorder(boolean enable) {
        this.borderEditor.enableCustomBorder(enable);
    }

    private Panel createBorderPreviewPanel(UiContainer parent) {
        Panel borderPreviewPanel = new Panel(parent);
        borderPreviewPanel.setBorder((Border)new TitledBorder(UIMsg.PREVIEW));
        String cols = "5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 10dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(borderPreviewPanel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)borderPreviewPanel, (Msg)UIMsg.BORDER_HOW_TO), cc.xy(2, 2));
        builder.add((UiComponent)this.borderEditor.getPreviewPanel((UiContainer)borderPreviewPanel), cc.xy(2, 4));
        return borderPreviewPanel;
    }
}

