/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.bordereditor;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.formdesigner.FullBorderPropertiesImpl;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.bordereditor.BorderPreviewPanel;
import oracle.bpm.designer.formdesigner.bordereditor.BorderSettingPanel;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.impl.BorderSizeComboBox;
import oracle.bpm.ui.prop.impl.BorderTypeList;
import oracle.bpm.ui.utils.ColorUtils;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;
import oracle.bpm.xobject.runtime.swing.XObjectBorderFactory;

class BorderEditor {
    private BorderTypeList borderTypeLst;
    private ColorChoosingComponent colorChooser;
    private FullBorderPropertiesImpl editedBorder;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private BorderPreviewPanel previewPanel;
    private BorderSettingPanel settingPanel;
    private BorderSizeComboBox sizeCombo;

    public BorderSizeComboBox getBorderSizeCombo(UiContainer parent) {
        this.sizeCombo = new BorderSizeComboBox(parent);
        this.sizeCombo.setToolTipMsg(UIMsg.SIZE_TOOLTIP);
        this.sizeCombo.setSelectedIndex(0);
        this.sizeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BorderEditor.this.redrawOutlineBorder();
            }
        });
        return this.sizeCombo;
    }

    public void setBorderToEdit(FullBorderProperties borderProperties) {
        boolean hasLeftBorder;
        this.previewPanel.disableCustomListener();
        this.settingPanel.selectNone(true);
        this.previewPanel.enableCustomListener();
        this.editedBorder = new FullBorderPropertiesImpl(borderProperties);
        boolean hasTopBorder = this.editedBorder.getTopStyle() != null;
        boolean hasRightBorder = this.editedBorder.getRightStyle() != null;
        boolean hasBottomBorder = this.editedBorder.getBottomStyle() != null;
        boolean bl = hasLeftBorder = this.editedBorder.getLeftStyle() != null;
        if (!(hasTopBorder || hasRightBorder || hasBottomBorder || hasLeftBorder)) {
            this.settingPanel.selectNone(true);
            this.colorChooser.setSelectedColor(Color.BLACK);
            this.sizeCombo.setSelectedSize(1);
        } else if (this.editedBorder.isSimpleBorder()) {
            this.colorChooser.setSelectedColor(ColorUtils.getColor((String)this.editedBorder.getTopColor()));
            this.borderTypeLst.setSelectedValue((Object)this.editedBorder.getTopStyle(), true);
            this.sizeCombo.setSelectedSize(this.editedBorder.getTopWidth());
            this.settingPanel.selectOutline(true);
        } else {
            this.settingPanel.selectCustom(true);
            this.drawCustomborder(hasTopBorder, hasRightBorder, hasBottomBorder, hasLeftBorder);
        }
    }

    public BorderTypeList getBorderTypeList(UiContainer parent) {
        this.borderTypeLst = new BorderTypeList(parent, UIMsg.EDITOR_STYLE);
        this.borderTypeLst.setSelectedValue((Object)BorderStyle.SOLID, true);
        this.borderTypeLst.setBorder(BorderFactory.createEtchedBorder());
        this.borderTypeLst.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BorderEditor.this.redrawOutlineBorder();
            }
        });
        return this.borderTypeLst;
    }

    public ColorChoosingComponent getColorChooser(UiContainer parent) {
        this.colorChooser = new ColorChoosingComponent(parent, UIMsg.COLOR);
        this.colorChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BorderEditor.this.redrawOutlineBorder();
            }
        });
        return this.colorChooser;
    }

    public FullBorderPropertiesImpl getEditedBorder() {
        return this.editedBorder;
    }

    public BorderPreviewPanel getPreviewPanel(UiContainer parent) {
        this.previewPanel = new BorderPreviewPanel(parent){

            @Override
            public void changeSelectedBorder(int borderToSelect) {
                if (BorderEditor.this.editedBorder != null) {
                    String selectedColor = Utilities.getString(BorderEditor.this.colorChooser.getSelectedColor());
                    BorderStyle selectedStyle = BorderEditor.this.borderTypeLst.getSelectedBorder();
                    int selectedSize = BorderEditor.this.sizeCombo.getSelectedSize();
                    if ((borderToSelect & 1) != 0) {
                        BorderEditor.this.editedBorder.setTopColor(selectedColor);
                        BorderEditor.this.editedBorder.setTopborderstyle(selectedStyle);
                        BorderEditor.this.editedBorder.setTopWidth(selectedSize);
                    }
                    if ((borderToSelect & 2) != 0) {
                        BorderEditor.this.editedBorder.setRightColor(selectedColor);
                        BorderEditor.this.editedBorder.setRightborderstyle(selectedStyle);
                        BorderEditor.this.editedBorder.setRightWidth(selectedSize);
                    }
                    if ((borderToSelect & 4) != 0) {
                        BorderEditor.this.editedBorder.setBottomColor(selectedColor);
                        BorderEditor.this.editedBorder.setBottomborderstyle(selectedStyle);
                        BorderEditor.this.editedBorder.setBottomWidth(selectedSize);
                    }
                    if ((borderToSelect & 8) != 0) {
                        BorderEditor.this.editedBorder.setLeftColor(selectedColor);
                        BorderEditor.this.editedBorder.setLeftborderstyle(selectedStyle);
                        BorderEditor.this.editedBorder.setLeftWidth(selectedSize);
                    }
                    BorderEditor.this.updateBorder();
                }
            }

            @Override
            public void clearSelectedBorder(int borderToClear) {
                if (BorderEditor.this.editedBorder != null) {
                    if ((borderToClear & 1) != 0) {
                        BorderEditor.this.editedBorder.setTopborderstyle(null);
                    }
                    if ((borderToClear & 2) != 0) {
                        BorderEditor.this.editedBorder.setRightborderstyle(null);
                    }
                    if ((borderToClear & 4) != 0) {
                        BorderEditor.this.editedBorder.setBottomborderstyle(null);
                    }
                    if ((borderToClear & 8) != 0) {
                        BorderEditor.this.editedBorder.setLeftborderstyle(null);
                    }
                    BorderEditor.this.updateBorder();
                }
            }

            @Override
            public void setProperBorderSettings() {
                if (BorderEditor.this.previewPanel.noBordersSelected()) {
                    BorderEditor.this.settingPanel.selectNone(true);
                } else if (BorderEditor.this.editedBorder instanceof SimpleBorderProperties || BorderEditor.this.editedBorder.isSimpleBorder()) {
                    BorderEditor.this.settingPanel.selectOutline(true);
                } else {
                    BorderEditor.this.settingPanel.selectCustom(true);
                }
            }
        };
        return this.previewPanel;
    }

    public BorderSettingPanel getSettingPanel(UiContainer parent) {
        this.settingPanel = new BorderSettingPanel(parent){

            @Override
            public void noneSelected() {
                BorderEditor.this.previewPanel.selectNone();
            }

            @Override
            public void outlineSelected() {
                BorderEditor.this.previewPanel.selectOutline();
            }
        };
        return this.settingPanel;
    }

    public void enableCustomBorder(boolean enable) {
        this.settingPanel.enableCustomBorder(enable);
        this.previewPanel.enableCustomOption(enable);
    }

    void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    void fireValueChanged() {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    void updateBorder() {
        Border border = XObjectBorderFactory.getBorder((BorderProperties)this.editedBorder);
        this.previewPanel.drawBorder(border);
        this.fireValueChanged();
    }

    private void drawCustomborder(boolean hasTopBorder, boolean hasRightBorder, boolean hasBottomBorder, boolean hasLeftBorder) {
        Color colorToSet = null;
        int sizeToSet = 1;
        if (this.editedBorder.getTopStyle() != null) {
            colorToSet = ColorUtils.getColor((String)this.editedBorder.getTopColor());
            sizeToSet = this.editedBorder.getTopWidth();
        }
        this.colorChooser.setSelectedColor(ColorUtils.getColor((String)this.editedBorder.getTopColor()));
        this.borderTypeLst.setSelectedValue((Object)this.editedBorder.getTopStyle(), true);
        this.sizeCombo.setSelectedSize(this.editedBorder.getTopWidth());
        this.previewPanel.selectTop(hasTopBorder);
        if (colorToSet == null && this.editedBorder.getRightStyle() != null) {
            colorToSet = ColorUtils.getColor((String)this.editedBorder.getRightColor());
            sizeToSet = this.editedBorder.getRightWidth();
        }
        this.colorChooser.setSelectedColor(ColorUtils.getColor((String)this.editedBorder.getRightColor()));
        this.borderTypeLst.setSelectedValue((Object)this.editedBorder.getRightStyle(), true);
        this.sizeCombo.setSelectedSize(this.editedBorder.getRightWidth());
        this.previewPanel.selectRight(hasRightBorder);
        if (colorToSet == null && this.editedBorder.getBottomStyle() != null) {
            colorToSet = ColorUtils.getColor((String)this.editedBorder.getBottomColor());
            sizeToSet = this.editedBorder.getBottomWidth();
        }
        this.colorChooser.setSelectedColor(ColorUtils.getColor((String)this.editedBorder.getBottomColor()));
        this.borderTypeLst.setSelectedValue((Object)this.editedBorder.getBottomStyle(), true);
        this.sizeCombo.setSelectedSize(this.editedBorder.getBottomWidth());
        this.previewPanel.selectBottom(hasBottomBorder);
        if (colorToSet == null && this.editedBorder.getLeftStyle() != null) {
            colorToSet = ColorUtils.getColor((String)this.editedBorder.getLeftColor());
            sizeToSet = this.editedBorder.getLeftWidth();
        }
        this.colorChooser.setSelectedColor(ColorUtils.getColor((String)this.editedBorder.getLeftColor()));
        this.borderTypeLst.setSelectedValue((Object)this.editedBorder.getLeftStyle(), true);
        this.sizeCombo.setSelectedSize(this.editedBorder.getLeftWidth());
        this.previewPanel.selectLeft(hasLeftBorder);
        if (colorToSet == null) {
            colorToSet = Color.BLACK;
        }
        this.colorChooser.setSelectedColor(colorToSet);
        this.sizeCombo.setSelectedSize(sizeToSet);
    }

    private void redrawOutlineBorder() {
        if (this.settingPanel.isOutlineSelected()) {
            this.previewPanel.selectOutline();
        }
    }
}

