/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import oracle.bpm.designer.formdesigner.actions.FormDesignerAction;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.TablePopup;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

abstract class TablePopupAction<T extends XFormPresentationXMLObject>
extends FormDesignerAction {
    private final boolean showRows;
    private PresentationStructureView view;

    public TablePopupAction(Msg msg, boolean showRows, PresentationStructureView view) {
        super(msg);
        this.showRows = showRows;
        this.view = view;
    }

    @Override
    public void runAction(ActionEvent e) {
        UiComponent source = e.getSource();
        final PopUpWindow popup = new PopUpWindow(source.getOwnerWindow());
        final TablePopup tPopup = new TablePopup((UiContainer)popup, this.showRows);
        tPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if ("DONE".equals(ae.getActionCommand())) {
                    popup.setVisible(false);
                }
            }
        });
        popup.add((UiComponent)tPopup);
        popup.show(source);
        tPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if ("DONE".equals(e.getActionCommand())) {
                    int rows = tPopup.getRowCount();
                    int columns = tPopup.getColumnCount();
                    XFormPresentationXMLObject[] nodes = TablePopupAction.this.view.getSelectedItems();
                    if (nodes.length == 1 && TablePopupAction.this.isValid(columns, rows)) {
                        Object component = TablePopupAction.this.createComponent(rows, columns);
                        AddDataCommand command = new AddDataCommand((XFormXMLObject)nodes[0], (XFormPresentationXMLObject)component, TablePopupAction.this.view);
                        TablePopupAction.this.setIdForCommand(component, command);
                        TablePopupAction.this.view.invoke(command);
                    }
                }
            }
        });
    }

    protected abstract boolean isValid(int var1, int var2);

    protected abstract T createComponent(int var1, int var2);

    protected void setIdForCommand(T component, AddDataCommand command) {
    }
}

