/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import oracle.bpm.designer.ErrorList;
import oracle.bpm.designer.formdesigner.XObjectErrorListListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.compiler.FuegoObjectCheckerListenerImpl;
import oracle.bpm.xobject.lib.Checker;
import oracle.bpm.xobject.lib.CheckerListener;
import oracle.bpm.xobject.lib.XObjectCheckerMessage;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class PresentationCheck {
    public static boolean doCheck(boolean showErrors, ErrorList errorList, Project project, XFormPresentationModel model) {
        boolean hasErrors;
        Checker checker = new Checker(model.getOwner());
        FuegoObjectCheckerListenerImpl fObjectChekerListener = new FuegoObjectCheckerListenerImpl(true);
        checker.addListener((CheckerListener)fObjectChekerListener);
        if (errorList != null) {
            XObjectErrorListListener listener = new XObjectErrorListListener(errorList, project);
            checker.addListener((CheckerListener)listener);
        }
        ObjectTypeDescription owner = model.getOwner();
        checker.checkDataModel(owner);
        checker.checkPresentationModel(model, owner);
        if (showErrors) {
            XObjectCheckerMessage xocm = new XObjectCheckerMessage((XObjectTypeDescription)owner, fObjectChekerListener.getPresentationErr(), fObjectChekerListener.getPresentationWarn());
            if (fObjectChekerListener.getPresentationErr().size() > 0) {
                MessageDialog.showError(null, (Msg)DesignerMsg.PRESENTATION_CHECK_FAILED, (Msg)UIMsg.TO_MSG((String)xocm.getErrorAndWarningMessages()), null);
            } else if (fObjectChekerListener.getPresentationWarn().size() > 0) {
                MessageDialog.showWarning((Msg)DesignerMsg.PRESENTATION_CHECK_WARNING, (Msg)UIMsg.TO_MSG((String)xocm.getOnlyWarningMessages()), null);
            }
        }
        boolean bl = hasErrors = fObjectChekerListener.getPresentationErr().size() > 0;
        if (!hasErrors && checker.hasUxoConstraints() != !model.getPresentationIsuxo()) {
            model.getPresentation().isuxo = !checker.hasUxoConstraints();
        }
        return !hasErrors;
    }
}

