/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import java.util.List;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import oracle.bpm.designer.formdesigner.DndListener;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.PresentationDataPanel;
import oracle.bpm.designer.formdesigner.PresentationDesignerPanel;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.ClearDataCommand;
import oracle.bpm.designer.formdesigner.command.MoveDataCommand;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ListenerHelper {
    private static final Object MULTIPLE_SELECT = "multiple select";
    private static final Object SINGLE_SELECT = "single select";

    public static void addSelectionKeyStrokes(PresentationDesignerPanel panel) {
        PresentationPanel presentationPanel = panel.getPresentationPanel();
        final PresentationStructureView view = panel.getView();
        KeyStroke selectStroke = KeyStroke.getKeyStroke((int)32, (int)0);
        KeyStroke ctrlSelectStroke = KeyStroke.getKeyStroke((int)32, (int)128);
        KeyStroke shiftSelectStroke = KeyStroke.getKeyStroke((int)32, (int)64);
        InputMap ancestorInputMap = presentationPanel.getInputMap(1);
        ancestorInputMap.put(selectStroke.asSwing(), SINGLE_SELECT);
        ancestorInputMap.put(ctrlSelectStroke.asSwing(), MULTIPLE_SELECT);
        ancestorInputMap.put(shiftSelectStroke.asSwing(), MULTIPLE_SELECT);
        BaseAction multipleSelectAction = new BaseAction(){

            public void run() {
                PresentationComponent comp = ListenerHelper.getFocusedPresentationComponent();
                if (comp != null) {
                    view.addToSelection(comp.getReferencedObject());
                }
            }
        };
        BaseAction singleSelectAction = new BaseAction(){

            public void run() {
                PresentationComponent comp = ListenerHelper.getFocusedPresentationComponent();
                if (comp != null) {
                    view.select(comp.getReferencedObject());
                }
            }
        };
        ActionMap actionMap = presentationPanel.getActionMap();
        actionMap.put(SINGLE_SELECT, (javax.swing.Action)singleSelectAction);
        actionMap.put(MULTIPLE_SELECT, (javax.swing.Action)multipleSelectAction);
    }

    public static EventListener createEventHandler(final PresentationDataPanel panel) {
        final EventListener eventListener = new EventListener();
        eventListener.addMouseListener((MouseListener)new MouseAdapter(){

            private void maybeShowPopup(MouseEvent me) {
                if (MouseEventUtilities.isPopupTrigger((MouseEvent)me)) {
                    PresentationComponent comp = (PresentationComponent)me.getSource();
                    PopupMenu menu = panel.getPresentationViewCreator().getPopUpMenuForSelection((UiContainer)comp);
                    if (menu != null && menu.getItemCount() > 0) {
                        menu.show((UiComponent)comp, me.getX() + 7, me.getY() + 7);
                    }
                }
            }

            public void mouseReleased(MouseEvent me) {
                this.maybeShowPopup(me);
            }

            public void mousePressed(MouseEvent me) {
                this.checkAddSelection(me);
                this.maybeShowPopup(me);
            }

            private void checkAddSelection(MouseEvent me) {
                boolean isPopupTrigger = MouseEventUtilities.isPopupTrigger((MouseEvent)me);
                PresentationStructureView view = panel.getPresentationViewCreator();
                PresentationComponent comp = (PresentationComponent)me.getSource();
                XFormPresentationXMLObject reference = comp.getReferencedObject();
                XFormSelection xformSelection = new XFormSelection(reference, panel.getPropertyRefresher());
                if (!isPopupTrigger || !view.isSelected(reference)) {
                    Selection selection;
                    boolean addToSelection = me.isControlDown();
                    view.doSelect(reference, addToSelection);
                    if (addToSelection) {
                        Selection s = eventListener.getSelection();
                        if (s.isMultiple()) {
                            List allSelected = s.asList(Object.class);
                            allSelected.add(xformSelection);
                            selection = DefaultSelection.createMultiple((List)allSelected);
                        } else {
                            selection = DefaultSelection.createMultiple((Object[])new Object[]{s.as(Object.class), xformSelection});
                        }
                    } else {
                        selection = DefaultSelection.createSingle((Object)xformSelection);
                    }
                    eventListener.setSelection(selection);
                }
            }
        });
        eventListener.addDndListener(new DndListener(){

            @Override
            public void move(XFormPresentationXMLObject what, XFormPresentationXMLObject where) {
                this.doCommand(what, where, Action.MOVE);
            }

            @Override
            public void remove(XFormPresentationXMLObject what) {
                this.doCommand(what, null, Action.REMOVE);
            }

            @Override
            public void add(XFormPresentationXMLObject what, XFormPresentationXMLObject where) {
                this.doCommand(what, where, Action.COPY);
            }

            private void doCommand(XFormPresentationXMLObject what, XFormPresentationXMLObject where, Action action) {
                PresentationStructureView view = panel.getPresentationViewCreator();
                if (action == Action.REMOVE) {
                    view.invoke(new ClearDataCommand(view, what));
                } else {
                    panel.select(where);
                    XFormPresentationXMLObject[] treeSelection = view.getSelectedItems();
                    if (treeSelection.length == 1) {
                        if (action == Action.COPY) {
                            view.invoke(new AddDataCommand((XFormXMLObject)treeSelection[0], what, view));
                        } else if (action == Action.MOVE) {
                            view.invoke(new MoveDataCommand(view, treeSelection[0], what));
                        }
                        panel.modificationDone(what.getParent());
                    }
                }
            }
        });
        return eventListener;
    }

    private static PresentationComponent getFocusedPresentationComponent() {
        PresentationComponent result = null;
        UiComponent c = UiComponent.get((Object)FocusManager.getCurrentManager().getFocusOwner());
        if (c instanceof PresentationComponent) {
            result = (PresentationComponent)c;
        }
        return result;
    }

    static enum Action {
        COPY,
        MOVE,
        REMOVE;

    }
}

