/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorServiceInterface;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.designer.formdesigner.AbstractPresentationEditor;
import oracle.bpm.designer.formdesigner.BasicMessageListener;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.actions.FormDesignerAction;
import oracle.bpm.designer.formdesigner.actions.PresentationAdapterFactory;
import oracle.bpm.designer.formdesigner.components.FusionChartsWidget;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Environment;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.io.fs.WebRoot;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.browser.BrowserLauncherDialog;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.util.FileUtils;
import oracle.bpm.web.formdesigner.protocol.ComponentContextAction;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.runtime.XOExecutionController;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLPresentationBuilder;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;

public class HtmlPreviewAction
extends FormDesignerAction
implements ComponentContextAction {
    private XFormPresentationModel model;
    private static final String HTML_END_TAG = "</HTML>";
    private static final String WIDGET_FILE_NAME = "charts";

    public HtmlPreviewAction() {
        super(DesignerMsg.HTML);
        this.requires(XFormSelection.class);
    }

    public HtmlPreviewAction(AbstractPresentationEditor panel) {
        super(WebformdesignerMsg.PREVIEW_IN_BROWSER);
        this.requires(Void.class);
        this.model = panel.getModel();
    }

    @Override
    public void runAction(ActionEvent e) {
        this.showPreview();
    }

    public String getLabel() {
        return this.getMsg().getString();
    }

    public String getId() {
        return this.getMsg().getCode();
    }

    public XFormPresentationModel getModel() {
        XFormPresentationModel model = this.model;
        if (model == null) {
            XFormSelection selection = (XFormSelection)this.getSelection().as(XFormSelection.class);
            model = new PresentationAdapterFactory().adapt(selection, XFormPresentationModel.class);
        }
        return model;
    }

    public XScreenHTMLImpl getEditorScreen() throws ComponentExecutionException {
        return HTMLPresentationBuilder.buildEditorScreen((XFormPresentationModel)this.model, (Locale)this.getLocale(), (TimeZone)TimeZone.getDefault(), null);
    }

    private void showPreview() {
        ComponentExecutionException oldException = null;
        XScreenHTMLImpl xscreen = null;
        try {
            xscreen = (XScreenHTMLImpl)this.getPreview(this.getModel());
        }
        catch (ComponentExecutionException e) {
            if (Log.isDebugging()) {
                Log.logDebug(oldException);
            }
            oldException = e;
        }
        if (xscreen == null) {
            try {
                xscreen = this.getEditorScreen();
                MessageDialog.showError((Msg)DesignerMsg.CAN_NOT_PREVIEW, (Msg)WebformdesignerMsg.SHOWING_UNPROCESED_PREVIEW, (Throwable)oldException);
            }
            catch (ComponentExecutionException e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                MessageDialog.showError((Msg)DesignerMsg.CAN_NOT_PREVIEW, (Msg)DesignerMsg.CAN_NOT_PREVIEW_XOBJECT_HAS_ERRORS, (Throwable)oldException);
            }
        }
        if (xscreen != null) {
            String cssFileName = xscreen.getPage().getCssFilename();
            if (xscreen.isCssEnabled()) {
                cssFileName = this.findCss(cssFileName);
            }
            try {
                URL index = this.writePresentation(xscreen, cssFileName);
                BrowserLauncherDialog.openURL((URL)index);
            }
            catch (Exception e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                MessageDialog.showError((Msg)DesignerMsg.CAN_NOT_PREVIEW, (Msg)DesignerMsg.CAN_NOT_PREVIEW_XOBJECT_HAS_ERRORS, (Throwable)e);
            }
        }
    }

    private String findCss(String cssFileName) {
        FileProjectWriter projectWriter = (FileProjectWriter)this.getProject().getWriter();
        File resourcesDir = WebRoot.getResourcesDir((ProjectWriter)projectWriter);
        FileFilter fileFilter = WebContentType.CSS.getFileFilter(true);
        List<File> list = FileUtils.getFilesRecursively(resourcesDir, fileFilter, false);
        for (File file : list) {
            if (cssFileName.indexOf(file.getName()) == -1) continue;
            try {
                URL url = file.toURL();
                cssFileName = url.toString();
            }
            catch (MalformedURLException e) {
                cssFileName = file.getAbsolutePath();
            }
            break;
        }
        return cssFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL writePresentation(XScreenHTMLImpl xscreen, String cssFileName) throws IOException, URISyntaxException {
        BufferedWriter out = null;
        File index = null;
        try {
            index = File.createTempFile("index_tmp", ".html");
            index.deleteOnExit();
            File widgetDestinationFile = new File(index.getParentFile(), WIDGET_FILE_NAME);
            if (!widgetDestinationFile.exists()) {
                URL widgetSourceDir = new URL(FusionChartsWidget.getRelativePath());
                File widgetSourceFile = new File(new File(widgetSourceDir.toURI()), WIDGET_FILE_NAME);
                FileUtils.copyFileOrDirectory(widgetSourceFile, widgetDestinationFile);
            }
            String encoding = Literals.DEFAULT_ENCODING;
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(index), encoding));
            out.write(this.getHTMLHeader(cssFileName, encoding));
            out.write(xscreen.getDocumentHtmlText());
            out.write(HTML_END_TAG);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        return index.toURL();
    }

    private String getHTMLHeader(String cssFileName, String encoding) {
        return "<HTML>\n<head>\n<title></title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\">\n<link rel =\"stylesheet\" type=\"text/css\" href=\"" + cssFileName + "\">\n</head>";
    }

    private XScreen getPreview(XFormPresentationModel model) throws ComponentExecutionException {
        FuegoInvokeable invokeable;
        BasicMessageListener messageListener = new BasicMessageListener();
        this.setConnectorService(FuegoProject.getFrom((TypeRef)model.getOwner()), AbstractStudioWorkbench.getEnvironment());
        try {
            XObjectTypeDescription xo = (XObjectTypeDescription)model.getOwner();
            invokeable = FuegoCompiler.createInvokeable((XObjectTypeDescription)xo, (MessageListener)messageListener);
        }
        catch (CilException e) {
            return null;
        }
        XOExecutionController xoController = XOExecutionController.newHTMLPreview((Object)invokeable, (String)model.getPresentationName(), (Locale)this.getLocale(), (TimeZone)TimeZone.getDefault());
        xoController.preview();
        return xoController.getCurrentManager().getXScreen();
    }

    private void setConnectorService(FuegoProject project, Environment env) {
        ConnectorServiceInterface prevService;
        ConnectorService cs = project.getConnectorService(env);
        if (!cs.equals(prevService = ConnectorTransaction.getDefaultConnectorService())) {
            if (prevService != null && prevService.isStarted()) {
                prevService.stop();
            }
            ConnectorTransaction.setDefaultConnectorService(cs);
        }
    }

    private Locale getLocale() {
        Project project = this.getProject();
        return project == null ? null : project.getDefaultLanguage();
    }

    private Project getProject() {
        return ((BPMObjectEditor)AbstractStudioWorkbench.getInstance().getSelectedEditor()).getProject();
    }
}

