/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.formdesigner.AbstractPresentationEditor;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.actions.AddButtonAction;
import oracle.bpm.designer.formdesigner.actions.AddComponentAction;
import oracle.bpm.designer.formdesigner.actions.ClipBoardActions;
import oracle.bpm.designer.formdesigner.actions.FormDesignerAction;
import oracle.bpm.designer.formdesigner.actions.HtmlPreviewAction;
import oracle.bpm.designer.formdesigner.actions.PresentationAdapterFactory;
import oracle.bpm.designer.formdesigner.actions.TablePopupAction;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.model.TranslatableProperty;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormCheck;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.presentationmodel.XFormDatetimepiker;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormIframe;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.presentationmodel.XFormInterval;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormMultilinetext;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRadio;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.presentationmodel.XFormRepeatablesection;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class FormDesignerActions {
    private List<AddComponentAction> addComponentActions;
    private ClipBoardActions clipboardActions;
    private FormDesignerAction htmlPreviewAction;
    private FormDesignerAction i18NAction;
    private boolean initialized = false;
    private final ChangeListener listener;
    private AbstractPresentationEditor presentationDesignerPanel;
    private PresentationStructureView view;

    public FormDesignerActions(PresentationStructureView view, AbstractPresentationEditor presentationDesignerPanel, ChangeListener listener) {
        assert (view != null);
        this.listener = listener;
        this.view = view;
        this.presentationDesignerPanel = presentationDesignerPanel;
        this.addComponentActions = new ArrayList<AddComponentAction>();
    }

    public static boolean isRepeatableDirectSon(Selection selection) {
        boolean result;
        XFormRepeatable repeatable = FormDesignerActions.getParent(selection, XFormRepeatable.class);
        if (repeatable != null) {
            XFormTable table;
            result = true;
            if (repeatable instanceof XFormRepeatablesection && (table = FormDesignerActions.getParent(selection, XFormTable.class)) != null) {
                PresentationAdapterFactory paf = new PresentationAdapterFactory();
                XFormRepeatable tableRepetableAncestor = paf.adapt(table, XFormRepeatable.class);
                result = tableRepetableAncestor != repeatable;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static <T> T getParent(Selection selection, Class<T> type) {
        Object result = selection.as(type);
        if (result == null) {
            PresentationAdapterFactory paf = new PresentationAdapterFactory();
            Object innerSelection = selection.as(Object.class);
            result = paf.adapt(innerSelection, type);
        }
        return (T)result;
    }

    public void setAvailable(int actions, ToolbarListener.ToolbarInteractions t, boolean isReadOnly) {
        this.getClipBorardActionManager().enable(actions, isReadOnly);
        boolean addComponents = (actions & 0x10) != 0 && !isReadOnly;
        boolean addArrayComponents = (actions & 0x20) != 0 && !isReadOnly;
        for (AddComponentAction action : this.addComponentActions) {
            action.enable(addComponents, addArrayComponents);
        }
    }

    public ClipBoardActions getClipBorardActionManager() {
        if (this.clipboardActions == null) {
            this.clipboardActions = new ClipBoardActions(this.getPresentationView(), this.listener);
        }
        return this.clipboardActions;
    }

    public FormDesignerAction getHtmlPreviewAction() {
        if (this.htmlPreviewAction == null) {
            this.htmlPreviewAction = new HtmlPreviewAction(this.presentationDesignerPanel);
        }
        return this.htmlPreviewAction;
    }

    public FormDesignerAction getI18NAction(final ComponentInteractionProvider componentInteractionProvider) {
        if (this.i18NAction == null) {
            this.i18NAction = new FormDesignerAction(DesignerMsg.FUEGOOBJECT_RESOURCES){

                @Override
                public void runAction(ActionEvent e) {
                    Map<String, XObjectTypeDescription.ResourceValue> allResources = componentInteractionProvider.getResources();
                    TranslatableProperty.editResources(DesignerMsg.FUEGOOBJECT_RESOURCES, allResources);
                }
            };
        }
        return this.i18NAction;
    }

    public void addTo(ToolBar gtoolbar) {
        if (!this.initialized()) {
            this.init();
        }
        for (AddComponentAction action : this.addComponentActions) {
            if (action.hasDropDown()) {
                gtoolbar.addCompositeButton((BaseAction)action, (BaseAction)action.getDropDown());
                continue;
            }
            gtoolbar.add((BaseAction)action);
        }
    }

    private boolean initialized() {
        return this.initialized;
    }

    private PresentationStructureView getPresentationView() {
        return this.view;
    }

    private void init() {
        this.addComponentActions.add(this.createArrayEnableComponentAction(XFormCombo.class, WebformdesignerMsg.COMBO));
        AddComponentAction compositeAction = this.createArrayEnableComponentAction(XFormButton.class, WebformdesignerMsg.BUTTON);
        compositeAction.setDropDown(new FormDesignerAction(WebformdesignerMsg.BUTTON){

            @Override
            public void runAction(ActionEvent e) {
                PopupMenu popup = new PopupMenu((UiContainer)FormDesignerActions.this.presentationDesignerPanel);
                popup.add((BaseAction)new AddButtonAction(WebformdesignerMsg.SUBMIT_BUTTON, 0, FormDesignerActions.this.getPresentationView()));
                popup.add((BaseAction)new AddButtonAction(WebformdesignerMsg.CANCEL_BUTTON, 1, FormDesignerActions.this.getPresentationView()));
                popup.add((BaseAction)new AddButtonAction(WebformdesignerMsg.RESET_BUTTON, 2, FormDesignerActions.this.getPresentationView()));
                popup.add((BaseAction)new AddButtonAction(WebformdesignerMsg.REFRESH_BUTTON, 3, FormDesignerActions.this.getPresentationView()));
                popup.add((BaseAction)new AddButtonAction(WebformdesignerMsg.BUTTON, 4, FormDesignerActions.this.getPresentationView()));
                UiComponent source = e.getSource();
                popup.show(source, 0, source.getHeight());
            }
        });
        this.addComponentActions.add(compositeAction);
        this.addComponentActions.add(this.createArrayEnableComponentAction(XFormCheck.class, WebformdesignerMsg.CHECK));
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormImage.class, WebformdesignerMsg.IMAGE));
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormMultilinetext.class, WebformdesignerMsg.MULTILINETEXT));
        this.addComponentActions.add(this.createArrayEnableComponentAction(XFormText.class, WebformdesignerMsg.TEXT));
        this.addComponentActions.add(new AddComponentAction(null, DesignerMsg.PASSWORD_FIELD, this.getPresentationView(), true){

            @Override
            public void runAction(ActionEvent e) {
                XFormText text = new XFormText();
                text.setPasswordField(true);
                XFormPresentationXMLObject[] selection = FormDesignerActions.this.view.getSelectedItems();
                if (selection.length == 1) {
                    AddDataCommand command = new AddDataCommand((XFormXMLObject)selection[0], text, FormDesignerActions.this.view);
                    String name = text.getName().toLowerCase();
                    command.setId(FormDesignerActions.this.view.getIdFor(name));
                    FormDesignerActions.this.view.invoke(command);
                }
            }
        });
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormRadio.class, WebformdesignerMsg.RADIO));
        compositeAction = this.createNonArrayEnableComponentAction(XFormTable.class, WebformdesignerMsg.TABLE);
        compositeAction.setDropDown(new TablePopupAction<XFormTable>(WebformdesignerMsg.TABLE, true, this.getPresentationView()){

            @Override
            protected boolean isValid(int rows, int columns) {
                return columns != 0 && rows != 0;
            }

            @Override
            protected XFormTable createComponent(int rows, int columns) {
                return new XFormTable(rows, columns);
            }
        });
        this.addComponentActions.add(compositeAction);
        this.addComponentActions.add(this.createArrayEnableComponentAction(XFormLabel.class, WebformdesignerMsg.LABEL));
        this.addComponentActions.add(this.createArrayEnableComponentAction(XFormLink.class, WebformdesignerMsg.LINK));
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormIframe.class, WebformdesignerMsg.IFRAME));
        compositeAction = this.createNonArrayEnableComponentAction(XFormArray.class, WebformdesignerMsg.ARRAY);
        compositeAction.setDropDown(new TablePopupAction<XFormArray>(WebformdesignerMsg.ARRAY, false, this.getPresentationView()){

            @Override
            protected boolean isValid(int rows, int columns) {
                return columns != 0;
            }

            @Override
            protected XFormArray createComponent(int rows, int columns) {
                return new XFormArray(columns);
            }

            @Override
            protected void setIdForCommand(XFormArray component, AddDataCommand command) {
                String name = component.getName().toLowerCase();
                command.setId(FormDesignerActions.this.view.getIdFor(name));
            }
        });
        this.addComponentActions.add(compositeAction);
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormRepeatablesection.class, WebformdesignerMsg.REPEATABLESECTION));
        this.addComponentActions.add(this.createArrayEnableComponentAction(XFormDatetimepiker.class, WebformdesignerMsg.DATETIMEPICKER));
        this.addComponentActions.add(this.createArrayEnableComponentAction(XFormInterval.class, WebformdesignerMsg.INTERVAL));
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormGauge.class, WebformdesignerMsg.GAUGE));
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormChart.class, WebformdesignerMsg.CHART));
        this.addComponentActions.add(this.createNonArrayEnableComponentAction(XFormPie.class, WebformdesignerMsg.PIE));
        this.initialized = true;
    }

    private AddComponentAction createNonArrayEnableComponentAction(Class<? extends XFormPresentationXMLObject> componentClass, Msg msg) {
        return new AddComponentAction(componentClass, msg, this.getPresentationView(), false);
    }

    private AddComponentAction createArrayEnableComponentAction(Class<? extends XFormPresentationXMLObject> componentClass, Msg msg) {
        return new AddComponentAction(componentClass, msg, this.getPresentationView(), true);
    }
}

