/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.actions.FormDesignerAction;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.ClearDataCommand;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ClipBoardActions {
    private ClipBoardAction clearAction;
    private XFormPresentationXMLObject copiedObject;
    private boolean copy;
    private ClipBoardAction copyAction;
    private ClipBoardAction cutAction;
    private ChangeListener listener;
    private ClipBoardAction pasteAction;
    private PresentationStructureView view;

    public ClipBoardActions(PresentationStructureView view, ChangeListener listener) {
        this.view = view;
        this.listener = listener;
        this.clearAction = new ClearAction();
        this.copyAction = new CopyAction();
        this.cutAction = new CutAction();
        this.pasteAction = new PasteAction();
    }

    public FormDesignerAction getClearAction() {
        return this.clearAction;
    }

    public BaseAction getCopyAction() {
        return this.copyAction;
    }

    public BaseAction getCutAction() {
        return this.cutAction;
    }

    public BaseAction getPasteAction() {
        return this.pasteAction;
    }

    public boolean canPaste(PresentationComponent component) {
        return this.canPaste(component.getReferencedObject());
    }

    public boolean canPaste(XFormXMLObject content) {
        boolean existCopy;
        boolean canPaste = false;
        boolean bl = existCopy = this.copiedObject != null && !(this.copiedObject instanceof XFormPresentation);
        if (content instanceof XFormPresentationXMLObject) {
            int componentId = ((XFormPresentationXMLObject)content).getComponentID();
            if (componentId == 3) {
                boolean copyIsCell = this.copiedObject instanceof XFormCell;
                boolean copyIsRow = this.copiedObject instanceof XFormRow;
                canPaste = existCopy && !copyIsCell && !copyIsRow && ((XFormCell)content).hasSpace() && Utilities.isContainer(content, this.copiedObject);
            } else if (componentId == 10 || componentId == 11) {
                canPaste = existCopy;
            }
        }
        return canPaste;
    }

    protected void enable(int actions, boolean isReadOnly) {
        this.cutAction.doEnable(actions, isReadOnly);
        this.copyAction.doEnable(actions, isReadOnly);
        this.pasteAction.doEnable(actions, isReadOnly);
        this.clearAction.doEnable(actions, isReadOnly);
    }

    private PresentationStructureView getView() {
        return this.view;
    }

    private class PasteAction
    extends ClipBoardAction {
        public PasteAction() {
            super(DesignerMsg.PASTE, 4);
        }

        @Override
        public void runAction(ActionEvent e) {
            XFormPresentationXMLObject[] selection;
            if (ClipBoardActions.this.copiedObject != null && (selection = ClipBoardActions.this.getView().getSelectedItems()).length == 1) {
                XFormPresentationXMLObject newObject = ClipBoardActions.this.copiedObject.clone();
                AddDataCommand command = AddDataCommand.getPasteCommand(selection[0], newObject, ClipBoardActions.this.copy, ClipBoardActions.this.view);
                ClipBoardActions.this.getView().invoke(command);
                this.modificationDone();
            }
        }
    }

    private class CutAction
    extends CopyAction {
        public CutAction() {
            super(DesignerMsg.CUT, 1, false);
        }

        @Override
        protected XFormPresentationXMLObject doCopy(PresentationStructureView view, XFormPresentationXMLObject selection) {
            XFormPresentationXMLObject result = super.doCopy(view, selection);
            view.invoke(new ClearDataCommand(view, selection));
            this.modificationDone();
            return result;
        }
    }

    private class CopyAction
    extends ClipBoardAction {
        private final boolean isCopy;

        public CopyAction() {
            this(DesignerMsg.COPY, 2, true);
        }

        public CopyAction(Msg msg, int action, boolean isCopy) {
            super(msg, action);
            this.isCopy = isCopy;
        }

        @Override
        public void runAction(ActionEvent e) {
            XFormPresentationXMLObject[] selection = ClipBoardActions.this.getView().getSelectedItems();
            if (selection.length == 1) {
                ClipBoardActions.this.copiedObject = this.doCopy(ClipBoardActions.this.getView(), selection[0]);
            } else {
                ClipBoardActions.this.copiedObject = null;
            }
            ClipBoardActions.this.copy = this.isCopy;
        }

        protected XFormPresentationXMLObject doCopy(PresentationStructureView view, XFormPresentationXMLObject selection) {
            return selection;
        }
    }

    private class ClearAction
    extends ClipBoardAction {
        public ClearAction() {
            super(UIMsg.DELETE_SOMETHING((String)DesignerMsg.COMPONENT.toString()), 8);
        }

        @Override
        public void runAction(ActionEvent e) {
            ClipBoardActions.this.getView().clear();
            this.modificationDone();
        }
    }

    private abstract class ClipBoardAction
    extends FormDesignerAction {
        private final int thisAction;

        public ClipBoardAction(Msg msg, int thisAction) {
            super(msg);
            this.thisAction = thisAction;
        }

        protected void doEnable(int actions, boolean isReadOnly) {
            this.setEnabled((actions & this.thisAction) != 0 && !isReadOnly);
        }

        protected void modificationDone() {
            ClipBoardActions.this.listener.changeOccured(ChangeListener.EventFactory.createTopLevelChange());
        }
    }
}

