/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import oracle.bpm.designer.formdesigner.actions.FormDesignerAction;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class AddComponentAction
extends FormDesignerAction {
    private FormDesignerAction dropDown;
    private boolean isArrayEnabled;
    private Class<? extends XFormPresentationXMLObject> theClass;
    private PresentationStructureView view;
    static final long serialVersionUID = 2345683418295265338L;
    static final long serialCheck = -6400019195541263468L;

    public AddComponentAction(Class<? extends XFormPresentationXMLObject> theClass, Msg msg, PresentationStructureView view, boolean isArrayEnabled) {
        super(msg);
        this.theClass = theClass;
        this.view = view;
        this.isArrayEnabled = isArrayEnabled;
    }

    public void enable(boolean addComponents, boolean addOnlyArrayComponents) {
        boolean enable = addComponents;
        if (!this.isArrayEnabled) {
            enable = enable && !addOnlyArrayComponents;
        }
        this.doEnabled(enable);
    }

    public boolean hasDropDown() {
        return this.dropDown != null;
    }

    public FormDesignerAction getDropDown() {
        return this.dropDown;
    }

    public void setDropDown(FormDesignerAction dropDown) {
        this.dropDown = dropDown;
    }

    @Override
    public void runAction(ActionEvent e) {
        UiWindow window;
        AddDataCommand command;
        XFormPresentationXMLObject[] treeSelection = this.view.getSelectedItems();
        if (treeSelection.length == 1 && (command = AddDataCommand.createCommand(this.theClass, (UiComponent)(window = UiWindow.getFrom((UiComponent)this.view.getDisplayComponent())), treeSelection[0], this.view)) != null) {
            this.view.invoke(command);
        }
    }

    private void doEnabled(boolean enable) {
        this.setEnabled(enable);
        if (this.hasDropDown()) {
            this.getDropDown().setEnabled(enable);
        }
    }
}

