/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner.actions;

import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

class AddButtonAction
extends BaseAction {
    private int buttonType;
    private PresentationStructureView view;

    public AddButtonAction(Msg resource, int buttonType, PresentationStructureView view) {
        super(resource);
        this.buttonType = buttonType;
        this.view = view;
    }

    public void run() {
        this.doAdd(this.buttonType);
    }

    protected void updateEnableStatus(Selection s) {
        super.updateEnableStatus(s);
        XFormPresentationXMLObject[] selection = this.view.getSelectedItems();
        if (selection.length != 1) {
            this.setEnabled(false);
        }
    }

    private void doAdd(int option) {
        XFormPresentationXMLObject[] selection = this.view.getSelectedItems();
        if (selection.length == 1) {
            XFormButton theButton = new XFormButton();
            theButton.setAction(option);
            AddDataCommand command = new AddDataCommand((XFormXMLObject)selection[0], theButton, this.view);
            try {
                String name = theButton.getName().toLowerCase();
                command.setId(this.view.getIdFor(name));
            }
            catch (Exception ez) {
                ez.printStackTrace();
            }
            this.view.invoke(command);
        }
    }
}

