/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import oracle.bpm.cil.WarningExceptionInterface;
import oracle.bpm.designer.ErrorList;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.xobject.lib.CheckerListener;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XObjectErrorListListener
implements CheckerListener {
    ErrorList errorList;
    private Project project;

    public XObjectErrorListListener(ErrorList errorList) {
        this.errorList = errorList;
    }

    public XObjectErrorListListener(ErrorList errorList, Project project) {
        this.errorList = errorList;
        this.project = project;
    }

    public void error(ObjectTypeDescription owner, String err, XFormXMLObject where, XFormPresentationXMLObject model) {
        this.report(err, where, model, true);
    }

    public void error(ObjectTypeDescription xo, String err, String where) {
        Object source;
        if (where != null && where.startsWith("%attr%")) {
            where = where.substring("%attr%".length());
        }
        this.errorList.report((source = this.findObject(xo.getId())) == null ? xo.getText() : source, new Exception(err), false);
    }

    public void nonFatalError(ObjectTypeDescription owner, String err, XFormXMLObject where, XFormPresentationXMLObject model) {
        this.report(err, where, model, true);
    }

    public void resetErrAndWarn() {
    }

    public void warning(ObjectTypeDescription owner, String err, XFormXMLObject where, XFormPresentationXMLObject model) {
        this.report(err, where, model, false);
    }

    private Object findObject(String id) {
        CatalogObject source = null;
        if (id == null) {
            return null;
        }
        try {
            source = this.project.findCatalogObject(id);
        }
        catch (Exception e) {
            Log.logWarning(e);
        }
        return source;
    }

    private void report(String err, XFormXMLObject where, XFormPresentationXMLObject model, boolean isError) {
        Object parentSource = this.findObject(model.getId());
        XFormPresentationXMLObject xFormPresentationXMLObject = (XFormPresentationXMLObject)where;
        PresentationCheckException ex = new PresentationCheckException(err, xFormPresentationXMLObject);
        ex.setWarning(!isError);
        this.errorList.report(parentSource, ex, !isError);
    }

    public static class PresentationCheckException
    extends Exception
    implements WarningExceptionInterface {
        String error;
        XFormPresentationXMLObject object;
        private boolean warning;
        static final long serialVersionUID = -7412600122434759033L;
        static final long serialCheck = -1237803140691670203L;

        public PresentationCheckException(String error, XFormPresentationXMLObject object) {
            this.error = error;
            this.object = object;
        }

        public String getComponentId() {
            return this.object.getId();
        }

        @Override
        public String getMessage() {
            String where = this.object instanceof XFormPresentation ? "" : (this.object.getId() == null ? this.object.getName() : this.object.getId());
            return this.error + " " + where;
        }

        public void setWarning(boolean warning) {
            this.warning = warning;
        }

        @Override
        public boolean isWarning() {
            return this.warning;
        }
    }
}

