/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

public class XFormSelectionBuilder {
    private Hashtable<String, XFormPresentationXMLObject> ids;
    private XFormPresentationModel model;
    private XFormSelection.PropertyRefresher refresher;

    public XFormSelectionBuilder(XFormPresentationModel model, XFormSelection.PropertyRefresher refresher) {
        this.model = model;
        this.refresher = refresher;
        this.ids = new Hashtable();
    }

    public Selection buildSelection(String ... componentIds) {
        return this.buildSelection(Arrays.asList(componentIds));
    }

    public Selection buildSelection(List<String> componentIds) {
        ArrayList<XFormSelection> selectedComponents = new ArrayList<XFormSelection>();
        for (String componentId : componentIds) {
            XFormPresentationXMLObject component = this.getComponentForId(componentId);
            if (component == null) continue;
            XFormSelection xformSelection = new XFormSelection(component, this.refresher);
            selectedComponents.add(xformSelection);
        }
        return DefaultSelection.createMultiple(selectedComponents);
    }

    public Selection buildSelection(XFormPresentationXMLObject ... componentIds) {
        List<XFormPresentationXMLObject> components = Arrays.asList(componentIds);
        ArrayList<XFormSelection> selectedComponents = new ArrayList<XFormSelection>();
        for (XFormPresentationXMLObject component : components) {
            XFormSelection xformSelection = new XFormSelection(component, this.refresher);
            selectedComponents.add(xformSelection);
        }
        return DefaultSelection.createMultiple(selectedComponents);
    }

    public Selection buildSelection(Selection currentSelection, String componentId) {
        XFormPresentationXMLObject component = this.getComponentForId(componentId);
        return this.buildSelection(currentSelection, component);
    }

    public Selection buildSelection(Selection currentSelection, XFormPresentationXMLObject component) {
        XFormSelection xformSelection = new XFormSelection(component, this.refresher);
        return DefaultSelection.createMultiple((Object[])new Object[]{currentSelection, xformSelection});
    }

    private XFormPresentationXMLObject getComponentForId(String componentId) {
        XFormPresentationXMLObject result = this.ids.get(componentId);
        if (result != null && !componentId.equals(result.getId())) {
            result = null;
            this.ids.remove(componentId);
        }
        if (result == null && (result = this.model.getPresentation().findComponent(componentId)) != null) {
            this.ids.put(componentId, result);
        }
        return result;
    }
}

