/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XFormSelection
implements Adaptable {
    private final PropertyRefresher refresher;
    private final XFormPresentationXMLObject selection;

    public XFormSelection(XFormPresentationXMLObject selection, PropertyRefresher refresher) {
        this.selection = selection;
        this.refresher = refresher;
    }

    public void refreshProperties(PropertyTable propertyTable) {
        this.refresher.refreshProperties(propertyTable, this.selection);
    }

    public void refreshProperties(PropertyTable propertyTable, List<XFormSelection> multipleSelection) {
        ArrayList<XFormPresentationXMLObject> completeSelection = new ArrayList<XFormPresentationXMLObject>();
        for (XFormSelection xFormSelection : multipleSelection) {
            completeSelection.add(xFormSelection.getSelection());
        }
        this.refresher.refreshProperties(propertyTable, completeSelection);
    }

    public XFormPresentationXMLObject getSelection() {
        return this.selection;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.refresher == null ? 0 : this.refresher.hashCode());
        result = 31 * result + (this.selection == null ? 0 : this.selection.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XFormSelection other = (XFormSelection)obj;
        if (this.refresher == null ? other.refresher != null : !this.refresher.equals(other.refresher)) {
            return false;
        }
        return !(this.selection == null ? other.selection != null : !this.selection.equals(other.selection));
    }

    @Override
    public <T> T as(Class<T> targetType) {
        if (targetType == XFormPresentationXMLObject.class || targetType == XFormXMLObject.class) {
            return (T)this.getSelection();
        }
        return null;
    }

    public static interface PropertyRefresher {
        public void refreshProperties(PropertyTable var1, XFormPresentationXMLObject var2);

        public void refreshProperties(PropertyTable var1, List<XFormPresentationXMLObject> var2);
    }
}

