/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.lang.reflect.Field;
import oracle.bpm.draw.Color;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class Utilities {
    public static final String RIGHT_ALIGN = "right";
    public static final String LEFT_ALIGN = "left";
    public static final String CENTER_ALIGN = "center";

    public static String getString(Color currentColor) {
        if (currentColor != null) {
            String redComp = Integer.toHexString(currentColor.getRed());
            while (redComp.length() < 2) {
                redComp = "0" + redComp;
            }
            String gComp = Integer.toHexString(currentColor.getGreen());
            while (gComp.length() < 2) {
                gComp = "0" + gComp;
            }
            String bComp = Integer.toHexString(currentColor.getBlue());
            while (bComp.length() < 2) {
                bComp = "0" + bComp;
            }
            return "#" + redComp + gComp + bComp;
        }
        return null;
    }

    public static boolean isArray(Field field, Class childClass) {
        Class<?> fieldType = field.getType();
        return fieldType.isArray() && fieldType.getComponentType().equals(childClass);
    }

    public static boolean canCopy(XFormPresentationXMLObject selection) {
        XFormComponentType componentType;
        boolean canCopy = selection != null ? (componentType = selection.getComponentType()) != XFormComponentType.CELL && componentType != XFormComponentType.ROW && componentType != XFormComponentType.PRESENTATION : false;
        return canCopy;
    }

    public static boolean canAdd(XFormPresentationXMLObject target, XFormPresentationXMLObject copiedObject) {
        boolean enable;
        if (copiedObject != null) {
            XFormComponentType copyType = copiedObject.getComponentType();
            switch (target.getComponentType()) {
                case ROW: {
                    enable = copyType == XFormComponentType.CELL;
                    break;
                }
                case CELL: {
                    enable = copyType != XFormComponentType.CELL && copyType != XFormComponentType.ROW;
                    enable = enable && copyType != XFormComponentType.PRESENTATION;
                    enable = enable && ((XFormCell)target).hasSpace();
                    enable = enable && !Utilities.isContainer(target, copiedObject);
                    break;
                }
                case TABLE: {
                    enable = copyType == XFormComponentType.ROW;
                    break;
                }
                case REPEATABLESECTION: 
                case ARRAY: {
                    enable = copyType == XFormComponentType.CELL;
                    break;
                }
                default: {
                    enable = false;
                    break;
                }
            }
        } else {
            enable = false;
        }
        return enable;
    }

    public static boolean isContainer(XFormXMLObject selection, XFormPresentationXMLObject copy) {
        do {
            if (selection != copy) continue;
            return true;
        } while ((selection = selection.getParent()) != null);
        return false;
    }
}

