/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;

public class PresentationSelectionProvider
implements SelectionProvider {
    private boolean firing;
    private List<SelectionListener> listeners;
    private Selection selection;

    public PresentationSelectionProvider() {
    }

    public PresentationSelectionProvider(Selection initialSelection) {
        this.setSelection(initialSelection);
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void setSelection(Selection selection) {
        this.selection = selection;
        this.fireSelectionChanged();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<SelectionListener>();
        }
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void fireSelectionChanged(Selection selection) {
        this.setSelection(selection);
        this.fireSelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireSelectionChanged() {
        try {
            if (!this.firing) {
                this.firing = true;
                if (this.listeners != null) {
                    SelectionListener[] array;
                    for (SelectionListener listener : array = this.listeners.toArray(new SelectionListener[this.listeners.size()])) {
                        listener.selectionChanged(this.selection);
                    }
                }
            }
        }
        finally {
            this.firing = false;
        }
    }
}

