/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.PresentationDataPanel;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.ModifyLinkTextCommand;
import oracle.bpm.designer.formdesigner.command.ModifyObjectValueCommand;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.components.PresentationRow;
import oracle.bpm.designer.formdesigner.components.RealPresentation;
import oracle.bpm.designer.formdesigner.editors.ComponentEditor;
import oracle.bpm.designer.formdesigner.editors.EditorData;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.editors.SimpleComponentEditors;
import oracle.bpm.designer.formdesigner.outline.DataModelTreeNode;
import oracle.bpm.designer.formdesigner.outline.NodeProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.PropertyMerger;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.xobject.presentationmodel.XFormBackground;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormLink;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormValue;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class PresentationPanel
extends Panel {
    private ChangeListener changeListener;
    private ComponentInteractionProvider componentInteractionProvider;
    private PresentationDataPanel dataPanel;
    private EditorData editorData;
    private final EditorRegistry editorRegistry;
    private Vector<PresentationComponent> lastSelectedComponents;
    private XFormPresentationModel model;
    private NodeProvider nodeProvider = null;
    private RealPresentation presentationPanel;
    private boolean showImgs;
    private boolean showLines;
    private EventListener theListener = null;

    public PresentationPanel(UiContainer parent, XFormPresentationModel model, EventListener l, PresentationDataPanel dataPanel, EditorRegistry editorRegistry, ChangeListener changeListener) {
        super(parent);
        this.changeListener = changeListener;
        this.model = model;
        this.dataPanel = dataPanel;
        this.editorRegistry = editorRegistry;
        this.setListener(l);
        this.init(true);
    }

    public void setComponentInteractionProvider(ComponentInteractionProvider componentInteractionProvider) {
        this.componentInteractionProvider = componentInteractionProvider;
    }

    public ComponentInteractionProvider getComponentInteractionProvider() {
        return this.componentInteractionProvider;
    }

    public PresentationComponent[] getLastSelectedComponents() {
        return this.lastSelectedComponents == null ? new PresentationComponent[]{} : this.lastSelectedComponents.toArray(new PresentationComponent[0]);
    }

    public void setNodeProvider(NodeProvider nodeProvider) {
        this.nodeProvider = nodeProvider;
    }

    public PresentationComponent getPresentationComponent(Object o) {
        return o == null ? null : this.getEditorData().getHash().get(o);
    }

    public RealPresentation getRealPresentation() {
        return this.presentationPanel;
    }

    public boolean isSelectedComponent(PresentationComponent theComponent) {
        return this.lastSelectedComponents != null && this.lastSelectedComponents.contains((Object)theComponent);
    }

    public void setShowImages(boolean show) {
        this.showImgs = show;
    }

    public void setShowLines(boolean show) {
        this.showLines = show;
    }

    public void addLastSelectedComponent(PresentationComponent lastSelectedComponent) {
        if (this.lastSelectedComponents == null) {
            this.lastSelectedComponents = new Vector();
        }
        if (!this.lastSelectedComponents.contains((Object)lastSelectedComponent)) {
            this.lastSelectedComponents.add(lastSelectedComponent);
        }
    }

    public void doProcessChange(ChangeListener.ChangeEvent event) {
        if (event.isTopLevelChange()) {
            this.doReInit();
        } else if (event.isObjectChange()) {
            this.reloadComponent(event.asObjectEvent().getObjectChange());
        } else if (event.isPropertyChange()) {
            ChangeListener.PropertyChangeEvent property = event.asPropertyChange();
            XFormXMLObject changedObject = property.getChangedObject();
            String propertyName = property.getPropertyName();
            this.processChange(changedObject, propertyName);
        }
    }

    public void clearLastSelectedComponents() {
        if (this.lastSelectedComponents != null) {
            for (PresentationComponent component : this.lastSelectedComponents) {
                if (!component.isDisposed()) {
                    component.setSelectedBorder(false);
                    continue;
                }
                System.out.println("PresentationPanel.clearLastSelectedComponents() component was disposed!!!");
            }
            this.lastSelectedComponents = null;
        }
    }

    public void modifyProperty(XFormXMLObject which, Object value, String propertyName) {
        this.invoke(new ModifyPropertyValueCommand(which, value, propertyName, this.changeListener));
    }

    public void modifyValue(XFormLabel referencedLabel, String newValue) {
        this.invoke(new ModifyObjectValueCommand(referencedLabel, newValue, this.changeListener, this.dataPanel.getPresentationViewCreator(null)));
    }

    public void modifyValue(XFormLink referencedLink, String newValue) {
        this.invoke(new ModifyLinkTextCommand(referencedLink, newValue, this.changeListener));
    }

    public void refresh(boolean showLines, boolean showImgs) {
        this.setShowLines(showLines);
        this.setShowImages(showImgs);
        this.changeListener.changeOccured(ChangeListener.EventFactory.createTopLevelChange());
    }

    public void refreshProperties() {
        this.dataPanel.refreshProperties();
    }

    public void refreshProperties(PropertyTable table, XFormPresentationXMLObject ... selection) {
        if (this.lastSelectedComponents != null) {
            this.lastSelectedComponents.clear();
        } else {
            this.lastSelectedComponents = new Vector();
        }
        for (XFormPresentationXMLObject xFormPresentationXMLObject : selection) {
            PresentationComponent p = this.getPresentationComponent(xFormPresentationXMLObject);
            if (p == null) continue;
            this.lastSelectedComponents.add(p);
        }
        this.refreshProperties(table);
    }

    public void refreshProperties(PropertyTable table) {
        if (this.lastSelectedComponents != null) {
            table.clearAll();
            if (this.lastSelectedComponents.size() == 1) {
                PresentationComponent p = this.lastSelectedComponents.get(0);
                p.showProperties(table, this.componentInteractionProvider, this.changeListener);
            } else {
                ArrayList<ComponentProperties> list = new ArrayList<ComponentProperties>();
                for (PresentationComponent lastSelectedComponent : this.lastSelectedComponents) {
                    ComponentProperties cProperties = lastSelectedComponent.getProperties(this.componentInteractionProvider, this.changeListener);
                    list.add(cProperties);
                }
                PropertyMerger.showProperties(table, list, this.componentInteractionProvider);
            }
        }
        table.build();
        table.repaint();
    }

    public void removeLastSelectedComponent(PresentationComponent theComponent) {
        if (this.lastSelectedComponents != null && this.lastSelectedComponents.contains((Object)theComponent)) {
            this.lastSelectedComponents.remove((Object)theComponent);
        }
    }

    public void requestFocusOn(XFormXMLObject object, boolean innerCompo) {
        PresentationComponent presentationComponent = this.getPresentationComponent(object);
        if (presentationComponent != null) {
            if (innerCompo) {
                UiComponent uiComponent = presentationComponent.getComponent();
                if (uiComponent != null) {
                    uiComponent.requestFocus();
                }
            } else {
                presentationComponent.requestFocus();
            }
        }
    }

    public boolean showImages() {
        return this.showImgs;
    }

    public boolean showLines() {
        return this.showLines;
    }

    public EventListener getListener() {
        return this.theListener;
    }

    public boolean isEditable() {
        return this.dataPanel.isEditable();
    }

    public PresentationDataPanel getDataPanel() {
        return this.dataPanel;
    }

    public XFormPresentation getPresentation() {
        return this.model.getPresentation();
    }

    protected void setListener(EventListener e) {
        this.theListener = e;
    }

    private void processChange(XFormXMLObject changedObject, String propertyName) {
        DataModelTreeNode changeNode = null;
        if (this.nodeProvider != null) {
            changeNode = (DataModelTreeNode)this.nodeProvider.getNode(changedObject);
        }
        if (changedObject instanceof XFormValue) {
            if (changeNode != null) {
                this.reloadParent(changeNode);
            } else {
                this.reloadParent(changedObject);
            }
        } else if (changedObject instanceof XFormBackground) {
            if (changeNode != null) {
                this.reloadParent(changeNode);
            } else {
                this.doReInit();
            }
        } else if ("vexpand".equals(propertyName) || "hexpand".equals(propertyName)) {
            if (changeNode != null) {
                if ("vexpand".equals(propertyName)) {
                    changeNode = (DataModelTreeNode)changeNode.getParent();
                }
                this.reloadParent(changeNode);
            }
        } else if (!this.reloadComponent(changedObject)) {
            this.doReInit();
        }
    }

    private void reloadParent(DataModelTreeNode changeNode) {
        if (changeNode != null) {
            DataModelTreeNode nodeParent = (DataModelTreeNode)changeNode.getParent();
            this.reloadNode(nodeParent);
        }
    }

    private void reloadParent(XFormXMLObject changedObject) {
        DataModelTreeNode nodeParent;
        if (changedObject != null && (nodeParent = (DataModelTreeNode)this.nodeProvider.getNode(changedObject.getParent())) != null) {
            this.reloadNode(nodeParent);
        }
    }

    private void reloadNode(DataModelTreeNode node) {
        if (node != null) {
            XFormPresentationXMLObject changedObject = node.getContent();
            this.reloadComponent(changedObject);
        }
    }

    private boolean reloadComponent(XFormXMLObject changedObject) {
        boolean result = false;
        PresentationComponent changedComponent = this.getPresentationComponent(changedObject);
        if (changedComponent != null && !changedComponent.isDisposed()) {
            this.reload(changedComponent, changedObject);
            result = true;
        }
        this.revalidateAll();
        return result;
    }

    private void revalidateAll() {
        this.validateChildren(this.getChildren());
        this.validateParent((UiContainer)this);
    }

    private void validateChildren(List<UiComponent> children) {
        for (UiComponent c : children) {
            if (!(c instanceof UiContainer)) continue;
            UiContainer container = (UiContainer)c;
            this.validateChildren(container.getChildren());
            container.revalidate();
        }
    }

    private void validateParent(UiContainer container) {
        if (container != null) {
            container.revalidate();
            if (container instanceof ScrollPane) {
                return;
            }
            this.validateParent(container.getParent());
        }
    }

    private void doInvalidate(Panel p) {
        p.invalidate();
        p.removeAll();
    }

    private void doValidate(Panel p) {
        p.revalidate();
    }

    private void doReInit() {
        this.doInvalidate(this);
        this.init(true);
        this.doValidate(this);
    }

    private void getSelectedChangedComponents(PresentationComponent changedComponent, final List<XFormPresentationXMLObject> selectedInsideChanges) {
        final XFormPresentationXMLObject changedObject = changedComponent.getReferencedObject();
        ApplyMethod method = new ApplyMethod(){

            @Override
            public void apply(PresentationComponent eachChild) {
                if (PresentationPanel.this.lastSelectedComponents.contains((Object)eachChild)) {
                    XFormPresentationXMLObject referencedObject = eachChild.getReferencedObject();
                    if (changedObject.contains(referencedObject)) {
                        selectedInsideChanges.add(referencedObject);
                    }
                    PresentationPanel.this.lastSelectedComponents.remove((Object)eachChild);
                }
                PresentationPanel.this.getSelectedChangedComponents(eachChild, selectedInsideChanges);
            }
        };
        this.applyToChildsChilds(changedComponent, method);
    }

    private void applyToChildsChilds(PresentationComponent pComponent, ApplyMethod method) {
        List componentChildren = pComponent.getComponents();
        for (UiComponent eachChild : componentChildren) {
            if (!(eachChild instanceof PresentationComponent)) continue;
            PresentationComponent childComponent = (PresentationComponent)eachChild;
            method.apply(childComponent);
        }
    }

    private void fixSelection(PresentationComponent pComponent, final List selectedObjects, final List<PresentationComponent> newSelectedPComponents) {
        XFormPresentationXMLObject referencedObject = pComponent.getReferencedObject();
        if (selectedObjects.contains(referencedObject)) {
            pComponent.setSelectedBorder(true);
            newSelectedPComponents.add(pComponent);
        }
        ApplyMethod methodToApply = new ApplyMethod(){

            @Override
            public void apply(PresentationComponent eachChild) {
                PresentationPanel.this.fixSelection(eachChild, selectedObjects, newSelectedPComponents);
            }
        };
        this.applyToChildsChilds(pComponent, methodToApply);
    }

    private void init(boolean add) {
        this.invalidate();
        XFormPresentation presentation = this.model.presentation_d;
        SimpleComponentEditors.PresentationComponentEditor presentationEditor = (SimpleComponentEditors.PresentationComponentEditor)this.editorRegistry.getEditorFor(17);
        if (add) {
            this.presentationPanel = presentationEditor.presentationInit(this, presentation, this.getEditorData());
        } else {
            this.presentationPanel = (RealPresentation)this.getPresentationComponent(presentation);
            presentationEditor.init(this, presentation, this.presentationPanel, this.getEditorData());
        }
        this.doValidate(this);
    }

    private void invoke(Command command) {
        CommandManager.invokeCommand(command);
        if (this.changeListener != null) {
            this.changeListener.changeOccured(ChangeListener.EventFactory.createChange(command));
        }
    }

    private void reload(PresentationComponent changedComponent, XFormXMLObject theObject) {
        XFormPresentationXMLObject presentationObject;
        ComponentEditor editor;
        changedComponent.invalidate();
        ArrayList<XFormPresentationXMLObject> selectedInsideChanges = new ArrayList<XFormPresentationXMLObject>();
        if (this.lastSelectedComponents != null && this.lastSelectedComponents.size() > 0) {
            this.getSelectedChangedComponents(changedComponent, selectedInsideChanges);
        }
        if (!(theObject instanceof XFormPresentation)) {
            changedComponent.removeAll();
        }
        changedComponent.reload(theObject);
        if (theObject instanceof XFormPresentation) {
            this.doReInit();
            changedComponent = this.presentationPanel;
        } else if (theObject instanceof XFormRow) {
            ComponentEditor editor2;
            PresentationRow changedRow = (PresentationRow)changedComponent;
            PresentationComponent containerTable = changedRow.getContainerTable();
            XFormPresentationXMLObject reference = containerTable.getReferencedObject();
            int componentId = reference.getComponentID();
            if (XFormPresentationXMLObject.isLayoutContainer(componentId) && (editor2 = this.editorRegistry.getEditorFor(componentId)) != null) {
                this.doInvalidate(containerTable);
                Panel tableParent = containerTable.getContainer();
                changedComponent = (PresentationComponent)editor2.init(tableParent, reference, containerTable, this.getEditorData());
            }
        } else if (theObject instanceof XFormPresentationXMLObject && (editor = this.editorRegistry.getEditorFor((presentationObject = (XFormPresentationXMLObject)theObject).getComponentID())) != null) {
            editor.init(changedComponent.getContainer(), presentationObject, changedComponent, this.getEditorData());
        }
        if (selectedInsideChanges.size() > 0) {
            assert (this.lastSelectedComponents != null);
            ArrayList<PresentationComponent> newSelectedPComponents = new ArrayList<PresentationComponent>();
            this.fixSelection(changedComponent, selectedInsideChanges, newSelectedPComponents);
            this.lastSelectedComponents.addAll(newSelectedPComponents);
        }
        changedComponent.validate();
    }

    private EditorData getEditorData() {
        if (this.editorData == null) {
            this.editorData = new EditorData(this);
        }
        return this.editorData;
    }

    private static abstract class ApplyMethod {
        private ApplyMethod() {
        }

        public abstract void apply(PresentationComponent var1);
    }
}

