/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import oracle.bpm.designer.ErrorList;
import oracle.bpm.designer.formdesigner.AbstractPresentationEditor;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.PresentationDataPanel;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.actions.ListenerHelper;
import oracle.bpm.designer.formdesigner.actions.PresentationCheck;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.toolbar.FormatToolbarManager;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.ProjectObjectAdapter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.xml.XFormXMLObject;
import org.jetbrains.annotations.NotNull;

public class PresentationDesignerPanel
extends AbstractPresentationEditor {
    private Panel containerPanel;
    private PresentationDataPanel dataPanel;
    private FormatToolbarManager formatToolbarManager;

    public PresentationDesignerPanel(UiContainer parent, XFormPresentationModel presentation) {
        super(parent, presentation);
    }

    public void refreshPresentation() {
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        this.getDataPanel().refreshPresentation(preferences.isPresentationShowGrid(), preferences.isPresentationShowImage());
    }

    public void reloadPresentation(XFormPresentationModel model) {
        this.setModel(model);
        this.containerPanel.invalidate();
        if (this.getDataPanel() != null) {
            this.containerPanel.remove((UiComponent)this.getDataPanel());
        }
        this.setDataPanel(this.initDataPanel(this.containerPanel));
        this.containerPanel.validate();
        this.addComponentListeners();
        this.refreshPresentation();
        this.refreshProperties();
        this.setDirty(false);
        this.select(this.getModel().getPresentation());
    }

    public PresentationStructureView getView() {
        return null;
    }

    @Override
    public void requestFocusOn(XFormXMLObject object, boolean innerCompo) {
        this.dataPanel.getPresentationPanel().requestFocusOn(object, innerCompo);
    }

    @Override
    public UiComponent getDefaultComponent() {
        return this.getDataPanel().getPresentationPanel().getRealPresentation();
    }

    @Override
    public UiComponent getFirstComponent() {
        return this.containerPanel;
    }

    @Override
    public String getPanelId() {
        String result = null;
        if (this.getObjectTypeDescription() != null) {
            result = this.getObjectTypeDescription().getText() + "." + this.getModel().getPresentationName();
        }
        return result;
    }

    @Override
    public String getTabName() {
        String name = this.getObjectTypeDescription().getText() + "." + "Presentation";
        return name;
    }

    public boolean checkPresentation(ErrorList errorList) {
        return PresentationCheck.doCheck(false, errorList, this.getProject(), this.getModel());
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public void refreshProperties() {
        this.getDataPanel().refreshProperties();
    }

    public void select(String objectId) {
        this.getView().select(objectId);
    }

    public void stateChanged(ChangeEvent e) {
        this.getDataPanel().recalculateMethods();
        this.setDirty();
    }

    public BorderProperties showBorder(BorderProperties initialBorder) {
        return this.getDataPanel().showBorder(initialBorder);
    }

    public Color showColor(Color initialColor) {
        return this.getDataPanel().showColor(initialColor);
    }

    public PresentationPanel getPresentationPanel() {
        return this.getDataPanel().getPresentationPanel();
    }

    public void selectCurrent() {
        this.select(this.getModel().getPresentation());
    }

    @Override
    public boolean doIgnoringEvents(Command command) {
        return command.doIt();
    }

    @Override
    public boolean undoIgnoringEvents(Command command) {
        return command.undoIt();
    }

    @Override
    protected void applyChanges(ChangeListener.ChangeEvent change) {
        if (!this.getPresentationPanel().isDisposed()) {
            this.getPresentationPanel().doProcessChange(change);
            this.getPresentationPanel().refreshProperties();
        }
    }

    @Override
    protected UiComponent buildNorthUi(UiContainer parent) {
        return this.createToolbar(parent);
    }

    @Override
    protected UiComponent buildWestUi(UiContainer parent) {
        UiComponent component = this.createComponentToolbar(parent);
        this.refreshPresentation();
        this.addComponentListeners();
        this.revalidate();
        return component;
    }

    @Override
    protected Panel createContainerPanel(UiContainer parent) {
        this.containerPanel = new Panel(parent);
        this.containerPanel.setLayout((Layout)new BorderLayout());
        this.setDataPanel(this.initDataPanel(this.containerPanel));
        return this.containerPanel;
    }

    private CatalogObject getCatalogObject(XFormPresentationModel presentation) {
        assert (presentation != null) : "Presentation model cannot be null.";
        ObjectTypeDescription owner = presentation.getOwner();
        assert (owner != null) : "Presentation " + presentation.getName() + " has no owner.";
        FuegoProject project = FuegoProject.getFrom((TypeRef)owner);
        assert (project != null) : "ObjectTypeDescription " + owner + " does not belong to any project.";
        TypeRef ref = owner.getRef();
        assert (ref != null) : "ObjectTypeDescription " + owner + " has no TypeRef associated.";
        return CatalogObjectImpl.create((Project)project, (TypeRef)ref);
    }

    private void select(XFormXMLObject object) {
        this.getDataPanel().select(object);
    }

    private UiComponent createComponentToolbar(UiContainer parent) {
        ToolBar gtoolbar = new ToolBar(parent, ToolBar.VERTICAL);
        this.getActions().addTo(gtoolbar);
        return gtoolbar;
    }

    private PresentationDataPanel initDataPanel(Panel containerPanel) {
        ToolbarListener toolbarListener = new ToolbarListener(){

            @Override
            public void setAvailable(int actions, ToolbarListener.ToolbarInteractions t) {
                PresentationDesignerPanel.this.getActions().setAvailable(actions, t, PresentationDesignerPanel.this.isReadOnly());
                PresentationDesignerPanel.this.formatToolbarManager.setAvaliable(actions, t);
            }
        };
        PresentationDataPanel dataPanel = new PresentationDataPanel(this.getModel(), (UiContainer)containerPanel, this.getEditorRegistry(), this, this.getHelper());
        this.setSelectionProvider(dataPanel.getSelectionProvider());
        PresentationStructureView viewCreator = dataPanel.getPresentationViewCreator();
        dataPanel.setFormDesignerActions(this.getFormDesignerActions(viewCreator, this));
        dataPanel.addToolbarListener(toolbarListener);
        containerPanel.add((UiComponent)dataPanel, (Object)"Center");
        return dataPanel;
    }

    private ToolBar createToolbar(UiContainer parent) {
        ToolBar toolBar = new ToolBar(parent);
        toolBar.add((BaseAction)this.getActions().getClipBorardActionManager().getClearAction());
        toolBar.add((BaseAction)this.getActions().getHtmlPreviewAction());
        toolBar.add((BaseAction)this.getActions().getI18NAction(this.dataPanel.getPresentationPanel().getComponentInteractionProvider()));
        this.formatToolbarManager = new FormatToolbarManager(this);
        this.formatToolbarManager.initFormatToolbar(toolBar);
        return toolBar;
    }

    private void addComponentListeners() {
        if (this.isSwing()) {
            ListenerHelper.addSelectionKeyStrokes(this);
        }
    }

    private void setDataPanel(PresentationDataPanel dataPanel) {
        this.dataPanel = dataPanel;
    }

    private PresentationDataPanel getDataPanel() {
        return this.dataPanel;
    }

    private static class PresentationProjectObject
    extends ProjectObjectAdapter<XFormPresentationModel> {
        public PresentationProjectObject(XFormPresentationModel presentation) {
            super((Project)FuegoProject.getFrom((TypeRef)presentation.getOwner()), (Object)presentation);
        }

        @NotNull
        public ProjectObjectType getProjectObjectType() {
            return ProjectObjectType.BPM_OBJECT_PRESENTATION;
        }
    }
}

