/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListModel;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StructureTree;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.designer.formdesigner.AbstractPresentationEditor;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.PresentationSelectionProvider;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.actions.FormDesignerAction;
import oracle.bpm.designer.formdesigner.actions.HtmlPreviewAction;
import oracle.bpm.designer.formdesigner.command.AddDataCommand;
import oracle.bpm.designer.formdesigner.command.ClearDataCommand;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.components.FusionChartsWidget;
import oracle.bpm.designer.formdesigner.model.TranslatableProperty;
import oracle.bpm.designer.formdesigner.outline.DeleteComponentAction;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.designer.formdesigner.web.PresentationEditor;
import oracle.bpm.designer.formdesigner.web.PresentationManager;
import oracle.bpm.designer.formdesigner.web.TransportManager;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.utils.ExecUtils;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.resources.BoolMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Browser;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Link;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.SystemInfo;
import oracle.bpm.web.formdesigner.FlashPreferences;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.lib.chart.FusionChartsCreator;
import oracle.bpm.xobject.presentationmodel.XFormComponentType;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class PresentationDesignerBrowser
extends AbstractPresentationEditor
implements PresentationEditor {
    private Browser browser;
    private XFormPresentationXMLObject copiedObject;
    private BaseAction copyAction;
    private BaseAction cutAction;
    private DeleteComponentAction deleteAction;
    private ErrorPanel errorPanel;
    private HtmlPreviewAction htmlPreviewAction;
    private boolean isCopy;
    private boolean isShowingPreview = false;
    private NavigationPanel navigationPanel;
    private Selection nextFocuseable;
    private BaseAction pasteAction;
    private PresentationManager presentationManager;
    private PresentationStructureView presentationViewCreator;
    private PreviewInEditorAction previewInEditorAction;
    private Runnable redoRunnable;
    private ReloadPresentation reloadAction;
    private Runnable undoRunnable;

    public PresentationDesignerBrowser(UiContainer parent, XFormPresentationModel presentation) {
        super(parent, presentation);
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        ObjectPropertyListener listener = new ObjectPropertyListener(){

            @Override
            public void propertyChanged(Object object, String propertyName) {
                PresentationDesignerBrowser.this.presentationManager.refreshEditor();
            }
        };
        preferences.addPropertyObserver("presentationEditorOptions", listener);
        this.addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                ArrayList completeSelection = PresentationDesignerBrowser.this.selectionToXFormList(newSelection);
                if (PresentationDesignerBrowser.this.presentationViewCreator != null) {
                    PresentationDesignerBrowser.this.presentationViewCreator.doSelect(completeSelection);
                }
                if (PresentationDesignerBrowser.this.navigationPanel != null) {
                    PresentationDesignerBrowser.this.navigationPanel.setSelection(completeSelection);
                }
            }
        });
    }

    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public boolean doUpdate() {
        super.editorToObject();
        return true;
    }

    @Override
    public PresentationStructureView getView() {
        if (this.presentationViewCreator == null) {
            this.presentationViewCreator = new PresentationStructureView(this, this, this.getHelper());
            this.presentationViewCreator.setSelectionBuilder(this.presentationManager.getSelectionBuilder());
            this.getFormDesignerActions(this.presentationViewCreator, this);
            this.presentationViewCreator.doSelect(this.selectionToXFormList(this.getSelection()));
        }
        return this.presentationViewCreator;
    }

    @Override
    public void setNextFocusable(Selection nextFocuseable) {
        this.nextFocuseable = nextFocuseable;
    }

    @Override
    public Selection getFocuseable() {
        Selection result;
        if (this.nextFocuseable != null) {
            result = this.nextFocuseable;
            if (result != this.getSelection()) {
                this.setSelection(result);
            }
            this.nextFocuseable = null;
        } else {
            result = this.getSelection();
        }
        return result;
    }

    public PresentationStructureView getView(StructureTree tree) {
        PresentationStructureView result = this.getView();
        if (tree != null) {
            result.setTree(tree);
        }
        return result;
    }

    @Override
    public void requestFocusOn(XFormXMLObject object, boolean innerCompo) {
    }

    @Override
    public BaseAction getDeleteAction() {
        this.ensureBuildActions();
        return this.deleteAction;
    }

    @Override
    public BaseAction getCutAction() {
        this.ensureBuildActions();
        return this.cutAction;
    }

    @Override
    public BaseAction getCopyAction() {
        this.ensureBuildActions();
        return this.copyAction;
    }

    @Override
    public BaseAction getPasteAction() {
        this.ensureBuildActions();
        return this.pasteAction;
    }

    public void setHistoyHandlers(Runnable undoRunnable, Runnable redoRunnable) {
        this.undoRunnable = undoRunnable;
        this.redoRunnable = redoRunnable;
    }

    @Override
    public void fireUndo() {
        this.undoRunnable.run();
    }

    @Override
    public void fireRedo() {
        this.redoRunnable.run();
    }

    @Override
    public void addError(String stringValue) {
        if (this.errorPanel != null) {
            this.errorPanel.addError(stringValue);
        }
        Log.logDebug(stringValue);
    }

    @Override
    public void addWarning(String stringValue) {
        if (this.errorPanel != null) {
            this.errorPanel.addWarning(stringValue);
        }
        Log.logDebug(stringValue);
    }

    @Override
    public boolean doIgnoringEvents(Command command) {
        return this.presentationManager.doIgnoringEvents(command);
    }

    @Override
    public boolean undoIgnoringEvents(Command command) {
        return this.presentationManager.undoIgnoringEvents(command);
    }

    public void enableToolbarActions(boolean enable) {
        this.reloadAction.setEnabled(enable);
        this.previewInEditorAction.setEnabled(enable);
        this.htmlPreviewAction.setEnabled(enable);
    }

    @Override
    protected void applyChanges(ChangeListener.ChangeEvent change) {
    }

    @Override
    protected Panel createContainerPanel(UiContainer parent) {
        Panel containerPanel = new Panel(parent);
        containerPanel.setLayout((Layout)new BorderLayout());
        this.initBrowser((UiContainer)containerPanel);
        containerPanel.add((UiComponent)this.browser, (Object)"Center");
        if (Ui.isDebug()) {
            this.errorPanel = new ErrorPanel((UiContainer)containerPanel);
            containerPanel.add((UiComponent)this.errorPanel, (Object)"South");
        }
        this.navigationPanel = new NavigationPanel((UiContainer)containerPanel);
        containerPanel.add((UiComponent)this.navigationPanel, (Object)"North");
        this.navigationPanel.setSelection(this.selectionToXFormList(this.getSelection()));
        ToolBar customToolbar = this.navigationPanel.getCustomActionsToolbar();
        FormDesignerAction i18NAction = new FormDesignerAction(DesignerMsg.FUEGOOBJECT_RESOURCES){

            @Override
            public void runAction(ActionEvent e) {
                Map<String, XObjectTypeDescription.ResourceValue> allResources = ((XObjectTypeDescription)PresentationDesignerBrowser.this.getObjectTypeDescription()).getResources();
                TranslatableProperty.editResources(DesignerMsg.FUEGOOBJECT_RESOURCES, allResources);
            }
        };
        customToolbar.add((BaseAction)i18NAction);
        this.htmlPreviewAction = new HtmlPreviewAction(this);
        customToolbar.add((BaseAction)this.htmlPreviewAction);
        this.previewInEditorAction = new PreviewInEditorAction();
        customToolbar.addToggleButton((BaseAction)this.previewInEditorAction);
        this.reloadAction = new ReloadPresentation();
        customToolbar.add((BaseAction)this.reloadAction);
        return containerPanel;
    }

    @Override
    protected void objectToEditor() {
        this.reloadPresentation();
    }

    private ArrayList<XFormPresentationXMLObject> selectionToXFormList(Selection newSelection) {
        List selection = newSelection.asList(XFormSelection.class);
        ArrayList<XFormPresentationXMLObject> completeSelection = new ArrayList<XFormPresentationXMLObject>();
        for (XFormSelection xFormSelection : selection) {
            completeSelection.add(xFormSelection.getSelection());
        }
        return completeSelection;
    }

    private void reloadPresentation() {
        if (this.isShowingPreview) {
            this.presentationManager.previewPresentation();
        } else {
            this.presentationManager.loadPresentation();
        }
    }

    private void initBrowser(UiContainer parent) {
        this.browser = null;
        this.initPresentationManager();
    }

    private void initPresentationManager() {
        String presentationId = this.getModel().getPresentation().getId();
        TransportManager manager = new TransportManager(this.browser, presentationId);
        this.presentationManager = new PresentationManager(this, this.getEditorRegistry(), manager);
        Selection initialSelection = this.presentationManager.getSelectionBuilder().buildSelection(presentationId);
        this.setSelectionProvider(new PresentationSelectionProvider(initialSelection));
    }

    private void ensureBuildActions() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteComponentAction(this.presentationViewCreator);
            this.cutAction = new CutAction();
            this.copyAction = new CopyAction();
            this.pasteAction = new PasteAction();
            this.addSelectionListener(new SelectionListener(){

                public void selectionChanged(Selection newSelection) {
                    PresentationDesignerBrowser.this.deleteAction.setSelection(newSelection);
                    PresentationDesignerBrowser.this.cutAction.setSelection(newSelection);
                    PresentationDesignerBrowser.this.copyAction.setSelection(newSelection);
                    PresentationDesignerBrowser.this.pasteAction.setSelection(newSelection);
                }
            });
        }
    }

    private void toggleShowingPreview() {
        this.isShowingPreview = !this.isShowingPreview;
        this.presentationManager.setListeningToFocus(!this.presentationManager.isListeningToFocus());
    }

    static {
        FusionChartsCreator.registerEditorFactory((String)FusionChartsWidget.getRelativePath());
    }

    private class ReloadPresentation
    extends BaseAction {
        public ReloadPresentation() {
            super(WebformdesignerMsg.RELOAD_PRESENTATION);
            this.requires(Void.class);
        }

        public void run() {
            PresentationDesignerBrowser.this.enableToolbarActions(false);
            PresentationDesignerBrowser.this.browser.refresh();
            PresentationDesignerBrowser.this.presentationManager.initializeEditor();
            PresentationDesignerBrowser.this.reloadPresentation();
        }
    }

    private class PreviewInEditorAction
    extends BaseAction {
        public PreviewInEditorAction() {
            super(WebformdesignerMsg.PREVIEW_IN_EDITOR);
            this.requires(Void.class);
        }

        public void run() {
            PresentationDesignerBrowser.this.enableToolbarActions(false);
            PresentationDesignerBrowser.this.toggleShowingPreview();
            PresentationDesignerBrowser.this.reloadPresentation();
        }
    }

    private class PasteAction
    extends FormDesignerAction {
        public PasteAction() {
            super(DesignerMsg.PASTE);
            this.requires(Void.class);
        }

        @Override
        public void runAction(ActionEvent e) {
            if (PresentationDesignerBrowser.this.copiedObject != null) {
                XFormPresentationXMLObject newObject = PresentationDesignerBrowser.this.copiedObject.clone();
                XFormPresentationXMLObject[] selection = PresentationDesignerBrowser.this.getView().getSelectedItems();
                if (selection.length == 1) {
                    AddDataCommand command = AddDataCommand.getPasteCommand(selection[0], newObject, PresentationDesignerBrowser.this.isCopy, PresentationDesignerBrowser.this.presentationViewCreator);
                    PresentationDesignerBrowser.this.getView().invoke(command);
                }
            }
        }

        protected void updateEnableStatus(Selection s) {
            super.updateEnableStatus(s);
            boolean enable = s.isSingle();
            if (enable) {
                XFormPresentationXMLObject selection = (XFormPresentationXMLObject)s.as(XFormPresentationXMLObject.class);
                if (selection == null) {
                    XFormSelection xformSelection = (XFormSelection)s.as(XFormSelection.class);
                    selection = xformSelection.getSelection();
                }
                enable = Utilities.canAdd(selection, PresentationDesignerBrowser.this.copiedObject);
            }
            if (!enable) {
                super.setEnabled(enable);
            }
        }
    }

    private class NavigatorAction
    extends BaseAction {
        private String id;

        private NavigatorAction() {
        }

        public void setId(String id) {
            this.setEnabled(id != null);
            String actionName = id == null ? "" : id;
            this.setName(actionName);
            this.setMsg(UIMsg.TO_MSG((String)actionName));
            this.id = id;
        }

        public void actionPerformed(ActionEvent e) {
            Selection selection = PresentationDesignerBrowser.this.presentationManager.getSelectionBuilder().buildSelection(this.id);
            PresentationDesignerBrowser.this.setSelection(selection);
        }
    }

    private class Navigator
    extends ToolBar {
        private static final int ITEM_COUNT = 6;

        public Navigator(UiContainer parent) {
            super(parent);
            this.setLayout((Layout)new FlowLayout(0));
        }

        public void setSelection(ArrayList<XFormPresentationXMLObject> completeSelection) {
            if (completeSelection.size() == 1) {
                this.buildActions(completeSelection.get(0));
            } else {
                this.fillActions(new ArrayList<String>());
            }
            this.getParent().revalidate();
        }

        private void buildActions(XFormPresentationXMLObject element) {
            ArrayList<String> actionIds = new ArrayList<String>();
            for (int i = 0; i < 6 && element != null; ++i) {
                actionIds.add(0, element.getId());
                XFormXMLObject parent = element.getParent();
                if (parent instanceof XFormPresentationXMLObject) {
                    element = (XFormPresentationXMLObject)parent;
                    if (element.getComponentType() != XFormComponentType.ROW) continue;
                    element = (XFormPresentationXMLObject)element.getParent();
                    continue;
                }
                element = null;
            }
            this.fillActions(actionIds);
        }

        private void fillActions(ArrayList<String> actionIds) {
            this.removeAll();
            for (int i = 0; i < actionIds.size(); ++i) {
                NavigatorAction action = new NavigatorAction();
                action.setId(actionIds.get(i));
                Link link = new Link((UiContainer)this, (BaseAction)action);
                this.add((UiComponent)link);
                if (i < actionIds.size() - 1) {
                    this.add((UiComponent)Label.create((UiContainer)this, (Msg)Msg.QUOTE(">")));
                    continue;
                }
                link.setEnabled(false);
            }
            this.revalidate();
        }
    }

    private class NavigationPanel
    extends Panel {
        private ToolBar actionsContainer;
        private Navigator navigationPanel;

        public NavigationPanel(UiContainer parent) {
            super(parent);
            this.build();
        }

        public ToolBar getCustomActionsToolbar() {
            return this.actionsContainer;
        }

        public void setSelection(ArrayList<XFormPresentationXMLObject> completeSelection) {
            this.navigationPanel.setSelection(completeSelection);
        }

        private void build() {
            String cols = "min, min:grow,right:pref";
            String rows = "pref";
            FormLayout layout = new FormLayout(cols, rows);
            this.setLayout((Layout)layout);
            CellConstraints cc = layout.createCellConstraints();
            this.navigationPanel = new Navigator((UiContainer)this);
            this.add((UiComponent)this.navigationPanel, cc.xy(1, 1));
            this.actionsContainer = new ToolBar((UiContainer)this);
            this.add((UiComponent)this.actionsContainer, cc.xy(3, 1));
        }
    }

    private class CutAction
    extends CopyAction {
        public CutAction() {
            super(DesignerMsg.CUT);
        }

        @Override
        public void runAction(ActionEvent e) {
            super.runAction(e);
            PresentationDesignerBrowser.this.isCopy = false;
        }

        @Override
        protected XFormPresentationXMLObject doCopy(PresentationStructureView view, XFormPresentationXMLObject selection) {
            XFormPresentationXMLObject result = super.doCopy(view, selection);
            view.invoke(new ClearDataCommand(view, selection));
            return result;
        }
    }

    private class CopyAction
    extends FormDesignerAction {
        public CopyAction() {
            this(DesignerMsg.COPY);
        }

        public CopyAction(Msg msg) {
            super(msg);
            this.requires(Void.class);
        }

        @Override
        public void runAction(ActionEvent e) {
            XFormPresentationXMLObject[] selection = PresentationDesignerBrowser.this.getView().getSelectedItems();
            if (selection.length == 1) {
                PresentationDesignerBrowser.this.copiedObject = this.doCopy(PresentationDesignerBrowser.this.getView(), selection[0]);
                PresentationDesignerBrowser.this.isCopy = true;
            }
        }

        protected XFormPresentationXMLObject doCopy(PresentationStructureView view, XFormPresentationXMLObject selection) {
            return selection;
        }

        protected void updateEnableStatus(Selection s) {
            super.updateEnableStatus(s);
            boolean enable = s.isSingle();
            if (enable) {
                XFormPresentationXMLObject selection = (XFormPresentationXMLObject)s.as(XFormPresentationXMLObject.class);
                if (selection == null) {
                    XFormSelection xformSelection = (XFormSelection)s.as(XFormSelection.class);
                    selection = xformSelection.getSelection();
                }
                enable = Utilities.canCopy(selection);
            }
            if (!enable) {
                super.setEnabled(enable);
            }
        }
    }

    private static class ErrorPanel
    extends Panel {
        private BaseAction action;
        private ToolBar actionsContainer;
        private MutableListListModel errorModel;
        private boolean hasErrors = false;
        private boolean hasWarnings = false;

        public ErrorPanel(UiContainer parent) {
            super(parent);
            this.build();
        }

        public ToolBar getCustomActionsToolbar() {
            return this.actionsContainer;
        }

        public void addError(final String stringValue) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ErrorPanel.this.errorModel.addElement((Object)new ErrorInstance(true, stringValue));
                    ErrorPanel.this.hasErrors = true;
                    ErrorPanel.this.updateMsg();
                }
            });
        }

        public void addWarning(final String stringValue) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ErrorPanel.this.errorModel.addElement((Object)new ErrorInstance(false, stringValue));
                    ErrorPanel.this.hasWarnings = true;
                    ErrorPanel.this.updateMsg();
                }
            });
        }

        private void build() {
            this.setLayout((Layout)new BorderLayout());
            final Panel errorList = new Panel((UiContainer)this);
            errorList.makeRecyclable();
            errorList.setVisible(false);
            this.add((UiComponent)errorList, "Center");
            errorList.setLayout((Layout)new BorderLayout());
            this.errorModel = new MutableListListModel(new ArrayList());
            oracle.bpm.ui.List errors = new oracle.bpm.ui.List((UiContainer)errorList, (ListModel)this.errorModel);
            errors.setLabelProvider(new LabelProvider(){

                public Image getIcon(Object element) {
                    ErrorInstance error = (ErrorInstance)element;
                    Msg msg = error.isError ? WebformdesignerMsg.ERROR : WebformdesignerMsg.WARNING;
                    return Image.create((Msg)msg);
                }

                public String getText(Object element) {
                    ErrorInstance error = (ErrorInstance)element;
                    return error.code;
                }
            });
            errorList.add((UiComponent)errors, (Object)"Center");
            Panel toolbarContainer = new Panel((UiContainer)this);
            toolbarContainer.setLayout((Layout)new BorderLayout());
            ToolBar errorToolbar = new ToolBar((UiContainer)toolbarContainer);
            toolbarContainer.add((UiComponent)errorToolbar, (Object)"East");
            this.add((UiComponent)toolbarContainer, "North");
            this.action = new BaseAction(DesignerMsg.EMPTY_MSG("")){

                public void run() {
                    errorList.setVisible(!errorList.isVisible());
                    errorList.revalidate();
                    ErrorPanel.this.revalidate();
                    ErrorPanel.this.getParent().revalidate();
                }
            };
            errorToolbar.add(this.action);
            this.action.setEnabled(false);
            this.actionsContainer = new ToolBar((UiContainer)toolbarContainer);
            toolbarContainer.add((UiComponent)this.actionsContainer, (Object)"West");
        }

        private void updateMsg() {
            Msg msg;
            if (this.hasErrors) {
                msg = WebformdesignerMsg.ERROR;
                this.action.setEnabled(true);
            } else if (this.hasWarnings) {
                msg = WebformdesignerMsg.WARNING;
                this.action.setEnabled(true);
            } else {
                msg = DesignerMsg.EMPTY_MSG("");
                this.action.setEnabled(false);
            }
            this.action.setMsg(msg);
        }
    }

    private static class ErrorInstance {
        private String code;
        private boolean isError;

        public ErrorInstance(boolean isError, String code) {
            this.isError = isError;
            this.code = code;
        }
    }

    public static class InstallFlash
    extends BaseAction {
        public InstallFlash() {
            super(WebformdesignerMsg.INSTALL_FLASH);
            this.requires(Void.class);
        }

        public void run() {
            DesignerPreferences preferences = DesignerPreferences.getPreferences();
            if (preferences.getOfferFlashInstallation() && !this.isFlashInstalled()) {
                BoolMsg msg = new BoolMsg(false, CoreMsg.DO_NOT_SHOW_THIS_MESSAGE);
                int value = MessageDialog.showQuestion(null, (Msg)WebformdesignerMsg.INSTALL_FLASH, (Msg)WebformdesignerMsg.FLASH_NOT_INSTALLED, (Msg)WebformdesignerMsg.CLOSE_PRESENTATIONS, (int)6, (BoolMsg)msg);
                preferences.setOfferFlashInstallation(!msg.value);
                if (value == 2) {
                    this.setFlashInstalled();
                    this.closeAllPresentationEditors();
                    this.openInstaller();
                }
            }
        }

        private void setFlashInstalled() {
            FlashPreferences.getInstance().setFlashInstalled(true);
        }

        private boolean isFlashInstalled() {
            return FlashPreferences.getInstance().isFlashInstalled();
        }

        private void closeAllPresentationEditors() {
            StudioEditor[] bpmEditors;
            HashMap editorsMap = new HashMap();
            ArrayList<AbstractPresentationEditor> presentationEditorsToBeClosed = new ArrayList<AbstractPresentationEditor>();
            for (StudioEditor bpmEditor : bpmEditors = AbstractStudioWorkbench.getInstance().getEditorsByClass(BPMObjectEditor.class)) {
                BPMObjectEditor bpmObjectEditor = (BPMObjectEditor)bpmEditor;
                List openedEditors = bpmObjectEditor.getOpenedEditors();
                for (Object o : openedEditors) {
                    if (!(o instanceof AbstractPresentationEditor)) continue;
                    presentationEditorsToBeClosed.add((AbstractPresentationEditor)o);
                }
                editorsMap.put(bpmObjectEditor, presentationEditorsToBeClosed);
            }
            for (BPMObjectEditor bpmObjectEditor : editorsMap.keySet()) {
                List list = (List)editorsMap.get(bpmObjectEditor);
                for (AbstractPresentationEditor abstractPresentationEditor : list) {
                    XFormPresentationModel xFormPresentationModel = abstractPresentationEditor.getModel();
                    bpmObjectEditor.closePresentation(xFormPresentationModel);
                }
            }
        }

        private void openInstaller() {
            String installDir = FuegoDirectories.installationDir().getAbsolutePath() + "/bin/";
            try {
                if (SystemInfo.isWindows()) {
                    System.out.println("exe returned: " + ExecUtils.exec(installDir + "install_flash_player.exe"));
                } else if (SystemInfo.isLinux()) {
                    System.out.println("rpm returned: " + ExecUtils.exec("rpm", "-i", installDir + "flash-plugin-9.0.115.0-release.i386.rpm"));
                } else if (SystemInfo.isAnyMac()) {
                    System.out.println("hdi returned: " + ExecUtils.exec("hdiutil", "attach", installDir + "InstallFlashPlayer9UB.dmg"));
                    System.out.println("open returned: " + ExecUtils.exec("open", "/Volumes/Adobe Flash Player 9/Install Flash Player 9 UB.app/"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

