/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.StructureTree;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.ComponentInteraction;
import oracle.bpm.designer.formdesigner.ComponentInteractionProviderImpl;
import oracle.bpm.designer.formdesigner.EventListener;
import oracle.bpm.designer.formdesigner.FullBorderPropertiesImpl;
import oracle.bpm.designer.formdesigner.PresentationDesignerPanel;
import oracle.bpm.designer.formdesigner.PresentationPanel;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.formdesigner.XFormSelectionBuilder;
import oracle.bpm.designer.formdesigner.actions.FormDesignerActions;
import oracle.bpm.designer.formdesigner.actions.ListenerHelper;
import oracle.bpm.designer.formdesigner.bordereditor.BorderChooser;
import oracle.bpm.designer.formdesigner.components.PresentationComponent;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.outline.NodeProvider;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.ui.ColorChooser;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class PresentationDataPanel
extends Panel {
    private FormDesignerActions actions;
    private FullBorderProperties border = null;
    private DataTreeHelper helper;
    private ChangeListener listener;
    private XFormPresentationModel model;
    private PresentationDesignerPanel presentationDesignerPanel;
    private PresentationPanel presentationPanel;
    private PresentationStructureView presentationViewCreator;
    private XFormSelection.PropertyRefresher refresher;
    private EventListener selectionProvider;
    private ToolbarListener tListener;

    public PresentationDataPanel(XFormPresentationModel model, UiContainer container, EditorRegistry editorRegistry, PresentationDesignerPanel presentationDesignerPanel, DataTreeHelper helper) {
        super(container);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.model = model;
        this.listener = presentationDesignerPanel;
        this.helper = helper;
        this.presentationDesignerPanel = presentationDesignerPanel;
        PresentationDataPanel presentationScrollPane = this;
        this.selectionProvider = ListenerHelper.createEventHandler(this);
        this.selectionProvider.addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                List selection = newSelection.asList(XFormSelection.class);
                ArrayList<XFormPresentationXMLObject> list = new ArrayList<XFormPresentationXMLObject>();
                for (XFormSelection xFormSelection : selection) {
                    if (xFormSelection.getSelection() == null) continue;
                    list.add(xFormSelection.getSelection());
                }
                XFormPresentationXMLObject[] xmlObjects = list.toArray(new XFormPresentationXMLObject[list.size()]);
                ComponentInteraction interaction = new ComponentInteraction(xmlObjects, PresentationDataPanel.this.listener);
                PresentationDataPanel.this.manageToolbars(interaction);
            }
        });
        this.presentationPanel = new PresentationPanel((UiContainer)presentationScrollPane, model, this.selectionProvider, this, editorRegistry, this.listener);
        this.setLayout((Layout)new BorderLayout());
        this.add((UiComponent)this.presentationPanel, "Center");
        this.presentationPanel.setNodeProvider(new NodeProvider(){

            @Override
            public TreeNode getNode(Object o) {
                return PresentationDataPanel.this.getPresentationViewCreator().getNode(o);
            }
        });
        ComponentInteractionProviderImpl componentIneractionProvider = new ComponentInteractionProviderImpl(helper);
        this.presentationPanel.setComponentInteractionProvider(componentIneractionProvider);
        this.getPresentationViewCreator();
    }

    public boolean isChild(PresentationComponent presentationComponent, XFormPresentationXMLObject xFormPresentationXMLObject) {
        return this.getPresentationViewCreator().isChild(presentationComponent.getReferencedObject(), xFormPresentationXMLObject);
    }

    public PresentationStructureView getPresentationViewCreator() {
        return this.getPresentationViewCreator(null);
    }

    public PresentationStructureView getPresentationViewCreator(StructureTree tree) {
        if (this.presentationViewCreator == null) {
            this.presentationViewCreator = new PresentationStructureView(this.presentationDesignerPanel, this.listener, this.helper);
            this.presentationViewCreator.setSelectionBuilder(new XFormSelectionBuilder(this.getPresentationModel(), this.getPropertyRefresher()));
        }
        if (tree != null) {
            this.presentationViewCreator.setTree(tree);
        }
        return this.presentationViewCreator;
    }

    public ObjectTypeDescription getCurrentObject() {
        return this.getPresentationViewCreator().getObjectTypeDescription();
    }

    public boolean isEditable() {
        return true;
    }

    public void setFormDesignerActions(FormDesignerActions actions) {
        this.actions = actions;
    }

    public String getGroupReferenceFor(XFormPresentationXMLObject object) {
        return this.getPresentationViewCreator().getRepeatable(object);
    }

    public String getName() {
        return null;
    }

    public PresentationPanel getPresentationPanel() {
        return this.presentationPanel;
    }

    public void recalculateMethods() {
        this.getPresentationViewCreator().recalculateMethods();
    }

    public void refreshPresentation(boolean showLines, boolean showImgs) {
        PresentationComponent[] selectedComponents = this.presentationPanel.getLastSelectedComponents();
        this.presentationPanel.refresh(showLines, showImgs);
        if (selectedComponents.length != 0) {
            this.clearSelection();
            for (PresentationComponent element : selectedComponents) {
                XFormPresentationXMLObject reference;
                if (element == null || (reference = element.getReferencedObject()) == null) continue;
                PresentationComponent presentationComponent = this.presentationPanel.getPresentationComponent(reference);
                this.doAddSelection(presentationComponent);
            }
        } else {
            this.doAddSelection(this.presentationPanel.getPresentationComponent(this.model));
        }
    }

    public void refreshProperties() {
        this.refreshSelection();
    }

    public void select(XFormXMLObject object) {
        this.getPresentationViewCreator().select(object);
    }

    public void modificationDone() {
        if (this.listener != null) {
            this.listener.changeOccured(ChangeListener.EventFactory.createTopLevelChange());
        }
    }

    public void modificationDone(XFormXMLObject xFormXMLObjectParent) {
        if (this.listener != null) {
            this.listener.changeOccured(ChangeListener.EventFactory.createChange(xFormXMLObjectParent));
        }
    }

    public FormDesignerActions getActions() {
        return this.actions;
    }

    public SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void doAddSelection(PresentationComponent theComponent) {
        if (theComponent != null) {
            this.getPresentationViewCreator().ensureVisibleSelection();
            if (this.presentationPanel.isSelectedComponent(theComponent)) {
                this.presentationPanel.removeLastSelectedComponent(theComponent);
                theComponent.setSelectedBorder(false);
            } else {
                this.presentationPanel.addLastSelectedComponent(theComponent);
                theComponent.setSelectedBorder(true);
            }
            this.refreshProperties();
        }
        this.manageToolbars();
        this.repaint();
    }

    public void refreshSelection() {
        XFormPresentationXMLObject[] selection = this.getPresentationViewCreator().getSelectedItems();
        if (selection.length == 1) {
            XFormSelection xformSelection = new XFormSelection(selection[0], this.getPropertyRefresher());
            this.selectionProvider.fireSelectionChanged(DefaultSelection.createSingle((Object)xformSelection));
        } else {
            ArrayList<XFormSelection> list = new ArrayList<XFormSelection>();
            for (XFormPresentationXMLObject selectedObject : selection) {
                XFormSelection xformSelection = new XFormSelection(selectedObject, this.getPropertyRefresher());
                list.add(xformSelection);
            }
            this.selectionProvider.fireSelectionChanged(DefaultSelection.createMultiple(list));
        }
    }

    public void switchSelection(XFormPresentationXMLObject selectedObject) {
        this.presentationPanel.clearLastSelectedComponents();
        XFormSelection xformSelection = new XFormSelection(selectedObject, this.getPropertyRefresher());
        PresentationComponent theComponent = this.getPresentationPanel().getPresentationComponent(selectedObject);
        this.getPresentationViewCreator().setSelectedComponent(theComponent);
        this.doAddSelection(theComponent);
        this.selectionProvider.fireSelectionChanged(DefaultSelection.createSingle((Object)xformSelection));
    }

    public void switchSelection(PresentationComponent theComponent) {
        this.presentationPanel.clearLastSelectedComponents();
        this.getPresentationViewCreator().setSelectedComponent(theComponent);
        this.doAddSelection(theComponent);
    }

    public XFormPresentationModel getPresentationModel() {
        return this.model;
    }

    public XFormSelection.PropertyRefresher getPropertyRefresher() {
        if (this.refresher == null) {
            this.refresher = new BasicPropertyRefresher();
        }
        return this.refresher;
    }

    protected BorderProperties showBorder(BorderProperties initialBorder) {
        BorderChooser borderChooser = new BorderChooser(UiWindow.getFrom((UiComponent)this), true){

            @Override
            protected void applyEditedBorder() {
                PresentationDataPanel.this.border = this.getEditedBorder();
            }
        };
        this.border = FullBorderPropertiesImpl.createFullBorderFrom(initialBorder);
        borderChooser.enableCustomBorder(initialBorder instanceof FullBorderProperties);
        borderChooser.setBorderToEdit(this.border);
        borderChooser.setVisible(true);
        return this.border;
    }

    protected Color showColor(Color initialColor) {
        return ColorChooser.showDialog((UiComponent)this, (Color)initialColor);
    }

    void addToolbarListener(ToolbarListener c) {
        this.tListener = c;
    }

    private ComponentInteraction createComponentInteraction(PresentationComponent[] compos) {
        XFormPresentationXMLObject[] list = new XFormPresentationXMLObject[compos.length];
        for (int i = 0; i < compos.length; ++i) {
            XFormPresentationXMLObject p;
            list[i] = p = compos[i].getReferencedObject();
        }
        return new ComponentInteraction(list, this.listener);
    }

    private void manageToolbars() {
        PresentationComponent[] compos = this.presentationPanel.getLastSelectedComponents();
        ComponentInteraction t = this.createComponentInteraction(compos);
        this.manageToolbars(t);
    }

    private void manageToolbars(ComponentInteraction t) {
        if (this.tListener == null) {
            return;
        }
        int modifiers = t.getModifiers();
        XFormPresentation presentation = this.model.getPresentation();
        XFormPresentationXMLObject[] compos = t.getComponents();
        if (compos != null && compos.length > 0) {
            if (compos.length > 1) {
                boolean dontAddClear = false;
                for (XFormPresentationXMLObject content : compos) {
                    boolean isTopLevelTable;
                    boolean isPresentation = content instanceof XFormPresentation;
                    boolean bl = isTopLevelTable = content instanceof XFormTable && presentation.table == content;
                    if (!isPresentation && !isTopLevelTable) continue;
                    dontAddClear = true;
                }
                if (!dontAddClear) {
                    modifiers |= 8;
                }
            } else {
                boolean isTopLevelTable;
                XFormPresentationXMLObject content = compos[0];
                modifiers |= 0x1F;
                boolean isPresentation = content instanceof XFormPresentation;
                boolean bl = isTopLevelTable = content instanceof XFormTable && presentation.table == content;
                if (isPresentation || isTopLevelTable) {
                    modifiers &= 0xFFFFFFF7;
                }
                if (!(content instanceof XFormCell) || !((XFormCell)content).hasSpace()) {
                    modifiers &= 0xFFFFFFEF;
                }
                if (content instanceof XFormCell && ((XFormCell)content).hasSpace() && this.getPresentationViewCreator().getArray((XFormCell)content) != null) {
                    System.out.println("PresentationDataPanel.manageToolbars() HAS ARRY!!!");
                    modifiers |= 0x20;
                }
                if (!this.actions.getClipBorardActionManager().canPaste(compos[0])) {
                    modifiers &= 0xFFFFFFFB;
                }
            }
            this.tListener.setAvailable(modifiers, t);
        } else {
            this.tListener.setAvailable(0, t);
        }
    }

    private void clearSelection() {
        this.switchSelection((PresentationComponent)null);
    }

    private class BasicPropertyRefresher
    implements XFormSelection.PropertyRefresher {
        private BasicPropertyRefresher() {
        }

        @Override
        public void refreshProperties(PropertyTable propertyTable, XFormPresentationXMLObject selection) {
            PresentationDataPanel.this.getPresentationPanel().refreshProperties(propertyTable, selection);
        }

        @Override
        public void refreshProperties(PropertyTable propertyTable, List<XFormPresentationXMLObject> selection) {
            PresentationDataPanel.this.getPresentationPanel().refreshProperties(propertyTable, selection.toArray(new XFormPresentationXMLObject[selection.size()]));
        }
    }
}

