/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.LinkedList;
import oracle.bpm.designer.formdesigner.AttributeSelectionPanel;
import oracle.bpm.designer.formdesigner.preferences.PresentationPreferencesPanel;
import oracle.bpm.designer.formdesigner.preferences.Utils;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.FuegoJob;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.utils.Layout;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardDummySummaryStep;
import oracle.bpm.ui.wizards.model.WizardLastStep;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.model.WizardStepTransition;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;

public class PresentationCreation
extends Wizard {
    public PresentationNameStep nameStep;
    UiWindow frame;
    PresentationGenerationOptions options;
    XObjectTypeDescription otd;
    public static final String NAME = "name";
    public static final String FROMTEMPLATE = "fromTemplate";
    public static final String ATTRSMAP = "attributesmap";
    public static final String INNERS = "inner";
    public static final String GROUPATTS = "groupedattributes";
    public static final String GROUPS = "groups";
    public static final String ATTRS = "attributes";
    public static final String ROWS = "rows";
    public static final String COLS = "cols";
    public static final String BGCOLOR = "color";

    public PresentationCreation(UiWindow frame, XObjectTypeDescription otd) {
        this.setMsg(DesignerMsg.PRESWIZ);
        this.otd = otd;
        this.frame = frame;
        LinkedList steps = this.getSteps();
        this.nameStep = new PresentationNameStep(this, new NameStepTransition());
        steps.add(this.nameStep);
        steps.add(new PresentationSizeStep(this, new SizeStepTransition()));
        steps.add(new PresentationPrefStep(this));
        if (otd != null) {
            steps.add(new PresentationFieldsStep(this));
        }
        this.options = (PresentationGenerationOptions)FuegoWorker.post((FuegoJob)new FuegoJob<PresentationGenerationOptions>(){

            public PresentationGenerationOptions run() {
                return PresentationGenerationOptions.load();
            }
        });
        frame.setMinimumSize(Dimension.valueOf(620, 370));
    }

    public int run() {
        this.build();
        return super.run();
    }

    protected WizardStep getInitialStep() {
        return null;
    }

    protected WizardStep getSummaryStep() {
        return new WizardDummySummaryStep((Wizard)this);
    }

    private GridBagConstraints getFldConstraints(int gridy, int gridx) {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = gridx;
        constr.gridy = gridy;
        constr.fill = 1;
        constr.anchor = 17;
        constr.insets = new Insets(8, 10, 8, 10);
        return constr;
    }

    class SizeStepTransition
    extends WizardStepTransition {
        SizeStepTransition() {
        }

        protected WizardStep getNextStepFor(WizardStep aStep) {
            return aStep.getWizard().getLastStep();
        }
    }

    class PresentationSizeStepPanel
    extends WizardStepPanel {
        String color;
        Label colorLabel;
        int cols;
        NumericField<Integer> input;
        NumericField<Integer> input2;
        Button input3;
        int rows;

        public PresentationSizeStepPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        public boolean validateInput() {
            this.rows = (Integer)this.input.getValue();
            this.cols = (Integer)this.input2.getValue();
            this.color = this.colorLabel.getText().equals("") ? null : this.colorLabel.getText();
            return this.rows != 0 && this.cols != 0;
        }

        protected UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(DesignerMsg.PRESWIZ_SIZE);
            Panel centralPanel = new Panel(parent);
            centralPanel.setLayout((oracle.bpm.ui.layout.Layout)new GridBagLayout());
            this.input = NumericField.createIntegerNumericField((UiContainer)centralPanel);
            this.input.setColumns(5);
            this.input.setValue((Number)3);
            this.input2 = NumericField.createIntegerNumericField((UiContainer)centralPanel);
            this.input2.setColumns(5);
            this.input2.setValue((Number)3);
            Panel colorPanel = new Panel((UiContainer)centralPanel);
            this.colorLabel = Label.create((UiContainer)colorPanel);
            this.input3 = new Button((UiContainer)colorPanel);
            colorPanel.setLayout((oracle.bpm.ui.layout.Layout)new GridLayout(1, 2));
            colorPanel.add((UiComponent)this.colorLabel);
            colorPanel.add((UiComponent)this.input3);
            Utils.linkColorLabelAndButton(this.colorLabel, this.input3);
            Label label = Label.create((UiContainer)centralPanel, (Msg)DesignerMsg.ROWS);
            centralPanel.add((UiComponent)label, (Object)PresentationCreation.this.getFldConstraints(0, 0));
            centralPanel.add(this.input, (Object)PresentationCreation.this.getFldConstraints(0, 1));
            Label label2 = Label.create((UiContainer)centralPanel, (Msg)DesignerMsg.COLUMNS);
            centralPanel.add((UiComponent)label2, (Object)PresentationCreation.this.getFldConstraints(1, 0));
            centralPanel.add(this.input2, (Object)PresentationCreation.this.getFldConstraints(1, 1));
            Label label3 = Label.create((UiContainer)centralPanel, (Msg)DesignerMsg.BACK_COLOR);
            centralPanel.add((UiComponent)label3, (Object)PresentationCreation.this.getFldConstraints(2, 0));
            centralPanel.add((UiComponent)colorPanel, (Object)PresentationCreation.this.getFldConstraints(2, 1));
            if (PresentationCreation.this.getProperties().get(PresentationCreation.BGCOLOR) != null) {
                String colorString = (String)PresentationCreation.this.getProperties().get(PresentationCreation.BGCOLOR);
                Utils.setLabelColor(this.colorLabel, colorString);
            }
            return centralPanel;
        }
    }

    class PresentationSizeStep
    extends WizardStep
    implements WizardLastStep {
        private PresentationSizeStepPanel sizePanel;

        public PresentationSizeStep(Wizard owner, WizardStepTransition wstept) {
            super(owner, wstept);
        }

        public boolean doProcess() {
            this.getWizard().getProperties().put(PresentationCreation.ROWS, this.sizePanel.rows);
            this.getWizard().getProperties().put(PresentationCreation.COLS, this.sizePanel.cols);
            this.getWizard().getProperties().put(PresentationCreation.BGCOLOR, this.sizePanel.color);
            return true;
        }

        public void undoProcess() {
        }

        protected WizardStepPanel getPanelFor(UiContainer parent) {
            if (this.sizePanel == null) {
                this.sizePanel = new PresentationSizeStepPanel(parent, this);
            }
            return this.sizePanel;
        }
    }

    class PresentationPrefStepPanel
    extends WizardStepPanel {
        private PresentationPreferencesPanel prefPanel;

        public PresentationPrefStepPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        public boolean validateInput() {
            this.prefPanel.storeOptions();
            return true;
        }

        protected UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(DesignerMsg.PRESENTATION_PREFERENCES);
            this.prefPanel = new PresentationPreferencesPanel(parent, PresentationCreation.this.options);
            return this.prefPanel;
        }
    }

    class PresentationPrefStep
    extends WizardStep {
        private PresentationPrefStepPanel prefPanel;

        public PresentationPrefStep(Wizard owner) {
            super(owner);
        }

        public boolean doProcess() {
            return true;
        }

        public void undoProcess() {
        }

        protected WizardStepPanel getPanelFor(UiContainer parent) {
            if (this.prefPanel == null) {
                this.prefPanel = new PresentationPrefStepPanel(parent, this);
            }
            return this.prefPanel;
        }
    }

    class PresentationNameStepPanel
    extends WizardStepPanel {
        private CheckBox prefCheckBox;
        private String presentationName;
        private TextField presentationNameTextField;
        private CheckBox templateCheckBox;

        public PresentationNameStepPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
            this.presentationName = "Presentation1";
            int i = 1;
            if (PresentationCreation.this.otd != null) {
                while (PresentationCreation.this.otd.getPresentationModel(this.presentationName) != null) {
                    this.presentationName = "Presentation" + ++i;
                }
            }
        }

        public void onFocus() {
            this.revalidate();
        }

        public Dimension getMinimumSize() {
            return Dimension.valueOf(300, 220);
        }

        public String getName() {
            return this.presentationNameTextField.getText();
        }

        public boolean checkPreferences() {
            return this.prefCheckBox.isSelected();
        }

        public boolean createFromTemplate() {
            return this.templateCheckBox.isSelected();
        }

        public boolean validateInput() {
            if (this.getName() == null || this.getName().trim().equals("")) {
                MessageDialog.showError((Msg)DesignerMsg.PRESENTATION_NAME_EMPTY);
                return false;
            }
            if (PresentationCreation.this.otd != null && PresentationCreation.this.otd.getPresentationModel(this.getName()) != null) {
                MessageDialog.showError((Msg)DesignerMsg.PRESENTATION_NAME_ALREADY_EXISTS(this.getName()));
                return false;
            }
            PresentationCreation.this.options.setCreateFromTemplate(this.templateCheckBox.isSelected());
            PresentationCreation.this.options.store();
            return true;
        }

        protected UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(DesignerMsg.PRESWIZ_NAME);
            Panel centerPanel = new Panel(parent){

                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    UiUtilities.focusAndSelect((TextComponent)PresentationNameStepPanel.this.presentationNameTextField);
                }
            };
            RelativeLayout layout = new RelativeLayout();
            centerPanel.setLayout((oracle.bpm.ui.layout.Layout)layout);
            Panel optionsPanel = new Panel((UiContainer)centerPanel, LibMsg.OPTIONS);
            optionsPanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            Panel templatePanel = new Panel((UiContainer)optionsPanel);
            Panel prefPanel = new Panel((UiContainer)optionsPanel);
            prefPanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            this.presentationNameTextField = new IdentifierTextField((UiContainer)centerPanel, this.presentationName, 40, true, true){};
            this.templateCheckBox = CheckBox.create((UiContainer)templatePanel, (Msg)DesignerMsg.FROM_TEMPLATE);
            this.prefCheckBox = CheckBox.create((UiContainer)prefPanel, (Msg)UIMsg.PREFERENCES);
            this.templateCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PresentationNameStepPanel.this.prefCheckBox.setEnabled(PresentationNameStepPanel.this.templateCheckBox.isSelected());
                }
            });
            this.templateCheckBox.setSelected(PresentationCreation.this.options.doCreateFromTemplate());
            this.prefCheckBox.setEnabled(PresentationCreation.this.options.doCreateFromTemplate());
            LabelMultiline templateArea = new LabelMultiline((UiContainer)templatePanel, DesignerMsg.FROM_TEMPLATE_INFO);
            templateArea.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
            templatePanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            templatePanel.add((UiComponent)templateArea, (Object)"North");
            templatePanel.add((UiComponent)this.templateCheckBox, (Object)"Center");
            templatePanel.add(Box.createVerticalStrut((UiContainer)templatePanel, (int)10), (Object)"South");
            LabelMultiline prefArea = new LabelMultiline((UiContainer)prefPanel, DesignerMsg.PRESENTATION_PREF_INFO);
            prefArea.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
            prefPanel.add((UiComponent)prefArea, (Object)"Center");
            prefPanel.add((UiComponent)this.prefCheckBox, (Object)"South");
            optionsPanel.add((UiComponent)templatePanel, (Object)"North");
            optionsPanel.add((UiComponent)prefPanel, (Object)"Center");
            centerPanel.add((UiComponent)Label.create((UiContainer)centerPanel, (Msg)DesignerMsg.PRESENTATION), (Object)"nameLbl");
            centerPanel.add((UiComponent)this.presentationNameTextField, (Object)"nameFld");
            centerPanel.add((UiComponent)optionsPanel, (Object)"optionsPanel");
            centerPanel.add((UiComponent)Label.create((UiContainer)centerPanel), (Object)"dummy");
            Layout.fixToRoot((RelativeLayout)layout, (String)"nameLbl", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"nameLbl", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"nameFld");
            Layout.fixToRoot((RelativeLayout)layout, (String)"nameFld", (AttributeType)AttributeType.TOP, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"nameFld", (AttributeType)AttributeType.LEFT, (String)"nameLbl", (AttributeType)AttributeType.RIGHT, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.TOP, (String)"nameFld", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.LEFT, (String)"nameLbl");
            Layout.fixToRoot((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToComp((RelativeLayout)layout, (String)"dummy", (AttributeType)AttributeType.TOP, (String)"optionsPanel", (AttributeType)AttributeType.BOTTOM, (int)35);
            Layout.fixToComp((RelativeLayout)layout, (String)"dummy", (AttributeType)AttributeType.LEFT, (String)"optionsPanel");
            return centerPanel;
        }
    }

    class PresentationNameStep
    extends WizardStep {
        public PresentationNameStepPanel namePanel;

        public PresentationNameStep(Wizard owner, WizardStepTransition wstept) {
            super(owner, wstept);
        }

        public boolean doProcess() {
            this.getWizard().getProperties().put(PresentationCreation.NAME, this.namePanel.getName());
            this.getWizard().getProperties().put(PresentationCreation.FROMTEMPLATE, this.namePanel.templateCheckBox.isSelected());
            return true;
        }

        public void undoProcess() {
        }

        protected WizardStepPanel getPanelFor(UiContainer parent) {
            if (this.namePanel == null) {
                this.namePanel = new PresentationNameStepPanel(parent, this);
            }
            return this.namePanel;
        }
    }

    class PresentationFieldsStepPanel
    extends WizardStepPanel {
        String[] attributes;
        AttributeSelectionPanel attributesPanel;

        public PresentationFieldsStepPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        public boolean validateInput() {
            this.attributesPanel.createDatas();
            return true;
        }

        protected UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(DesignerMsg.PRESWIZ_FIELDS);
            this.getWizardStep().getCancelButton().setEnabled(true);
            this.attributesPanel = new AttributeSelectionPanel(parent, PresentationCreation.this.otd);
            return this.attributesPanel;
        }
    }

    class PresentationFieldsStep
    extends WizardStep
    implements WizardLastStep {
        private PresentationFieldsStepPanel fieldsPanel;

        public PresentationFieldsStep(Wizard owner) {
            super(owner);
        }

        public boolean doProcess() {
            this.fieldsPanel.validateInput();
            this.getWizard().getProperties().put(PresentationCreation.ATTRS, this.fieldsPanel.attributesPanel.getAttributes());
            this.getWizard().getProperties().put(PresentationCreation.GROUPS, this.fieldsPanel.attributesPanel.getGroups());
            this.getWizard().getProperties().put(PresentationCreation.GROUPATTS, this.fieldsPanel.attributesPanel.getGroupedAttributesHash());
            this.getWizard().getProperties().put(PresentationCreation.INNERS, this.fieldsPanel.attributesPanel.getInnerXOHash());
            this.getWizard().getProperties().put(PresentationCreation.ATTRSMAP, this.fieldsPanel.attributesPanel.getAttributesMap());
            return true;
        }

        public void undoProcess() {
        }

        protected WizardStepPanel getPanelFor(UiContainer parent) {
            if (this.fieldsPanel == null) {
                this.fieldsPanel = new PresentationFieldsStepPanel(parent, this);
            }
            return this.fieldsPanel;
        }
    }

    class NameStepTransition
    extends WizardStepTransition {
        NameStepTransition() {
        }

        protected WizardStep getNextStepFor(WizardStep aStep) {
            PresentationNameStep currentStep = (PresentationNameStep)aStep;
            if (!currentStep.namePanel.createFromTemplate()) {
                return aStep.getRelativeStep(1);
            }
            if (currentStep.namePanel.checkPreferences()) {
                return aStep.getRelativeStep(2);
            }
            return aStep.getRelativeStep(3);
        }
    }
}

