/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.io.IOException;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.xml.XmlWriter;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.EasyFullBorderPropertiesSetter;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.SimpleBorderProperties;

public class FullBorderPropertiesImpl
implements FullBorderProperties {
    private String bottomColor;
    private BorderStyle bottomStyle;
    private int bottomWidth;
    private String leftColor;
    private BorderStyle leftStyle;
    private int leftWidth;
    private String rightColor;
    private BorderStyle rightStyle;
    private int rightWidth;
    private String topColor;
    private BorderStyle topStyle;
    private int topWidth;

    public FullBorderPropertiesImpl() {
    }

    public FullBorderPropertiesImpl(BorderProperties borderProperties) {
        if (borderProperties instanceof FullBorderProperties) {
            this.createBorder((FullBorderProperties)borderProperties);
        } else {
            this.createBorder((SimpleBorderProperties)borderProperties);
        }
    }

    public static FullBorderProperties createFullBorderFrom(BorderProperties initialBorder) {
        FullBorderPropertiesImpl result;
        if (initialBorder != null) {
            result = new FullBorderPropertiesImpl(initialBorder);
        } else {
            result = new FullBorderPropertiesImpl();
            EasyFullBorderPropertiesSetter.setDefaultBorder(result);
        }
        return result;
    }

    @Override
    public boolean isBorderActive() {
        return true;
    }

    @Override
    public void setBottomColor(String color) {
        this.bottomColor = color;
    }

    @Override
    public String getBottomColor() {
        return this.bottomColor;
    }

    public void setBottomStyle(String style) {
        this.bottomStyle = BorderStyle.valueOf(style);
    }

    @Override
    public BorderStyle getBottomStyle() {
        return this.bottomStyle;
    }

    @Override
    public void setBottomWidth(int width) {
        this.bottomWidth = width;
    }

    @Override
    public int getBottomWidth() {
        return this.bottomWidth;
    }

    @Override
    public void setBottomborderstyle(BorderStyle style) {
        this.bottomStyle = style;
    }

    public void setCustomBorder(String color, BorderStyle style, int width) {
        this.setTopColor(color);
        this.setTopborderstyle(style);
        this.setTopWidth(width);
        this.setBottomColor(color);
        this.setBottomborderstyle(style);
        this.setBottomWidth(width);
        this.setLeftColor(color);
        this.setLeftborderstyle(style);
        this.setLeftWidth(width);
        this.setRightColor(color);
        this.setRightborderstyle(style);
        this.setRightWidth(width);
    }

    @Override
    public void setLeftColor(String color) {
        this.leftColor = color;
    }

    @Override
    public String getLeftColor() {
        return this.leftColor;
    }

    public void setLeftStyle(String style) {
        this.leftStyle = BorderStyle.valueOf(style);
    }

    @Override
    public BorderStyle getLeftStyle() {
        return this.leftStyle;
    }

    @Override
    public void setLeftWidth(int width) {
        this.leftWidth = width;
    }

    @Override
    public int getLeftWidth() {
        return this.leftWidth;
    }

    @Override
    public void setLeftborderstyle(BorderStyle style) {
        this.leftStyle = style;
    }

    @Override
    public void setRightColor(String color) {
        this.rightColor = color;
    }

    @Override
    public String getRightColor() {
        return this.rightColor;
    }

    public void setRightStyle(String style) {
        this.rightStyle = BorderStyle.valueOf(style);
    }

    @Override
    public BorderStyle getRightStyle() {
        return this.rightStyle;
    }

    @Override
    public void setRightWidth(int width) {
        this.rightWidth = width;
    }

    @Override
    public int getRightWidth() {
        return this.rightWidth;
    }

    @Override
    public void setRightborderstyle(BorderStyle style) {
        this.rightStyle = style;
    }

    public void setSimpleBorder(String color, BorderStyle style, int width) {
        this.setTopColor(color);
        this.setTopborderstyle(style);
        this.setTopWidth(width);
        this.setBottomColor(color);
        this.setBottomborderstyle(style);
        this.setBottomWidth(width);
        this.setLeftColor(color);
        this.setLeftborderstyle(style);
        this.setLeftWidth(width);
        this.setRightColor(color);
        this.setRightborderstyle(style);
        this.setRightWidth(width);
    }

    public boolean isSimpleBorder() {
        String topBorderColor = this.getTopColor();
        if (!(topBorderColor.equals(this.getBottomColor()) && topBorderColor.equals(this.getLeftColor()) && topBorderColor.equals(this.getRightColor()))) {
            return false;
        }
        BorderStyle topBorderStyle = this.getTopStyle();
        if (topBorderStyle != this.getBottomStyle() || topBorderStyle != this.getLeftStyle() || topBorderStyle != this.getRightStyle()) {
            return false;
        }
        int topBorderWidth = this.getTopWidth();
        return topBorderWidth == this.getBottomWidth() && topBorderWidth == this.getLeftWidth() && topBorderWidth == this.getRightWidth();
    }

    @Override
    public void setTopColor(String color) {
        this.topColor = color;
    }

    @Override
    public String getTopColor() {
        return this.topColor;
    }

    public void setTopStyle(String style) {
        this.topStyle = BorderStyle.valueOf(style);
    }

    @Override
    public BorderStyle getTopStyle() {
        return this.topStyle;
    }

    @Override
    public void setTopWidth(int width) {
        this.topWidth = width;
    }

    @Override
    public int getTopWidth() {
        return this.topWidth;
    }

    @Override
    public void setTopborderstyle(BorderStyle style) {
        this.topStyle = style;
    }

    public void createBorder(FullBorderProperties borderProperties) {
        this.bottomStyle = borderProperties.getBottomStyle();
        this.leftStyle = borderProperties.getLeftStyle();
        this.rightStyle = borderProperties.getRightStyle();
        this.topStyle = borderProperties.getTopStyle();
        this.bottomColor = borderProperties.getBottomColor();
        this.leftColor = borderProperties.getLeftColor();
        this.rightColor = borderProperties.getRightColor();
        this.topColor = borderProperties.getTopColor();
        this.bottomWidth = borderProperties.getBottomWidth();
        this.leftWidth = borderProperties.getLeftWidth();
        this.rightWidth = borderProperties.getRightWidth();
        this.topWidth = borderProperties.getTopWidth();
    }

    public void createBorder(SimpleBorderProperties borderProperties) {
        this.bottomStyle = borderProperties.getBorderstyle();
        this.leftStyle = borderProperties.getBorderstyle();
        this.rightStyle = borderProperties.getBorderstyle();
        this.topStyle = borderProperties.getBorderstyle();
        this.bottomColor = borderProperties.getBordercolor();
        this.leftColor = borderProperties.getBordercolor();
        this.rightColor = borderProperties.getBordercolor();
        this.topColor = borderProperties.getBordercolor();
        this.bottomWidth = borderProperties.getBorderwidth();
        this.leftWidth = borderProperties.getBorderwidth();
        this.rightWidth = borderProperties.getBorderwidth();
        this.topWidth = borderProperties.getBorderwidth();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FullBorderPropertiesImpl)) {
            return false;
        }
        FullBorderPropertiesImpl fullBorderProperties = (FullBorderPropertiesImpl)o;
        if (this.bottomWidth != fullBorderProperties.bottomWidth) {
            return false;
        }
        if (this.leftWidth != fullBorderProperties.leftWidth) {
            return false;
        }
        if (this.rightWidth != fullBorderProperties.rightWidth) {
            return false;
        }
        if (this.topWidth != fullBorderProperties.topWidth) {
            return false;
        }
        if (this.bottomColor != null ? !this.bottomColor.equals(fullBorderProperties.bottomColor) : fullBorderProperties.bottomColor != null) {
            return false;
        }
        if (this.bottomStyle != null ? !this.bottomStyle.equals(fullBorderProperties.bottomStyle) : fullBorderProperties.bottomStyle != null) {
            return false;
        }
        if (this.leftColor != null ? !this.leftColor.equals(fullBorderProperties.leftColor) : fullBorderProperties.leftColor != null) {
            return false;
        }
        if (this.leftStyle != null ? !this.leftStyle.equals(fullBorderProperties.leftStyle) : fullBorderProperties.leftStyle != null) {
            return false;
        }
        if (this.rightColor != null ? !this.rightColor.equals(fullBorderProperties.rightColor) : fullBorderProperties.rightColor != null) {
            return false;
        }
        if (this.rightStyle != null ? !this.rightStyle.equals(fullBorderProperties.rightStyle) : fullBorderProperties.rightStyle != null) {
            return false;
        }
        if (this.topColor != null ? !this.topColor.equals(fullBorderProperties.topColor) : fullBorderProperties.topColor != null) {
            return false;
        }
        return !(this.topStyle != null ? !this.topStyle.equals(fullBorderProperties.topStyle) : fullBorderProperties.topStyle != null);
    }

    public int hashCode() {
        int result = this.bottomStyle != null ? this.bottomStyle.hashCode() : 0;
        result = 29 * result + (this.leftStyle != null ? this.leftStyle.hashCode() : 0);
        result = 29 * result + (this.rightStyle != null ? this.rightStyle.hashCode() : 0);
        result = 29 * result + (this.topStyle != null ? this.topStyle.hashCode() : 0);
        result = 29 * result + (this.bottomColor != null ? this.bottomColor.hashCode() : 0);
        result = 29 * result + (this.leftColor != null ? this.leftColor.hashCode() : 0);
        result = 29 * result + (this.rightColor != null ? this.rightColor.hashCode() : 0);
        result = 29 * result + (this.topColor != null ? this.topColor.hashCode() : 0);
        result = 29 * result + this.bottomWidth;
        result = 29 * result + this.leftWidth;
        result = 29 * result + this.rightWidth;
        result = 29 * result + this.topWidth;
        return result;
    }

    public void serializeToXml(XmlWriter writer) throws IOException {
        writer.startElement("FullBorderPropertiesImpl");
        writer.printAttribute("bottomStyle", this.bottomStyle);
        writer.printAttribute("leftStyle", this.leftStyle);
        writer.printAttribute("rightStyle", this.rightStyle);
        writer.printAttribute("topStyle", this.topStyle);
        writer.printAttribute("bottomColor", this.bottomColor);
        writer.printAttribute("leftColor", this.leftColor);
        writer.printAttribute("rightColor", this.rightColor);
        writer.printAttribute("topColor", this.topColor);
        writer.printAttribute("bottomWidth", this.bottomWidth);
        writer.printAttribute("leftWidth", this.leftWidth);
        writer.printAttribute("rightWidth", this.rightWidth);
        writer.printAttribute("topWidth", this.topWidth);
        writer.endElement();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FullBorderPropertiesImpl");
        buf.append("{bottomColor=").append(this.bottomColor);
        buf.append(",bottomStyle=").append(this.bottomStyle);
        buf.append(",leftStyle=").append(this.leftStyle);
        buf.append(",rightStyle=").append(this.rightStyle);
        buf.append(",topStyle=").append(this.topStyle);
        buf.append(",leftColor=").append(this.leftColor);
        buf.append(",rightColor=").append(this.rightColor);
        buf.append(",topColor=").append(this.topColor);
        buf.append(",bottomWidth=").append(this.bottomWidth);
        buf.append(",leftWidth=").append(this.leftWidth);
        buf.append(",rightWidth=").append(this.rightWidth);
        buf.append(",topWidth=").append(this.topWidth);
        buf.append('}');
        return buf.toString();
    }

    void dumpBorder() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("isSimple = " + this.isSimpleBorder() + "\n");
        buffer.append("TOP [#");
        buffer.append(this.getTopColor() + ", ");
        buffer.append(this.getTopStyle() + ", ");
        buffer.append(this.getTopWidth() + "]\n");
        buffer.append("LEFT [#");
        buffer.append(this.getLeftColor() + ", ");
        buffer.append(this.getLeftStyle() + ", ");
        buffer.append(this.getLeftWidth() + "]\n");
        buffer.append("BOTTOM [#");
        buffer.append(this.getBottomColor() + ", ");
        buffer.append(this.getBottomStyle() + ", ");
        buffer.append(this.getBottomWidth() + "]\n");
        buffer.append("RIGHT [#");
        buffer.append(this.getRightColor() + ", ");
        buffer.append(this.getRightStyle() + ", ");
        buffer.append(this.getRightWidth() + "]\n");
        System.out.println("BorderPanel.dumpBorder " + buffer.toString());
    }
}

