/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.FontUtils;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class FontDecoder {
    private List availableFonts = FontUtils.getFontFamilyList();
    private Map<String, Font> unknownFonts = new HashMap<String, Font>();
    private static Map<String, Font> decodedFonts = new HashMap<String, Font>();

    public Font decodeFont(String componentId, String fontName) {
        Font theFont;
        if (!decodedFonts.containsKey(fontName)) {
            Font font = Font.decode((String)fontName);
            assert (font != null);
            decodedFonts.put(fontName, font);
        }
        if (this.availableFonts.indexOf((theFont = decodedFonts.get(fontName)).getName()) == -1) {
            this.unknownFonts.put(componentId, theFont);
        }
        return theFont;
    }

    public void showUnknownFontsWarningDialog(XFormPresentationModel model) {
        final String presentationName = model.getPresentationName();
        final String foName = model.getPresentation().getReference();
        final Map unknownFonts = this.getUnknownFontNames();
        if (unknownFonts != null) {
            final StringBuffer unknownFontNameBuffer = new StringBuffer();
            unknownFontNameBuffer.append("\n");
            for (String componentId : unknownFonts.keySet()) {
                Font font = (Font)unknownFonts.get(componentId);
                unknownFontNameBuffer.append("\n- ");
                unknownFontNameBuffer.append(componentId);
                unknownFontNameBuffer.append(": ");
                unknownFontNameBuffer.append(UIMsg.FONT.getString());
                unknownFontNameBuffer.append(" [");
                unknownFontNameBuffer.append(font.getName());
                unknownFontNameBuffer.append("]");
            }
            final DesignerPreferences preferences = DesignerPreferences.getPreferences();
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    DialogFactory.showWarningDialog((HiddenMessagesPreferences)preferences, (Msg)DesignerMsg.UNKNOWN_FONTS(presentationName, foName, unknownFontNameBuffer.toString()), (String)unknownFonts.toString());
                }
            });
        }
    }

    private Map getUnknownFontNames() {
        if (this.unknownFonts.size() == 0) {
            return null;
        }
        return this.unknownFonts;
    }
}

