/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Insets;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;

public class Dialogs
extends MessageDialog {
    static final int DEFAULT_COLS = 3;
    static final int DEFAULT_ROWS = 3;
    static final long serialVersionUID = -4757549312366353873L;
    static final long serialCheck = -529955577487228260L;

    public static int showArrayDimensionsDialog(UiComponent parentComponent) {
        return Dialogs.showArrayDimensionsDialog((UiContainer)parentComponent);
    }

    public static int[] showRowDimensionDialog(UiComponent parentComponent, int cols) {
        UiWindow container = UiWindow.getRootFrom((UiComponent)parentComponent);
        return Dialogs.showRowDimensionDialog((UiContainer)container, cols);
    }

    public static int[] showRowDimensionDialog(UiContainer parent, int cols) {
        int[] nArray;
        DialogParamters result = new DialogParamters(false);
        Dialogs.showTableDimensionsAndColorDialog((UiComponent)parent, result, DesignerMsg.ADD_ROW, cols);
        if (result.isOk()) {
            int[] nArray2 = new int[2];
            nArray2[0] = result.getColumns();
            nArray = nArray2;
            nArray2[1] = result.getRows();
        } else {
            nArray = null;
        }
        return nArray;
    }

    public static int[] showTableDimensionsDialog(UiComponent parent) {
        int[] nArray;
        DialogParamters result = new DialogParamters(true);
        Dialogs.showTableDimensionsAndColorDialog(parent, result, DesignerMsg.INSERT_TABLE, 0);
        if (result.isOk()) {
            int[] nArray2 = new int[2];
            nArray2[0] = result.getRows();
            nArray = nArray2;
            nArray2[1] = result.getColumns();
        } else {
            nArray = null;
        }
        return nArray;
    }

    static void constrain(UiContainer container, UiComponent component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + bottom + left + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        container.add(component, (Object)c);
    }

    private static int showArrayDimensionsDialog(UiContainer parent) {
        DialogParamters result = new DialogParamters(false);
        Dialogs.showTableDimensionsAndColorDialog((UiComponent)parent, result, DesignerMsg.INSERT_ARRAY, 0);
        return result.isOk() ? result.getColumns() : -1;
    }

    private static DialogParamters showTableDimensionsAndColorDialog(UiComponent parent, DialogParamters holder, Msg title, int cols) {
        Dialog dialog = Dialogs.createDialog(parent, title);
        ButtonKeyListener keyListener = new ButtonKeyListener(holder, (UiComponent)dialog);
        Panel centerContent = new Panel(dialog.getContentPane());
        centerContent.setLayout((Layout)new GridBagLayout());
        Dialogs.constrain((UiContainer)centerContent, (UiComponent)Dialogs.createLabel((UiContainer)centerContent, DesignerMsg.COLUMNS), 0, 0, 1, 1, 0, 13, 0.0, 0.0, 5, 5, 5, 5);
        NumericField<Integer> columnField = Dialogs.createNumericField((UiContainer)centerContent, cols == 0 ? 3 : cols);
        Dialogs.constrain((UiContainer)centerContent, columnField, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        columnField.addKeyListener((KeyListener)keyListener);
        holder.setColsField(columnField);
        if (holder.showRows()) {
            Dialogs.constrain((UiContainer)centerContent, (UiComponent)Dialogs.createLabel((UiContainer)centerContent, DesignerMsg.ROWS), 0, 1, 1, 1, 0, 13, 0.0, 0.0, 5, 5, 5, 5);
            NumericField<Integer> rowsField = Dialogs.createNumericField((UiContainer)centerContent, 3);
            rowsField.addKeyListener((KeyListener)keyListener);
            Dialogs.constrain((UiContainer)centerContent, rowsField, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
            holder.setRowsField(rowsField);
        }
        dialog.getContentPane().add((UiComponent)centerContent, (Object)"Center");
        Panel buttonPanel = new Panel(dialog.getContentPane());
        buttonPanel.setLayout((Layout)new FlowLayout());
        Button okButton = keyListener.createOkButton(buttonPanel);
        keyListener.createCancelButton(buttonPanel);
        dialog.getContentPane().add((UiComponent)buttonPanel, (Object)"South");
        dialog.setDefaultButton(okButton);
        dialog.requestFocus();
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        columnField.requestFocus();
        columnField.grabFocus();
        dialog.setVisible(true);
        return holder;
    }

    private static Dialog createDialog(UiComponent parent, Msg title) {
        Dialog result = new Dialog(parent.getOwnerWindow(), title, true);
        result.getContentPane().setLayout((Layout)new BorderLayout());
        return result;
    }

    private static NumericField<Integer> createNumericField(UiContainer parent, int cols) {
        NumericField input = NumericField.createIntegerNumericField((UiContainer)parent);
        input.setColumns(5);
        input.setValue((Number)cols);
        return input;
    }

    private static Label createLabel(UiContainer parent, Msg text) {
        Label result = Label.create((UiContainer)parent, (Msg)text);
        result.setVerticalAlignment(3);
        return result;
    }

    private static class ButtonKeyListener
    implements KeyListener {
        private final BaseAction cancel;
        private final BaseAction ok;

        public ButtonKeyListener(final DialogParamters holder, final UiComponent dialog) {
            this.ok = new BaseAction(UIMsg.OK){

                public void run() {
                    holder.validateInput();
                    if (holder.isOk()) {
                        dialog.dispose();
                    }
                }
            };
            this.cancel = new BaseAction(UIMsg.CANCEL){

                public void run() {
                    holder.ok = false;
                    dialog.dispose();
                }
            };
        }

        public Button createCancelButton(Panel buttonPanel) {
            return this.createButton(buttonPanel, this.cancel);
        }

        public Button createOkButton(Panel buttonPanel) {
            return this.createButton(buttonPanel, this.ok);
        }

        public void keyPressed(KeyEvent e) {
            if (e.isEscape()) {
                this.cancel.run();
            } else if (e.isEnter()) {
                this.ok.run();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        private Button createButton(Panel parent, BaseAction action) {
            Button result = new Button((UiContainer)parent, action);
            parent.add((UiComponent)result);
            return result;
        }
    }

    static class DialogParamters {
        private NumericField<Integer> colsField;
        private boolean ok;
        private NumericField<Integer> rowsField;
        private final boolean showRows;

        public DialogParamters(boolean showRows) {
            this.showRows = showRows;
        }

        public void setColsField(NumericField<Integer> colsField) {
            this.colsField = colsField;
        }

        public void setRowsField(NumericField<Integer> rowsField) {
            this.rowsField = rowsField;
        }

        public boolean isInputValid() {
            return this.isInputValid(this.colsField) && this.isInputValid(this.rowsField);
        }

        public int getColumns() {
            return this.getValue(this.colsField);
        }

        public int getRows() {
            return this.getValue(this.rowsField);
        }

        public boolean validateInput() {
            this.ok = this.isInputValid();
            return this.ok;
        }

        public boolean isOk() {
            return this.ok;
        }

        public boolean showRows() {
            return this.showRows;
        }

        private boolean isInputValid(NumericField field) {
            return field == null || !field.isSwing() || field.getInputVerifier() == null || field.getInputVerifier().verify(field.asSwing());
        }

        private int getValue(NumericField<Integer> numericField) {
            return numericField != null ? (Integer)numericField.getValue() : 0;
        }
    }
}

