/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.Map;
import java.util.Vector;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.properties.ComponentInteractionProvider;
import oracle.bpm.designer.formdesigner.properties.ComponentProperties;
import oracle.bpm.designer.formdesigner.properties.MethodFilter;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ComponentInteractionProviderImpl
implements ComponentInteractionProvider {
    private DataTreeHelper helper;

    public ComponentInteractionProviderImpl(DataTreeHelper helper) {
        this.helper = helper;
    }

    @Override
    public Vector getInvokeableMethods(ComponentProperties componentProperties) {
        return this.getInvokeableMethods(componentProperties, null);
    }

    @Override
    public Vector getInvokeableMethods(ComponentProperties componentProperties, MethodFilter methodFilter) {
        return this.getHelper().getMethods(componentProperties.getReferencedObject(), methodFilter);
    }

    @Override
    public boolean isTopLevel(XFormTable referencedTable) {
        return this.getModel().getPresentation().table == referencedTable;
    }

    @Override
    public Map<String, XObjectTypeDescription.ResourceValue> getResources() {
        Map<String, XObjectTypeDescription.ResourceValue> result = null;
        ObjectTypeDescription objectTypeDescription = this.getModel().getOwner();
        if (objectTypeDescription instanceof XObjectTypeDescription) {
            result = ((XObjectTypeDescription)objectTypeDescription).getResources();
        }
        return result;
    }

    @Override
    public boolean isRepeatableComponet(XFormPresentationXMLObject object) {
        String repeatable = DataTreeHelper.getRepeatable(object);
        return repeatable != null && !"null".equals(repeatable);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isCssEnabled() {
        return this.getModel().getPresentation().isCssEnabled();
    }

    @Override
    public ObjectTypeDescription getObjectTypeDescription() {
        return this.getModel().getOwner();
    }

    @Override
    public String getPathFor(XFormXMLObject object) {
        return DataTreeHelper.getNodeReferencesPath(object);
    }

    @Override
    public XFormPresentationModel getModel() {
        return this.getHelper().getModel();
    }

    private DataTreeHelper getHelper() {
        return this.helper;
    }
}

