/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.CommandManager;
import oracle.bpm.designer.formdesigner.FullBorderPropertiesImpl;
import oracle.bpm.designer.formdesigner.ToolbarListener;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.command.CompoundCommand;
import oracle.bpm.designer.formdesigner.command.ModifyPropertyValueCommand;
import oracle.bpm.designer.formdesigner.properties.BorderHelper;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.xobject.presentationmodel.AlignmentProperties;
import oracle.bpm.xobject.presentationmodel.BorderProperties;
import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.FontProperties;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;

class ComponentInteraction
implements ToolbarListener.ToolbarInteractions {
    String alignment = null;
    String fontFace = null;
    FontStyle fontModifiers;
    int fontSize = 0;
    int modifiers;
    private ChangeListener cl;
    private XFormPresentationXMLObject[] list;

    public ComponentInteraction(XFormPresentationXMLObject[] list, ChangeListener cl) {
        this.list = list;
        this.cl = cl;
        this.modifiers = 0;
        this.checkBorder();
        this.checkColor();
        this.checkFont();
        this.checkAlignment();
    }

    public XFormPresentationXMLObject[] getComponents() {
        return this.list;
    }

    @Override
    public void setAlignment(String align) {
        this.setValue(align, "alignment", DesignerMsg.CHANGE_ALIGN_TO(align));
        this.alignment = align;
    }

    @Override
    public String getAlignment() {
        return this.alignment;
    }

    @Override
    public void setBackGround(Color color) {
        String colorString = Utilities.getString(color);
        this.setValue(colorString, "bgcolor", DesignerMsg.CHANGE_BG_TO(colorString));
    }

    @Override
    public void setBorder(BorderProperties border) {
        if (border != null) {
            CompoundCommand command = new CompoundCommand(new ArrayList(), DesignerMsg.CHANGE_BORDER);
            for (int i = 0; i < this.list.length; ++i) {
                if (!(this.list[i] instanceof BorderProperties)) continue;
                BorderProperties target = (BorderProperties)((Object)this.list[i]);
                Iterator iterator = BorderHelper.createChangeCommands(target, this.cl, border).iterator();
                while (iterator.hasNext()) {
                    command.addCommand((Command)iterator.next());
                }
            }
            CommandManager.invokeCommand(command);
        }
    }

    @Override
    public BorderProperties getBorder() {
        BorderProperties border = null;
        for (int i = 0; i < this.list.length && border == null; ++i) {
            if (!(this.list[i] instanceof BorderProperties)) continue;
            border = (BorderProperties)((Object)this.list[i]);
        }
        if (border == null) {
            border = new FullBorderPropertiesImpl();
        }
        return border;
    }

    @Override
    public void setFontFace(String font) {
        this.setValue(font, "fonttype", DesignerMsg.CHANGE_FONT_FACE_TO(font));
        this.fontFace = font;
    }

    @Override
    public String getFontFace() {
        return this.fontFace;
    }

    @Override
    public void setFontModifiers(FontStyle modifiers) {
        this.setValue(modifiers, "fontface", DesignerMsg.CHANGE_FONT_MODIFIERS(modifiers));
        this.fontModifiers = modifiers;
    }

    @Override
    public FontStyle getFontModifiers() {
        return this.fontModifiers;
    }

    @Override
    public void setFontSize(int size) {
        this.setValue(size, "fontsize", DesignerMsg.CHANGE_FONT_SIZE_TO(size + ""));
        this.fontSize = size;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setForeGround(Color color) {
        String colorString = Utilities.getString(color);
        this.setValue(colorString, "fgcolor", DesignerMsg.CHANGE_FG_TO(colorString));
    }

    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public void changeFontModifiers(FontStyle modifiers) {
        this.setFontModifiers(modifiers.contains(this.fontModifiers) ? this.fontModifiers.remove(modifiers) : modifiers.add(this.fontModifiers));
    }

    private void setValue(Object value, String propertyName, Msg commandName) {
        CompoundCommand command = new CompoundCommand(new ArrayList(), commandName);
        for (int i = 0; i < this.list.length; ++i) {
            command.addCommand(new ModifyPropertyValueCommand(this.list[i], value, propertyName, this.cl));
        }
        CommandManager.invokeCommand(command);
    }

    private void checkAlignment() {
        for (int i = 0; i < this.list.length; ++i) {
            if (!(this.list[i] instanceof AlignmentProperties)) {
                return;
            }
            AlignmentProperties ap = (AlignmentProperties)((Object)this.list[i]);
            if (this.alignment == null) {
                this.alignment = ap.getAlignment();
                continue;
            }
            if (this.alignment.equals(ap.getAlignment())) continue;
            this.alignment = "";
        }
        this.modifiers |= 0x200;
    }

    private void checkBorder() {
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] instanceof BorderProperties) continue;
            return;
        }
        this.modifiers |= 0x1000;
    }

    private void checkColor() {
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] instanceof ColorProperties) continue;
            return;
        }
        this.modifiers |= 0x800;
        this.modifiers |= 0x400;
    }

    private void checkFont() {
        for (XFormPresentationXMLObject xmlObject : this.list) {
            if (!(xmlObject instanceof FontProperties)) {
                return;
            }
            FontProperties fp = (FontProperties)((Object)xmlObject);
            if (this.fontFace == null) {
                this.fontFace = fp.getFonttype();
                this.fontModifiers = fp.getFontStyle();
                this.fontSize = fp.getFontsize();
                continue;
            }
            if (!this.fontFace.equals(fp.getFonttype())) {
                this.fontFace = "";
            }
            if (this.fontModifiers != null && !this.fontModifiers.equals(fp.getFontStyle())) {
                this.fontModifiers = null;
            }
            if (this.fontSize == fp.getFontsize()) continue;
            this.fontSize = 0;
        }
        this.modifiers |= 0x80;
        this.modifiers |= 0x40;
        this.modifiers |= 0x100;
    }
}

