/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.bpm.designer.formdesigner.AttributesCheckTreeNode;
import oracle.bpm.designer.formdesigner.XOUserObject;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class ChooseReferenceDialog
extends OkCancelDialog {
    private boolean canBeOk = true;
    private String currentReference;
    private ObjectTypeDescription objectTypeDescription;
    private List<String> path;
    private String pathString;
    private int[] ref;
    private Tree tree;

    public ChooseReferenceDialog(ObjectTypeDescription objectTypeDescription, String pathString, XFormXMLObject xmlObject) {
        super(Ui.getRoot(), DesignerMsg.CHOOSE_REFERENCE, true);
        this.objectTypeDescription = objectTypeDescription;
        this.pathString = pathString;
        this.path = new ArrayList<String>();
        this.setResizable(false);
        if (pathString != null) {
            StringTokenizer tok = new StringTokenizer(pathString, ".");
            while (tok.hasMoreTokens()) {
                this.path.add(tok.nextToken());
            }
        }
        this.initRef(xmlObject);
        if (this.path.contains(null)) {
            this.buildErrorPanel(DesignerMsg.CHOOSE_REFERENCE_FOLLOW_PATH_ERROR(pathString));
        } else {
            this.buildMainPanel();
        }
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.pack();
    }

    public String getReference() {
        XOUserObject selection = this.getSelection();
        return selection == null ? null : (this.pathString == null ? "" : this.pathString + ".") + selection.getFullName();
    }

    public MethodTypeDescription getReferenceMember() {
        XOUserObject selection = this.getSelection();
        return selection == null ? null : (MethodTypeDescription)selection.member;
    }

    public void ok() {
        if (this.getReference() != null || !this.canBeOk) {
            this.close();
        } else {
            MessageDialog.showNotice((Msg)DesignerMsg.INVALID_REFERENCE_SELECTION);
        }
    }

    public boolean userAccepted() {
        return this.canBeOk && super.userAccepted();
    }

    private MethodTypeDescription getInhOrOwnMember(ObjectTypeDescription object, String memberName) {
        MethodTypeDescription attributeMember;
        block1: {
            SuperType superType;
            attributeMember = object.getMember(memberName, 18);
            if (attributeMember != null) break block1;
            Iterator<SuperType> i$ = object.getSuperTypes().iterator();
            while (i$.hasNext() && (attributeMember = this.getInhOrOwnMember((superType = i$.next()).getObjectType(), memberName)) == null) {
            }
        }
        return attributeMember;
    }

    private XOUserObject getSelection() {
        TreePath selectionPath;
        TreePath treePath = selectionPath = this.tree != null ? this.tree.getSelectionPath() : null;
        if (selectionPath != null) {
            AttributesCheckTreeNode node = (AttributesCheckTreeNode)((Object)selectionPath.getLastPathComponent());
            XOUserObject userObject = node.getUserObject();
            if (userObject.member instanceof MethodTypeDescription && !this.doReject((MethodTypeDescription)userObject.member)) {
                return userObject;
            }
        }
        return null;
    }

    private void buildErrorPanel(Msg msg) {
        this.canBeOk = false;
        this.getContentPane().add((UiComponent)new LabelMultiline(this.getContentPane(), msg), (Object)"North");
    }

    private void buildMainPanel() {
        ObjectTypeDescription td;
        Panel contentPane = (Panel)this.getContentPane();
        ObjectTypeDescription iterationTd = td = this.objectTypeDescription;
        for (String currentPathPiece : this.path) {
            MethodTypeDescription attributeMember;
            boolean canContinue;
            boolean isGroup = currentPathPiece.endsWith("[]");
            if (isGroup) {
                currentPathPiece = currentPathPiece.substring(0, currentPathPiece.indexOf(91));
            }
            boolean bl = canContinue = (attributeMember = this.getInhOrOwnMember(iterationTd, currentPathPiece)) != null;
            if (canContinue) {
                if (isGroup) {
                    if (XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)attributeMember.asAttribute())) {
                        iterationTd = td = (ObjectTypeDescription)attributeMember.getResultType().getElementType();
                    } else {
                        canContinue = false;
                    }
                } else if (attributeMember.getResultType().isObject()) {
                    iterationTd = attributeMember.getResultType().asObject();
                } else {
                    canContinue = false;
                }
            }
            if (canContinue) continue;
            Msg errorMsg = currentPathPiece.equals("null") ? DesignerMsg.CHOOSE_PARENT_REFERENCE : DesignerMsg.CHOOSE_REFERENCE_INCOMPLETE_PATH_ERROR(currentPathPiece, this.pathString);
            this.buildErrorPanel(errorMsg);
            td = null;
            break;
        }
        if (td != null) {
            XOUserObject userObject = new XOUserObject(td);
            ReferenceTreeNode root = new ReferenceTreeNode(userObject);
            this.tree = new Tree((UiContainer)contentPane, (TreeNode)root);
            this.tree.setRootVisible(false);
            this.tree.expandPath(TreePath.createSinglePath((Object)((Object)root)));
            LabelProvider.Default<ReferenceTreeNode> labelProvider = new LabelProvider.Default<ReferenceTreeNode>(){

                public Image getIcon(ReferenceTreeNode element) {
                    ReferenceTreeNode node = element;
                    return node.getIcon();
                }

                public String getText(ReferenceTreeNode element) {
                    return String.valueOf((Object)element);
                }
            };
            this.tree.setLabelProvider((LabelProvider)labelProvider);
            if (this.currentReference != null) {
                String usagePath = this.currentReference;
                if (this.pathString != null && this.currentReference.startsWith(this.pathString)) {
                    usagePath = this.currentReference.substring(this.pathString.length());
                }
                StringTokenizer tok = new StringTokenizer(usagePath, ".");
                ReferenceTreeNode selectionNode = root;
                TreePath selectionPath = TreePath.createSinglePath((Object)((Object)selectionNode));
                while (tok.hasMoreTokens() && !selectionNode.isLeaf() && (selectionNode = selectionNode.getChild(tok.nextToken())) != null) {
                    selectionPath = selectionPath.pathByAddingChild((Object)selectionNode);
                }
                this.tree.setSelectionPath(selectionPath);
            }
            FormLayout panelLayout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, fill:min(200dlu;pref):grow");
            PanelBuilder builder = panelLayout.createBuilder(contentPane);
            CellConstraints cc = panelLayout.createCellConstraints();
            Label label = Label.create((UiContainer)contentPane, (Msg)(this.pathString == null ? DesignerMsg.CHOOSE_REFERENCE_DIALOG : DesignerMsg.CHOOSE_REFERENCE_LAST_PATH(this.pathString)));
            builder.add((UiComponent)label, cc.xy(2, 2));
            builder.add((UiComponent)this.tree, cc.xy(2, 4));
        }
    }

    private boolean doReject(MethodTypeDescription member) {
        boolean reject = true;
        for (int ref : this.ref) {
            if (member.getResultType().getKind() != ref) continue;
            reject = false;
            break;
        }
        return reject;
    }

    private void initRef(XFormXMLObject xmlObject) {
        if (xmlObject instanceof XFormPresentationXMLObject) {
            this.currentReference = ((XFormPresentationXMLObject)xmlObject).getReference();
        }
        try {
            Field field = xmlObject.getClass().getField("possibleReffering_d");
            this.ref = (int[])field.get(xmlObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ReferenceTreeNode
    extends AttributesCheckTreeNode {
        public ReferenceTreeNode(XOUserObject userObject) {
            super(userObject);
            this.allowGroupInGroup = false;
        }

        public ReferenceTreeNode getChild(String s) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                ReferenceTreeNode child = (ReferenceTreeNode)this.getChildAt(i);
                if (!s.equals(child.getUserObject())) continue;
                return child;
            }
            return null;
        }

        @Override
        protected AttributesCheckTreeNode createCheckTreeNode(XOUserObject userObj) {
            return new ReferenceTreeNode(userObj);
        }

        @Override
        protected boolean rejectMember(MethodTypeDescription member) {
            boolean reject = super.rejectMember(member);
            if (!reject && member.getResultType().getKind() != 11) {
                reject = ChooseReferenceDialog.this.doReject(member);
            }
            return reject;
        }
    }
}

