/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.outline.DataModelTreeNode;
import oracle.bpm.xobject.xml.XFormXMLObject;

public interface ChangeListener {
    public void changeOccured(ChangeEvent var1);

    public static class EventFactory {
        public static ChangeEvent createChange(String propertyName, Object newValue, XFormXMLObject object) {
            return new PropertyChangeEvent(propertyName, newValue, object);
        }

        public static ChangeEvent createChange(DataModelTreeNode parent) {
            return new ObjectChangeEvent(parent.getContent());
        }

        public static ChangeEvent createChange(XFormXMLObject nodeParent) {
            return new ObjectChangeEvent(nodeParent);
        }

        public static ChangeEvent createChange(Command command) {
            return new ChangeEvent();
        }

        public static ChangeEvent createTopLevelChange() {
            return new ChangeEvent(){

                @Override
                public boolean isTopLevelChange() {
                    return true;
                }
            };
        }
    }

    public static class PropertyChangeEvent
    extends ChangeEvent {
        private Object newValue;
        private XFormXMLObject object;
        private String propertyName;

        public PropertyChangeEvent(String propertyName, Object newValue, XFormXMLObject object) {
            this.propertyName = propertyName;
            this.newValue = newValue;
            this.object = object;
        }

        @Override
        public boolean isPropertyChange() {
            return true;
        }

        public XFormXMLObject getChangedObject() {
            return this.object;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class ObjectChangeEvent
    extends ChangeEvent {
        private final XFormXMLObject object;

        public ObjectChangeEvent(XFormXMLObject object) {
            this.object = object;
        }

        @Override
        public boolean isObjectChange() {
            return true;
        }

        public XFormXMLObject getObjectChange() {
            return this.object;
        }
    }

    public static class ChangeEvent {
        public boolean isPropertyChange() {
            return false;
        }

        public boolean isObjectChange() {
            return false;
        }

        public boolean isTopLevelChange() {
            return false;
        }

        public ObjectChangeEvent asObjectEvent() {
            return (ObjectChangeEvent)this;
        }

        public PropertyChangeEvent asPropertyChange() {
            return (PropertyChangeEvent)this;
        }
    }
}

