/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;

public class BasicMessageListener
implements MessageListener {
    private List<Report> errors = new ArrayList<Report>();
    private List<Report> warnings = new ArrayList<Report>();

    public String getErrorString() {
        StringBuffer buffer = new StringBuffer();
        for (Report error : this.errors) {
            buffer.append(error);
            buffer.append("\n");
        }
        String result = buffer.toString();
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    @Override
    public void reportError(CilException e) {
        this.errors.add(new Report(e));
    }

    @Override
    public void reportWarning(CilException e) {
        this.warnings.add(new Report(e));
    }

    private static class Report {
        private final int column;
        private final int line;
        private final String method;
        private final String msg;

        public Report(CilException cilException) {
            this(cilException.getMemberName(), cilException.getLine(), cilException.getColumn(), cilException.getMessage());
        }

        public Report(String method, int line, int column, String msg) {
            this.method = method;
            this.line = line;
            this.column = column;
            this.msg = msg;
        }

        public String toString() {
            return this.method + "(" + this.line + "," + this.column + "):" + this.msg;
        }
    }
}

